/*
 * Decompiled with CFR 0.152.
 */
package fuzs.partycreepers.handler;

import com.google.common.collect.ImmutableList;
import fuzs.partycreepers.PartyCreepers;
import fuzs.partycreepers.config.ServerConfig;
import fuzs.partycreepers.init.ModRegistry;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class CreeperConfettiHandler {
    private static final BlockParticleOption INVISIBLE_EXPLOSION_PARTICLES = new BlockParticleOption(ParticleTypes.BLOCK, Blocks.AIR.defaultBlockState());
    private static OptionalInt explosionBlockCount = OptionalInt.empty();

    public static EventResult onExplosionStart(ServerLevel serverLevel, ServerExplosion explosion) {
        Entity entity = explosion.getDirectSourceEntity();
        if (entity != null && entity.getType().is(ModRegistry.EXPLOSIVE_CREEPERS_ENTITY_TYPE_TAG)) {
            if (!(serverLevel.getRandom().nextDouble() < ((ServerConfig)PartyCreepers.CONFIG.get(ServerConfig.class)).confettiChance)) {
                return EventResult.PASS;
            }
            CreeperConfettiHandler.summonFireworkParticles(serverLevel, entity);
            int blockCount = explosion.explode();
            for (ServerPlayer serverPlayer : serverLevel.players()) {
                if (!(serverPlayer.distanceToSqr(explosion.center()) < 4096.0)) continue;
                Optional<Vec3> playerKnockback = Optional.ofNullable((Vec3)explosion.getHitPlayers().get(serverPlayer));
                serverPlayer.connection.send((Packet)new ClientboundExplodePacket(explosion.center(), explosion.radius(), explosionBlockCount.orElse(blockCount), playerKnockback, (ParticleOptions)INVISIBLE_EXPLOSION_PARTICLES, (Holder)SoundEvents.GENERIC_EXPLODE, ServerLevel.DEFAULT_EXPLOSION_BLOCK_PARTICLES));
            }
            explosionBlockCount = OptionalInt.empty();
            return EventResult.INTERRUPT;
        }
        return EventResult.PASS;
    }

    public static void onExplosionDetonate(ServerLevel serverLevel, ServerExplosion explosion, List<BlockPos> affectedBlocks, List<Entity> affectedEntities) {
        Entity entity = explosion.getDirectSourceEntity();
        if (entity != null && entity.getType().is(ModRegistry.EXPLOSIVE_CREEPERS_ENTITY_TYPE_TAG)) {
            explosionBlockCount = ((ServerConfig)PartyCreepers.CONFIG.get(ServerConfig.class)).dustParticles ? OptionalInt.of(affectedBlocks.size()) : OptionalInt.of(0);
            if (((ServerConfig)PartyCreepers.CONFIG.get(ServerConfig.class)).preventTerrainDamage) {
                affectedBlocks.clear();
            }
            affectedEntities.removeIf(Predicate.not(((ServerConfig)PartyCreepers.CONFIG.get(ServerConfig.class)).damageEntities::appliesTo));
        }
    }

    private static void summonFireworkParticles(ServerLevel serverLevel, Entity entity) {
        Creeper creeper;
        ItemStack itemStack = new ItemStack((ItemLike)Items.FIREWORK_ROCKET);
        boolean largeExplosion = entity instanceof Creeper && (creeper = (Creeper)entity).isPowered();
        itemStack.set(DataComponents.FIREWORKS, (Object)CreeperConfettiHandler.getFireworksComponent(serverLevel.getRandom(), largeExplosion));
        FireworkRocketEntity fireworkRocketEntity = new FireworkRocketEntity((Level)serverLevel, entity.getX(), entity.getEyeY(), entity.getZ(), itemStack);
        serverLevel.addFreshEntity((Entity)fireworkRocketEntity);
        serverLevel.broadcastEntityEvent((Entity)fireworkRocketEntity, (byte)17);
        fireworkRocketEntity.gameEvent((Holder)GameEvent.EXPLODE, fireworkRocketEntity.getOwner());
        fireworkRocketEntity.discard();
    }

    private static Fireworks getFireworksComponent(RandomSource randomSource, boolean largeExplosion) {
        ArrayList<FireworkExplosion> explosions = new ArrayList<FireworkExplosion>();
        IntList colors = IntList.of((int[])CreeperConfettiHandler.nextColorArray(randomSource));
        FireworkExplosion.Shape shape = largeExplosion ? FireworkExplosion.Shape.LARGE_BALL : FireworkExplosion.Shape.SMALL_BALL;
        explosions.add(new FireworkExplosion(shape, colors, IntLists.emptyList(), false, true));
        explosions.add(new FireworkExplosion(FireworkExplosion.Shape.BURST, colors, IntLists.emptyList(), true, false));
        return new Fireworks(0, (List)ImmutableList.copyOf(explosions));
    }

    private static int[] nextColorArray(RandomSource randomSource) {
        int[] colors = new int[randomSource.nextInt(5) + 4];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = CreeperConfettiHandler.nextColor(randomSource);
        }
        return colors;
    }

    private static int nextColor(RandomSource randomSource) {
        return ARGB.color((int)0, (int)CreeperConfettiHandler.nextColorComponent(randomSource), (int)CreeperConfettiHandler.nextColorComponent(randomSource), (int)CreeperConfettiHandler.nextColorComponent(randomSource));
    }

    private static int nextColorComponent(RandomSource randomSource) {
        return (int)(Mth.clamp((double)(randomSource.nextGaussian() / 6.0 + 0.5), (double)0.0, (double)1.0) * 255.0);
    }
}

