/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.clockwork.client.item.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.xylonity.bonsai.clockwork.client.item.model.BarrelCrossbowModel;
import dev.xylonity.bonsai.clockwork.client.util.ClientSwayUtil;
import dev.xylonity.bonsai.clockwork.common.item.BarrelCrossbow;
import dev.xylonity.bonsai.clockwork.registry.ClockworkItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoItemRenderer;

public class BarrelCrossbowRenderer
extends GeoItemRenderer<BarrelCrossbow> {
    private ItemDisplayContext lastTransform = ItemDisplayContext.NONE;
    private final ClientSwayUtil swayUtil = new ClientSwayUtil();

    public BarrelCrossbowRenderer() {
        super((GeoModel)new BarrelCrossbowModel());
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext ctx, PoseStack pose, MultiBufferSource buf, int light, int overlay) {
        this.lastTransform = ctx;
        if (ctx == ItemDisplayContext.GUI || ctx == ItemDisplayContext.GROUND || ctx == ItemDisplayContext.FIXED) {
            Minecraft minecraft = Minecraft.m_91087_();
            pose.m_85836_();
            if (ctx == ItemDisplayContext.GUI) {
                pose.m_85837_(0.5, 0.5, 0.0);
            } else if (ctx == ItemDisplayContext.GROUND) {
                pose.m_85837_(0.5, 0.5, 0.5);
            } else {
                pose.m_85837_(0.5, 0.5, 0.0);
                pose.m_85841_(0.75f, 0.75f, 0.75f);
            }
            ModelResourceLocation modelRl = new ModelResourceLocation("clockwork", this.getModelForState(stack, minecraft.f_91074_), "inventory");
            BakedModel model = minecraft.m_91304_().m_119422_(modelRl);
            if (model == minecraft.m_91304_().m_119409_()) {
                modelRl = new ModelResourceLocation("clockwork", "barrel_crossbow_standby", "inventory");
                model = minecraft.m_91304_().m_119422_(modelRl);
            }
            minecraft.m_91291_().m_115143_(stack, ctx, false, pose, buf, light, overlay, model);
            pose.m_85849_();
            return;
        }
        super.m_108829_(stack, ctx, pose, buf, light, overlay);
    }

    private String getModelForState(ItemStack stack, LocalPlayer player) {
        if (CrossbowItem.m_40932_((ItemStack)stack)) {
            if (CrossbowItem.m_40871_((ItemStack)stack, (Item)Items.f_42688_)) {
                return "barrel_crossbow_firework";
            }
            if (CrossbowItem.m_40871_((ItemStack)stack, (Item)((Item)ClockworkItems.CLOCKWORK_ARROW.get()))) {
                return "barrel_crossbow_clockworkarrow";
            }
            return "barrel_crossbow_arrow";
        }
        if (player != null && player.m_6117_() && player.m_21205_() == stack && !CrossbowItem.m_40932_((ItemStack)stack)) {
            float pullProgress = this.getPullProgress(stack, player);
            if (pullProgress >= 0.55f) {
                Minecraft minecraft = Minecraft.m_91087_();
                ItemStack projectileToLoad = null;
                if (minecraft.f_91074_ != null && minecraft.f_91074_.m_6117_() && minecraft.f_91074_.m_21211_().m_41720_() instanceof BarrelCrossbow) {
                    projectileToLoad = minecraft.f_91074_.m_6298_(stack);
                }
                if (projectileToLoad != null && !projectileToLoad.m_41619_()) {
                    if (projectileToLoad.m_150930_((Item)ClockworkItems.CLOCKWORK_ARROW.get())) {
                        return "barrel_crossbow_clockworkarrow";
                    }
                    if (projectileToLoad.m_150930_(Items.f_42688_)) {
                        return "barrel_crossbow_firework";
                    }
                }
                return "barrel_crossbow_arrow";
            }
            if (pullProgress >= 0.45f) {
                return "barrel_crossbow_pulling_2";
            }
            if (pullProgress >= 0.25f) {
                return "barrel_crossbow_pulling_1";
            }
            return "barrel_crossbow_pulling_0";
        }
        return "barrel_crossbow_standby";
    }

    private float getPullProgress(ItemStack stack, LocalPlayer player) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("barrel_load_start")) {
            return 0.0f;
        }
        long startTick = tag.m_128454_("barrel_load_start");
        long currentTick = player.m_9236_().m_46467_();
        int chargeDuration = BarrelCrossbow.getChargeDurationTicks(stack);
        if (chargeDuration <= 0) {
            return 0.0f;
        }
        long elapsed = currentTick - startTick;
        float progress = (float)elapsed / (float)chargeDuration;
        return Math.min(Math.max(progress, 0.0f), 1.0f);
    }

    public void preRender(PoseStack poseStack, BarrelCrossbow animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(poseStack, (Item)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        this.swayUtil.applyFirstPersonSway(poseStack, this.lastTransform, partialTick);
    }
}

