/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.clockwork.client.item.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.xylonity.bonsai.clockwork.client.item.model.ScopeCrossbowModel;
import dev.xylonity.bonsai.clockwork.client.util.ClientSwayUtil;
import dev.xylonity.bonsai.clockwork.common.item.ScopeCrossbow;
import dev.xylonity.bonsai.clockwork.registry.ClockworkItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoItemRenderer;

public class ScopeCrossbowRenderer
extends GeoItemRenderer<ScopeCrossbow> {
    private ItemDisplayContext lastTransform = ItemDisplayContext.NONE;
    private final ClientSwayUtil swayUtil = new ClientSwayUtil();

    public ScopeCrossbowRenderer() {
        super((GeoModel)new ScopeCrossbowModel());
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext ctx, PoseStack pose, MultiBufferSource buf, int light, int overlay) {
        this.lastTransform = ctx;
        if (ctx == ItemDisplayContext.GUI || ctx == ItemDisplayContext.GROUND || ctx == ItemDisplayContext.FIXED) {
            Minecraft mc = Minecraft.m_91087_();
            pose.m_85836_();
            if (ctx == ItemDisplayContext.GUI) {
                pose.m_85837_(0.5, 0.5, 0.0);
            } else if (ctx == ItemDisplayContext.GROUND) {
                pose.m_85837_(0.5, 0.5, 0.5);
            } else {
                pose.m_85837_(0.5, 0.5, 0.0);
                pose.m_85841_(0.75f, 0.75f, 0.75f);
            }
            ModelResourceLocation modelRl = new ModelResourceLocation("clockwork", this.getModelForState(stack, mc.f_91074_), "inventory");
            BakedModel model = mc.m_91304_().m_119422_(modelRl);
            if (model == mc.m_91304_().m_119409_()) {
                modelRl = new ModelResourceLocation("clockwork", "scope_crossbow_standby", "inventory");
                model = mc.m_91304_().m_119422_(modelRl);
            }
            mc.m_91291_().m_115143_(stack, ctx, false, pose, buf, light, overlay, model);
            pose.m_85849_();
            return;
        }
        super.m_108829_(stack, ctx, pose, buf, light, overlay);
    }

    private String getModelForState(ItemStack stack, LocalPlayer player) {
        if (CrossbowItem.m_40932_((ItemStack)stack)) {
            if (CrossbowItem.m_40871_((ItemStack)stack, (Item)Items.f_42688_)) {
                return "scope_crossbow_firework";
            }
            if (CrossbowItem.m_40871_((ItemStack)stack, (Item)((Item)ClockworkItems.CLOCKWORK_ARROW.get()))) {
                return "scope_crossbow_clockworkarrow";
            }
            return "scope_crossbow_arrow";
        }
        if (player != null && player.m_6117_() && player.m_21205_() == stack && !CrossbowItem.m_40932_((ItemStack)stack)) {
            float pullProgress = this.getPullProgress(stack, player);
            if (pullProgress >= 1.0f) {
                return "scope_crossbow_pulling_2";
            }
            if (pullProgress >= 0.58f) {
                return "scope_crossbow_pulling_1";
            }
            return "scope_crossbow_pulling_0";
        }
        return "scope_crossbow_standby";
    }

    private float getPullProgress(ItemStack stack, LocalPlayer player) {
        int useDuration = stack.m_41779_();
        int remaining = player.m_21212_();
        int chargeDuration = ScopeCrossbow.getChargeDurationTicks(stack);
        if (chargeDuration <= 0) {
            return 0.0f;
        }
        return Math.min(Math.max((float)(useDuration - remaining) / (float)chargeDuration, 0.0f), 1.0f);
    }

    public void preRender(PoseStack poseStack, ScopeCrossbow animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(poseStack, (Item)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        this.swayUtil.applyFirstPersonSway(poseStack, this.lastTransform, partialTick);
    }
}

