/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.clockwork.client.sound.handler.custom;

import dev.xylonity.bonsai.clockwork.client.sound.handler.SoundHandler;
import dev.xylonity.bonsai.clockwork.common.item.PotionSprayer;
import dev.xylonity.bonsai.clockwork.registry.ClockworkSounds;
import dev.xylonity.knightlib.mixin.AbstractTickableSoundInstanceAccessor;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public final class PotionSprayerSoundHandler
implements SoundHandler<Player> {
    private final Map<UUID, SprayerSoundState> stateByPlayer = new HashMap<UUID, SprayerSoundState>();

    @Override
    public boolean canHandle(Object object) {
        if (!(object instanceof Player)) {
            return false;
        }
        Player player = (Player)object;
        return player.m_21205_().m_41720_() instanceof PotionSprayer || player.m_21206_().m_41720_() instanceof PotionSprayer;
    }

    @Override
    public void tick(Player player) {
        UUID id = player.m_20148_();
        ItemStack sprayer = PotionSprayerSoundHandler.getSprayerItem(player);
        if (sprayer.m_41619_()) {
            this.stopAll(player);
            return;
        }
        SprayerSoundState state = this.stateByPlayer.get(id);
        if (PotionSprayerSoundHandler.isSpraying(sprayer)) {
            if (state == null) {
                state = new SprayerSoundState(player);
                this.stateByPlayer.put(id, state);
                state.startSpraying();
            } else {
                state.tick(player);
            }
        } else if (state != null && state.isActive()) {
            state.stopSpraying();
            this.stateByPlayer.remove(id);
        }
    }

    @Override
    public void stopAll(Player player) {
        SprayerSoundState state = this.stateByPlayer.remove(player.m_20148_());
        if (state != null) {
            state.stopSpraying();
        }
    }

    @Override
    public void clear() {
        this.stateByPlayer.values().forEach(SprayerSoundState::forceStop);
        this.stateByPlayer.clear();
    }

    private static ItemStack getSprayerItem(Player player) {
        ItemStack main = player.m_21205_();
        if (main.m_41720_() instanceof PotionSprayer) {
            return main;
        }
        ItemStack off = player.m_21206_();
        if (off.m_41720_() instanceof PotionSprayer) {
            return off;
        }
        return ItemStack.f_41583_;
    }

    private static boolean isSpraying(ItemStack stack) {
        return stack.m_41782_() && stack.m_41784_().m_128471_("clockwork_spraying");
    }

    private static void play(AbstractTickableSoundInstance s) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.m_91106_() != null) {
            minecraft.m_91106_().m_120367_((SoundInstance)s);
        }
    }

    private static void playOnce(SoundEvent event, Player player) {
        if (player == null) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.m_91106_() != null) {
            minecraft.m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance(event, SoundSource.PLAYERS, 0.6f, 1.0f, SoundInstance.m_235150_(), (double)((float)player.m_20185_()), (double)((float)player.m_20186_()), (double)((float)player.m_20189_())));
        }
    }

    private static void stopImmediate(AbstractTickableSoundInstance s) {
        if (s != null) {
            ((AbstractTickableSoundInstanceAccessor)s).stopAccessor();
        }
    }

    private static class SprayerSoundState {
        private final UUID playerId;
        private SprayerLoop loopSound;
        private boolean active = false;

        SprayerSoundState(Player player) {
            this.playerId = player.m_20148_();
        }

        void startSpraying() {
            if (this.active) {
                return;
            }
            this.active = true;
            Player player = this.getPlayer();
            if (player == null) {
                return;
            }
            PotionSprayerSoundHandler.playOnce((SoundEvent)ClockworkSounds.SPRAYER_START.get(), player);
            if (this.loopSound == null || this.loopSound.m_7801_()) {
                this.loopSound = new SprayerLoop((SoundEvent)ClockworkSounds.SPRAYER_LOOP.get(), player);
                PotionSprayerSoundHandler.play(this.loopSound);
            } else {
                this.loopSound.updatePosition(player);
            }
        }

        void tick(Player player) {
            if (!this.active) {
                return;
            }
            if (this.loopSound == null || this.loopSound.m_7801_()) {
                this.loopSound = new SprayerLoop((SoundEvent)ClockworkSounds.SPRAYER_LOOP.get(), player);
                PotionSprayerSoundHandler.play(this.loopSound);
            } else {
                this.loopSound.updatePosition(player);
            }
        }

        void stopSpraying() {
            if (!this.active) {
                return;
            }
            PotionSprayerSoundHandler.stopImmediate(this.loopSound);
            this.loopSound = null;
            Player player = this.getPlayer();
            if (player != null) {
                PotionSprayerSoundHandler.playOnce((SoundEvent)ClockworkSounds.SPRAYER_END.get(), player);
            }
            this.active = false;
        }

        void forceStop() {
            PotionSprayerSoundHandler.stopImmediate(this.loopSound);
            this.loopSound = null;
            this.active = false;
        }

        boolean isActive() {
            return this.active;
        }

        private Player getPlayer() {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91073_ == null) {
                return null;
            }
            return minecraft.f_91073_.m_46003_(this.playerId);
        }
    }

    private static final class SprayerLoop
    extends AbstractTickableSoundInstance {
        private Player player;

        SprayerLoop(SoundEvent event, Player player) {
            super(event, SoundSource.PLAYERS, SoundInstance.m_235150_());
            this.player = player;
            this.f_119578_ = true;
            this.f_119579_ = 0;
            this.f_119573_ = 0.5f;
            this.f_119574_ = 1.0f;
            this.f_119575_ = (float)player.m_20185_();
            this.f_119576_ = (float)player.m_20186_();
            this.f_119577_ = (float)player.m_20189_();
        }

        void updatePosition(Player p) {
            if (p != null) {
                this.player = p;
                this.f_119575_ = (float)p.m_20185_();
                this.f_119576_ = (float)p.m_20186_();
                this.f_119577_ = (float)p.m_20189_();
            }
        }

        public void m_7788_() {
            if (this.player == null || this.player.m_213877_() || !this.player.m_9236_().f_46443_) {
                this.m_119609_();
                return;
            }
            this.f_119575_ = (float)this.player.m_20185_();
            this.f_119576_ = (float)this.player.m_20186_();
            this.f_119577_ = (float)this.player.m_20189_();
            ItemStack main = this.player.m_21205_();
            ItemStack off = this.player.m_21206_();
            boolean spraying = false;
            ItemStack stack = ItemStack.f_41583_;
            if (main.m_41720_() instanceof PotionSprayer) {
                stack = main;
            } else if (off.m_41720_() instanceof PotionSprayer) {
                stack = off;
            }
            if (!stack.m_41619_()) {
                boolean bl = spraying = stack.m_41782_() && stack.m_41784_().m_128471_("clockwork_spraying");
            }
            if (!(main.m_41720_() instanceof PotionSprayer) && !(off.m_41720_() instanceof PotionSprayer) || !spraying) {
                this.m_119609_();
            }
        }
    }
}

