/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.clockwork.common.entity.passive;

import dev.xylonity.bonsai.clockwork.client.sound.Sounds;
import dev.xylonity.bonsai.clockwork.common.entity.PassiveClockworkEntity;
import dev.xylonity.bonsai.clockwork.config.ClockworkConfig;
import dev.xylonity.bonsai.clockwork.network.packets.DragonflyAscendKeyC2SPacket;
import dev.xylonity.bonsai.clockwork.registry.ClockworkItems;
import dev.xylonity.bonsai.clockwork.registry.ClockworkSounds;
import dev.xylonity.knightlib.api.network.Network;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class DragonflyEntity
extends PassiveClockworkEntity
implements PlayerRideable {
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation FLY = RawAnimation.begin().thenPlay("fly");
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation DEATH = RawAnimation.begin().thenPlay("death");
    private final RawAnimation ACTIVATE = RawAnimation.begin().thenPlay("activate");
    public static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(DragonflyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> ASCENDING = SynchedEntityData.m_135353_(DragonflyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> ACTIVATING_TICKS = SynchedEntityData.m_135353_(DragonflyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final int ANIMATION_ACTIVATE_TICKS = 28;

    public DragonflyEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder setAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, ClockworkConfig.DRAGONFLY_DEFAULT_HEALTH).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, ClockworkConfig.DRAGONFLY_DEFAULT_WALKING_SPEED).m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22280_, ClockworkConfig.DRAGONFLY_DEFAULT_FLYING_SPEED);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STATE, (Object)0);
        this.f_19804_.m_135372_(ASCENDING, (Object)false);
        this.f_19804_.m_135372_(ACTIVATING_TICKS, (Object)-1);
    }

    public void setState(int state) {
        this.f_19804_.m_135381_(STATE, (Object)state);
    }

    public int getState() {
        return (Integer)this.f_19804_.m_135370_(STATE);
    }

    public void setAscending(boolean ascending) {
        this.f_19804_.m_135381_(ASCENDING, (Object)ascending);
    }

    public boolean isAscending() {
        return (Boolean)this.f_19804_.m_135370_(ASCENDING);
    }

    public void setActivatingTicks(int activatingTicks) {
        this.f_19804_.m_135381_(ACTIVATING_TICKS, (Object)activatingTicks);
    }

    public int getActivatingTicks() {
        return (Integer)this.f_19804_.m_135370_(ACTIVATING_TICKS);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.m_20096_()) {
                this.setState(0);
            }
            if (this.m_6688_() == null && !this.m_20096_() && this.getState() == 1) {
                this.m_20334_(this.m_20184_().f_82479_, -0.1, this.m_20184_().f_82481_);
            }
            if (this.getActivatingTicks() >= 0 && this.getActivatingTicks() <= 28) {
                this.setActivatingTicks(this.getActivatingTicks() + 1);
            }
        }
        if (this.m_9236_().f_46443_) {
            Sounds.proxy().tickSounds((Entity)this);
        }
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource source) {
        return this.getState() != 1;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (this.m_9236_().f_46443_) {
            Sounds.proxy().stopAllFor((Entity)this);
        }
        super.m_142687_(reason);
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (player.m_21120_(hand).m_41720_() == ClockworkItems.CLOCKWORK_GEAR.get() && this.m_21223_() < this.m_21233_()) {
            if (this.m_9236_().f_46443_) {
                return InteractionResult.SUCCESS;
            }
            this.m_5634_((float)ClockworkConfig.CLOCKWORK_GEAR_HEAL_AMOUNT);
            if (!player.m_150110_().f_35937_) {
                player.m_21120_(hand).m_41774_(1);
            }
            this.generateHealParticles();
            this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)ClockworkSounds.DRAGONFLY_GEAR.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (!player.m_36341_()) {
            if (!this.m_9236_().m_5776_()) {
                player.m_7998_((Entity)this, true);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        return super.m_6071_(player, hand);
    }

    private void generateHealParticles() {
        for (int i = 0; i < 20; ++i) {
            double dx = (this.f_19796_.m_188500_() - 0.5) * 1.25;
            double dy = (this.f_19796_.m_188500_() - 0.5) * 1.25;
            double dz = (this.f_19796_.m_188500_() - 0.5) * 1.25;
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            level2.m_8767_((ParticleOptions)ParticleTypes.f_123749_, this.m_20182_().f_82479_, this.m_20186_() + (double)this.m_20206_() * Math.random(), this.m_20182_().f_82481_, 1, dx, dy, dz, 0.1);
        }
    }

    public LivingEntity m_6688_() {
        Object e;
        if (!this.m_20197_().isEmpty() && (e = this.m_20197_().get(0)) instanceof LivingEntity) {
            LivingEntity rider = (LivingEntity)e;
            return rider;
        }
        return null;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("StateMachine", this.getState());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("StateMachine")) {
            this.setState(compound.m_128451_("StateMachine"));
        }
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction positioner) {
        super.m_19956_(passenger, positioner);
        if (passenger instanceof LivingEntity) {
            passenger.m_6034_(this.m_20185_(), this.m_20186_() + 0.2, this.m_20189_());
        }
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ClockworkSounds.DRAGONFLY_HURT.get();
    }

    public boolean m_20068_() {
        return this.getState() == 1 || super.m_20068_();
    }

    public void m_7023_(Vec3 travelVector) {
        if (!this.m_6084_()) {
            super.m_7023_(travelVector);
            return;
        }
        LivingEntity rider = this.m_6688_();
        if (this.m_20160_() && rider != null) {
            float baseTurn = this.getState() == 1 ? 18.0f : 12.0f;
            float step = baseTurn + Mth.m_14154_((float)Mth.m_14177_((float)(rider.m_146908_() - this.m_146908_()))) * 0.35f + Mth.m_14154_((float)Mth.m_14177_((float)(rider.m_146908_() - rider.f_19859_))) * 0.65f;
            step = Mth.m_14036_((float)step, (float)baseTurn, (float)50.0f);
            this.m_146922_(Mth.m_14148_((float)this.m_146908_(), (float)rider.m_146908_(), (float)step));
            this.f_19859_ = this.m_146908_();
            this.m_146926_(rider.m_146909_() * 0.5f);
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.f_20883_ = this.m_146908_();
            this.f_20885_ = this.m_146908_();
            float strafe = rider.f_20900_;
            float forward = rider.f_20902_;
            if (this.getState() == 1) {
                double capSpeed = this.m_21133_(Attributes.f_22280_) * 0.95;
                Vec3 look = rider.m_20154_().m_82541_();
                Vec3 right = new Vec3(0.0, 1.0, 0.0).m_82537_(look).m_82541_();
                right = right.m_82556_() < 1.0E-6 ? new Vec3(1.0, 0.0, 0.0) : new Vec3(right.f_82479_, 0.0, right.f_82481_).m_82541_();
                Vec3 deltaMovement = this.m_20184_().m_82490_(0.9);
                Vec3 delta = look.m_82490_((double)forward * capSpeed).m_82549_(right.m_82490_((double)strafe * capSpeed * 0.8)).m_82546_(deltaMovement);
                deltaMovement = deltaMovement.m_82549_(delta.m_82490_(0.35));
                double horizontal = Math.sqrt(deltaMovement.f_82479_ * deltaMovement.f_82479_ + deltaMovement.f_82481_ * deltaMovement.f_82481_);
                if (horizontal > capSpeed) {
                    double scale = capSpeed / Math.max(horizontal, 1.0E-6);
                    deltaMovement = new Vec3(deltaMovement.f_82479_ * scale, deltaMovement.f_82480_, deltaMovement.f_82481_ * scale);
                }
                double maxY = capSpeed * 0.6;
                deltaMovement = new Vec3(deltaMovement.f_82479_, Mth.m_14008_((double)deltaMovement.f_82480_, (double)(-maxY), (double)maxY), deltaMovement.f_82481_);
                this.m_20256_(deltaMovement);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.f_19789_ = 0.0f;
            } else {
                this.m_7910_((float)this.m_21133_(Attributes.f_22279_) * 0.65f);
                super.m_7023_(new Vec3((double)(strafe * 0.75f), travelVector.f_82480_, (double)(forward * 0.85f)));
            }
        } else {
            super.m_7023_(travelVector);
        }
        if (this.isAscending()) {
            this.m_20334_(this.m_20184_().f_82479_, this.m_20184_().f_82480_ + 0.25, this.m_20184_().f_82481_);
            Network.sendToServer((Object)new DragonflyAscendKeyC2SPacket(false));
        }
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ >= 38 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHit) {
        super.m_7472_(source, looting, recentlyHit);
        this.m_19983_(new ItemStack((ItemLike)ClockworkItems.CLOCKWORK_GEAR.get(), this.f_19796_.m_188503_(3)));
        this.m_19983_(new ItemStack((ItemLike)Items.f_151052_, this.f_19796_.m_188503_(3)));
        this.m_19983_(new ItemStack((ItemLike)Items.f_42417_, this.f_19796_.m_188503_(3)));
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.m_21224_()) {
            event.setAnimation(this.DEATH);
        } else if (this.getActivatingTicks() >= 0 && this.getActivatingTicks() <= 28) {
            event.setAnimation(this.ACTIVATE);
        } else if (this.getState() == 1) {
            event.setAnimation(this.FLY);
        } else if (event.isMoving()) {
            event.setAnimation(this.WALK);
        } else {
            event.setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }
}

