/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.clockwork.common.item;

import dev.xylonity.bonsai.clockwork.Clockwork;
import dev.xylonity.bonsai.clockwork.client.item.renderer.BarrelCrossbowRenderer;
import dev.xylonity.bonsai.clockwork.common.entity.projectile.ClockworkArrowProjectile;
import dev.xylonity.bonsai.clockwork.common.item.ScopeCrossbow;
import dev.xylonity.bonsai.clockwork.registry.ClockworkItems;
import dev.xylonity.bonsai.clockwork.registry.ClockworkSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.event.ForgeEventFactory;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class BarrelCrossbow
extends CrossbowItem
implements GeoItem {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public static final String NBT_LOAD_START_TICK = "barrel_load_start";
    public static final String NBT_LOAD_VARIANT = "barrel_load_variant";
    public static final String NBT_LOAD_PLAYED = "barrel_load_played";
    public static final String NBT_ANIM_PHASE = "barrel_anim_phase";
    public static final String NBT_CAN_LOAD = "barrel_can_load";
    public static final String NBT_NEXT_ACTION_TICK = "barrel_next_action";
    private static final RawAnimation SHOOT = RawAnimation.begin().thenPlay("shoot");
    private static final RawAnimation LOAD = RawAnimation.begin().thenPlay("load");
    private static final RawAnimation LOAD_QUICKCHARGE_1 = RawAnimation.begin().thenPlay("load_quickcharge_1");
    private static final RawAnimation LOAD_QUICKCHARGE_2 = RawAnimation.begin().thenPlay("load_quickcharge_2");
    private static final RawAnimation LOAD_QUICKCHARGE_3 = RawAnimation.begin().thenPlay("load_quickcharge_3");
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");
    private static final float DURATION_QUICKCHARGE_0 = 0.5f;
    private static final float DURATION_QUICKCHARGE_1 = 0.46f;
    private static final float DURATION_QUICKCHARGE_2 = 0.42f;
    private static final float DURATION_QUICKCHARGE_3 = 0.38f;
    private static final RawAnimation[] LOAD_VARIANTS = new RawAnimation[]{LOAD, LOAD_QUICKCHARGE_1, LOAD_QUICKCHARGE_2, LOAD_QUICKCHARGE_3};
    private static final float[] LOAD_DURATIONS = new float[]{0.5f, 0.46f, 0.42f, 0.38f};
    private static final int PHASE_IDLE = 0;
    private static final int PHASE_LOADING = 1;
    private static final int PHASE_LOADED = 2;
    private static final int PHASE_SHOOTING = 3;
    private static final int ANIMATION_SHOOT_TICKS = 3;
    private static final float LOAD_SOUND_PROGRESS = 0.2f;
    private static final float VANILLA_ARROW_VEL = 3.15f;
    private static final float VANILLA_FIREWORK_VEL = 1.28f;
    private boolean cwLoadingPlayedStart = false;

    private static float baseVelocityFor(ItemStack stack) {
        return BarrelCrossbow.m_40871_((ItemStack)stack, (Item)Items.f_42688_) ? 1.28f : 3.15f;
    }

    public BarrelCrossbow(Item.Properties properties) {
        super(properties);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public static int getQuickChargeLevel(ItemStack stack) {
        int quickCharge = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)stack);
        if (quickCharge < 0) {
            return 0;
        }
        return Math.min(quickCharge, 3);
    }

    public static int getChargeDurationTicks(ItemStack stack) {
        return Math.max(1, Math.round(LOAD_DURATIONS[BarrelCrossbow.getQuickChargeLevel(stack)] * 20.0f));
    }

    private static void setPhase(ItemStack stack, int phase) {
        stack.m_41784_().m_128405_(NBT_ANIM_PHASE, phase);
    }

    private static int getPhase(ItemStack stack) {
        return stack.m_41784_().m_128451_(NBT_ANIM_PHASE);
    }

    private static void setNextActionTick(ItemStack stack, long tick) {
        stack.m_41784_().m_128356_(NBT_NEXT_ACTION_TICK, tick);
    }

    private static long getNextActionTick(ItemStack stack) {
        return stack.m_41784_().m_128454_(NBT_NEXT_ACTION_TICK);
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.CROSSBOW;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private BarrelCrossbowRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new BarrelCrossbowRenderer();
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "state", 1, this::statePredicate).setSoundKeyframeHandler(event -> Clockwork.PROXY.playScopeCrossbowSound())});
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "fire", 1, this::firePredicate).triggerableAnim("shoot", SHOOT)});
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (BarrelCrossbow.m_40932_((ItemStack)stack)) {
            if (!level.f_46443_) {
                this.triggerShoot(stack, (LivingEntity)player);
                BarrelCrossbow.performShootingCW(level, (LivingEntity)player, hand, stack, BarrelCrossbow.baseVelocityFor(stack), 1.0f);
                BarrelCrossbow.m_40884_((ItemStack)stack, (boolean)false);
                BarrelCrossbow.clearLoadFlags(stack);
                BarrelCrossbow.setPhase(stack, 3);
                BarrelCrossbow.setNextActionTick(stack, level.m_46467_() + 3L);
                if (BarrelCrossbow.hasLoadableAmmo((LivingEntity)player, stack)) {
                    player.m_6672_(hand);
                } else {
                    BarrelCrossbow.setPhase(stack, 0);
                }
            }
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        if (!BarrelCrossbow.hasLoadableAmmo((LivingEntity)player, stack)) {
            BarrelCrossbow.setPhase(stack, 0);
            stack.m_41784_().m_128379_(NBT_CAN_LOAD, false);
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (!level.f_46443_) {
            long now = level.m_46467_();
            BarrelCrossbow.markLoadStart(stack, now, BarrelCrossbow.getQuickChargeLevel(stack));
            BarrelCrossbow.setPhase(stack, 1);
            BarrelCrossbow.setNextActionTick(stack, now + (long)BarrelCrossbow.getChargeDurationTicks(stack));
            this.cwLoadingPlayedStart = false;
            stack.m_41784_().m_128379_(NBT_CAN_LOAD, true);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int remainingUseDuration) {
        if (level.f_46443_) {
            return;
        }
        int phase = BarrelCrossbow.getPhase(stack);
        long now = level.m_46467_();
        if (!BarrelCrossbow.hasLoadableAmmo(entity, stack) && !BarrelCrossbow.m_40932_((ItemStack)stack) && phase != 3) {
            entity.m_5810_();
            BarrelCrossbow.setPhase(stack, 0);
            stack.m_41784_().m_128379_(NBT_CAN_LOAD, false);
            BarrelCrossbow.clearLoadFlags(stack);
            return;
        }
        if (phase == 1) {
            int chargeTicks;
            long start = stack.m_41784_().m_128454_(NBT_LOAD_START_TICK);
            float progress = Math.max(0.0f, Math.min(1.0f, (float)(now - start) / (float)(chargeTicks = BarrelCrossbow.getChargeDurationTicks(stack))));
            if (progress < 0.2f) {
                this.cwLoadingPlayedStart = false;
            }
            if (progress >= 0.2f && !this.cwLoadingPlayedStart) {
                this.cwLoadingPlayedStart = true;
                level.m_5594_(null, entity.m_20183_(), (SoundEvent)ClockworkSounds.CLOCKWORK_BARREL_CROSSBOW_LOADING.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
            }
        }
        long next = BarrelCrossbow.getNextActionTick(stack);
        switch (phase) {
            case 1: {
                if (now < next) break;
                BarrelCrossbow.avoidVanillaSounds(level, entity, stack);
                if (BarrelCrossbow.m_40932_((ItemStack)stack)) {
                    this.triggerShoot(stack, entity);
                    BarrelCrossbow.performShootingCW(level, entity, entity.m_7655_(), stack, BarrelCrossbow.baseVelocityFor(stack), 1.0f);
                    BarrelCrossbow.m_40884_((ItemStack)stack, (boolean)false);
                    BarrelCrossbow.clearLoadFlags(stack);
                    BarrelCrossbow.setPhase(stack, 3);
                    BarrelCrossbow.setNextActionTick(stack, now + 3L);
                    break;
                }
                entity.m_5810_();
                BarrelCrossbow.setPhase(stack, 0);
                BarrelCrossbow.clearLoadFlags(stack);
                break;
            }
            case 2: {
                if (now < next) break;
                this.triggerShoot(stack, entity);
                BarrelCrossbow.performShootingCW(level, entity, entity.m_7655_(), stack, BarrelCrossbow.baseVelocityFor(stack), 1.0f);
                BarrelCrossbow.m_40884_((ItemStack)stack, (boolean)false);
                BarrelCrossbow.clearLoadFlags(stack);
                BarrelCrossbow.setPhase(stack, 3);
                BarrelCrossbow.setNextActionTick(stack, now + 3L);
                break;
            }
            case 3: {
                if (now < next) break;
                if (BarrelCrossbow.hasLoadableAmmo(entity, stack)) {
                    BarrelCrossbow.markLoadStart(stack, now, BarrelCrossbow.getQuickChargeLevel(stack));
                    BarrelCrossbow.setPhase(stack, 1);
                    BarrelCrossbow.setNextActionTick(stack, now + (long)BarrelCrossbow.getChargeDurationTicks(stack));
                    this.cwLoadingPlayedStart = false;
                    stack.m_41784_().m_128379_(NBT_CAN_LOAD, true);
                    break;
                }
                entity.m_5810_();
                BarrelCrossbow.setPhase(stack, 0);
                stack.m_41784_().m_128379_(NBT_CAN_LOAD, false);
                BarrelCrossbow.clearLoadFlags(stack);
                break;
            }
        }
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity user, int timeLeft) {
        BarrelCrossbow.setPhase(stack, 0);
        stack.m_41784_().m_128379_(NBT_CAN_LOAD, false);
        BarrelCrossbow.clearLoadFlags(stack);
    }

    private <T extends GeoAnimatable> PlayState statePredicate(AnimationState<T> event) {
        LivingEntity user;
        LivingEntity le;
        ItemStack stack = (ItemStack)event.getData(DataTickets.ITEMSTACK);
        if (stack == null || stack.m_41619_()) {
            return PlayState.STOP;
        }
        Entity entity = (Entity)event.getData(DataTickets.ENTITY);
        Object object = entity instanceof LivingEntity ? (le = (LivingEntity)entity) : (user = Clockwork.PROXY.getClientPlayer() != null ? Clockwork.PROXY.getClientPlayer() : null);
        if (user == null) {
            return PlayState.STOP;
        }
        int phase = BarrelCrossbow.getPhase(stack);
        CompoundTag tag = stack.m_41784_();
        int variant = BarrelCrossbow.clampVariant(stack);
        if (BarrelCrossbow.m_40932_((ItemStack)stack) || phase == 2) {
            return PlayState.CONTINUE;
        }
        if (phase == 1) {
            if (!tag.m_128471_(NBT_LOAD_PLAYED)) {
                event.getController().setAnimationSpeed((double)this.speedForVariant(variant));
                event.setAndContinue(LOAD_VARIANTS[variant]);
                tag.m_128379_(NBT_LOAD_PLAYED, true);
            }
            return PlayState.CONTINUE;
        }
        event.setAndContinue(IDLE);
        return PlayState.CONTINUE;
    }

    private float speedForVariant(int variant) {
        return 1.0f / Math.max(0.001f, BarrelCrossbow.getChargeDurationSecondsFromTicksVariant(variant));
    }

    private static float getChargeDurationSecondsFromTicksVariant(int variant) {
        variant = BarrelCrossbow.clampVariant(variant);
        int ticks = Math.max(1, Math.round(LOAD_DURATIONS[variant] * 20.0f));
        return (float)ticks / 20.0f;
    }

    private <T extends GeoAnimatable> PlayState firePredicate(AnimationState<T> e) {
        e.getController().setAnimationSpeed(1.0);
        return PlayState.CONTINUE;
    }

    private void triggerShoot(ItemStack stack, LivingEntity user) {
        if (user.m_9236_() instanceof ServerLevel) {
            this.triggerAnim((Entity)user, GeoItem.getId((ItemStack)stack), "fire", "shoot");
        }
    }

    private static void avoidVanillaSounds(Level level, LivingEntity entity, ItemStack stack) {
        if (BarrelCrossbow.m_40932_((ItemStack)stack)) {
            return;
        }
        if (BarrelCrossbow.m_40859_(entity, stack)) {
            BarrelCrossbow.m_40884_((ItemStack)stack, (boolean)true);
            level.m_5594_(null, entity.m_20183_(), (SoundEvent)ClockworkSounds.CLOCKWORK_CROSSBOW_LOADING_END.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    private static boolean hasLoadableAmmo(LivingEntity user, ItemStack crossbowStack) {
        ItemStack ammo;
        if (user instanceof Player) {
            Player player = (Player)user;
            if (player.m_150110_().f_35937_) {
                return true;
            }
        }
        return !(ammo = user.m_6298_(crossbowStack)).m_41619_() && ammo.m_41720_() instanceof ArrowItem || ammo.m_41720_() == Items.f_42688_;
    }

    private static void performShootingCW(Level level, LivingEntity shooter, InteractionHand usedHand, ItemStack crossbowStack, float velocity, float inaccuracy) {
        if (shooter instanceof Player) {
            Player player = (Player)shooter;
            if (ForgeEventFactory.onArrowLoose((ItemStack)crossbowStack, (Level)shooter.m_9236_(), (Player)player, (int)1, (boolean)true) < 0) {
                return;
            }
        }
        List<ItemStack> list = BarrelCrossbow.m_40941_(crossbowStack);
        float[] pitches = BarrelCrossbow.m_220023_(shooter.m_217043_());
        for (int i = 0; i < list.size(); ++i) {
            boolean creative;
            ItemStack ammo = list.get(i);
            boolean bl = creative = shooter instanceof Player && ((Player)shooter).m_150110_().f_35937_;
            if (ammo.m_41619_()) continue;
            if (i == 0) {
                BarrelCrossbow.shootProjectileCW(level, shooter, usedHand, crossbowStack, ammo, pitches[i], creative, velocity * 0.7f, inaccuracy, 0.0f);
                continue;
            }
            if (i == 1) {
                BarrelCrossbow.shootProjectileCW(level, shooter, usedHand, crossbowStack, ammo, pitches[i], creative, velocity * 0.7f, inaccuracy, -10.0f);
                continue;
            }
            if (i != 2) continue;
            BarrelCrossbow.shootProjectileCW(level, shooter, usedHand, crossbowStack, ammo, pitches[i], creative, velocity * 0.7f, inaccuracy, 10.0f);
        }
        BarrelCrossbow.onCrossbowShotCW(crossbowStack);
    }

    private static void shootProjectileCW(Level level, LivingEntity shooter, InteractionHand hand, ItemStack crossbowStack, ItemStack ammoStack, float soundPitch, boolean creativeOnlyPickup, float velocity, float inaccuracy, float angleDeg) {
        FireworkRocketEntity proj;
        if (level.f_46443_) {
            return;
        }
        if (ammoStack.m_150930_(Items.f_42688_)) {
            proj = new FireworkRocketEntity(level, ammoStack, (Entity)shooter, shooter.m_20185_(), shooter.m_20188_() - 0.15000000596, shooter.m_20189_(), true);
        } else {
            ArrowItem arrowItem = (ArrowItem)(ammoStack.m_41720_() instanceof ArrowItem ? ammoStack.m_41720_() : Items.f_42412_);
            AbstractArrow arrow = arrowItem.m_6394_(level, ammoStack, shooter);
            if (shooter instanceof Player) {
                arrow.m_36762_(true);
            }
            arrow.m_36793_(true);
            int pierce = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)crossbowStack);
            if (pierce > 0) {
                arrow.m_36767_((byte)pierce);
            }
            if (creativeOnlyPickup || angleDeg != 0.0f) {
                arrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
            }
            if (arrow instanceof ClockworkArrowProjectile) {
                ClockworkArrowProjectile clockworkArrow = (ClockworkArrowProjectile)arrow;
                LivingEntity target = ScopeCrossbow.searchForwardTarget(level, shooter, 128.0);
                if (target != null) {
                    clockworkArrow.setTarget(target);
                }
            }
            proj = arrow;
        }
        if (shooter instanceof CrossbowAttackMob) {
            CrossbowAttackMob mob = (CrossbowAttackMob)shooter;
            mob.m_5811_(mob.m_5448_(), crossbowStack, (Projectile)proj, angleDeg);
        } else {
            Vec3 up = shooter.m_20289_(1.0f);
            Vec3 look = shooter.m_20252_(1.0f);
            Vector3f dir = look.m_252839_().rotate((Quaternionfc)new Quaternionf().setAngleAxis((double)(angleDeg * ((float)Math.PI / 180)), up.f_82479_, up.f_82480_, up.f_82481_));
            proj.m_6686_((double)dir.x(), (double)dir.y(), (double)dir.z(), velocity, inaccuracy);
        }
        crossbowStack.m_41622_(ammoStack.m_150930_(Items.f_42688_) ? 3 : 1, shooter, b -> b.m_21190_(hand));
        level.m_7967_((Entity)proj);
        level.m_5594_(null, shooter.m_20183_(), (SoundEvent)ClockworkSounds.CLOCKWORK_CROSSBOW_SHOOT.get(), SoundSource.PLAYERS, 1.0f, soundPitch);
    }

    private static void onCrossbowShotCW(ItemStack crossbowStack) {
        BarrelCrossbow.m_40943_(crossbowStack);
    }

    private static List<ItemStack> m_40941_(ItemStack crossbowStack) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        CompoundTag tag = crossbowStack.m_41783_();
        if (tag != null && tag.m_128425_("ChargedProjectiles", 9)) {
            ListTag listtag = tag.m_128437_("ChargedProjectiles", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                list.add(ItemStack.m_41712_((CompoundTag)listtag.m_128728_(i)));
            }
        }
        return list;
    }

    private static void m_40943_(ItemStack crossbowStack) {
        CompoundTag tag = crossbowStack.m_41783_();
        if (tag != null) {
            ListTag list = tag.m_128437_("ChargedProjectiles", 9);
            list.clear();
            tag.m_128365_("ChargedProjectiles", (Tag)list);
        }
    }

    private static boolean m_40859_(LivingEntity shooter, ItemStack crossbowStack) {
        int multishot = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)crossbowStack);
        int shots = multishot == 0 ? 1 : 3;
        boolean creative = shooter instanceof Player && ((Player)shooter).m_150110_().f_35937_;
        ItemStack ammo = shooter.m_6298_(crossbowStack);
        ItemStack ammoCopy = ammo.m_41777_();
        for (int k = 0; k < shots; ++k) {
            if (k > 0) {
                ammo = ammoCopy.m_41777_();
            }
            if (ammo.m_41619_() && creative) {
                ammo = new ItemStack((ItemLike)Items.f_42412_);
                ammoCopy = ammo.m_41777_();
            }
            if (BarrelCrossbow.m_40862_(shooter, crossbowStack, ammo, k > 0, creative)) continue;
            return false;
        }
        return true;
    }

    private static boolean m_40862_(LivingEntity shooter, ItemStack crossbowStack, ItemStack ammo, boolean hasAmmo, boolean creative) {
        ItemStack toAdd;
        boolean flag;
        if (ammo.m_41619_()) {
            return false;
        }
        boolean bl = flag = creative && ammo.m_41720_() instanceof ArrowItem;
        if (!(flag || creative || hasAmmo)) {
            toAdd = ammo.m_41620_(1);
            if (ammo.m_41619_() && shooter instanceof Player) {
                Player p = (Player)shooter;
                p.m_150109_().m_36057_(ammo);
            }
        } else {
            toAdd = ammo.m_41777_();
        }
        BarrelCrossbow.m_40928_(crossbowStack, toAdd);
        return true;
    }

    private static void m_40928_(ItemStack crossbowStack, ItemStack ammoStack) {
        CompoundTag tag = crossbowStack.m_41784_();
        ListTag list = tag.m_128425_("ChargedProjectiles", 9) ? tag.m_128437_("ChargedProjectiles", 10) : new ListTag();
        CompoundTag entry = new CompoundTag();
        ammoStack.m_41739_(entry);
        list.add((Object)entry);
        tag.m_128365_("ChargedProjectiles", (Tag)list);
    }

    private static void markLoadStart(ItemStack stack, long tick, int variant) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128356_(NBT_LOAD_START_TICK, tick);
        tag.m_128405_(NBT_LOAD_VARIANT, BarrelCrossbow.clampVariant(variant));
        tag.m_128379_(NBT_LOAD_PLAYED, false);
    }

    private static void clearLoadFlags(ItemStack stack) {
        if (!stack.m_41782_()) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        tag.m_128473_(NBT_LOAD_START_TICK);
        tag.m_128473_(NBT_LOAD_VARIANT);
        tag.m_128473_(NBT_LOAD_PLAYED);
    }

    private static int clampVariant(int v) {
        return v < 0 ? 0 : Math.min(v, 3);
    }

    private static int clampVariant(ItemStack v) {
        return v.getEnchantmentLevel(Enchantments.f_44960_);
    }

    public Predicate<ItemStack> m_6437_() {
        return s -> s.m_41720_() instanceof ArrowItem || s.m_150930_(Items.f_42688_);
    }

    public double getBoneResetTime() {
        return 0.0;
    }

    private static float[] m_220023_(RandomSource random) {
        boolean flag = random.m_188499_();
        return new float[]{1.0f, BarrelCrossbow.m_220025_(flag, random), BarrelCrossbow.m_220025_(!flag, random)};
    }

    private static float m_220025_(boolean high, RandomSource random) {
        float f = high ? 0.63f : 0.43f;
        return 1.0f / (random.m_188501_() * 0.5f + 1.8f) + f;
    }

    public boolean m_6832_(ItemStack stack, ItemStack repairCandidate) {
        return repairCandidate.m_41720_() == ClockworkItems.CLOCKWORK_GEAR.get();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

