/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armoredfoes.client.model;

import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.ZombieVillagerModel;
import net.minecraft.client.model.geom.LayerDefinitions;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.ArmorModelSet;

public class LivingArmorModel {
    private static final MeshTransformer VILLAGER_TRANSFORMER = MeshTransformer.scaling((float)0.9375f);

    public static ArmorModelSet<LayerDefinition> createHumanoidArmorLayerSet() {
        return HumanoidModel.createArmorMeshSet((CubeDeformation)LayerDefinitions.INNER_ARMOR_DEFORMATION, (CubeDeformation)LayerDefinitions.OUTER_ARMOR_DEFORMATION).map(meshDefinition -> LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)32));
    }

    public static ArmorModelSet<LayerDefinition> createArmedArmorLayerSet() {
        return LivingArmorModel.createArmedArmorLayerSet(LayerDefinitions.INNER_ARMOR_DEFORMATION, LayerDefinitions.OUTER_ARMOR_DEFORMATION).map(layerDefinition -> layerDefinition.apply(VILLAGER_TRANSFORMER));
    }

    public static ArmorModelSet<LayerDefinition> createWitchArmorLayerSet() {
        return LivingArmorModel.createWitchArmorLayerSet(LayerDefinitions.INNER_ARMOR_DEFORMATION, LayerDefinitions.OUTER_ARMOR_DEFORMATION).map(layerDefinition -> layerDefinition.apply(VILLAGER_TRANSFORMER));
    }

    public static ArmorModelSet<LayerDefinition> createIllagerArmorLayerSet() {
        return LivingArmorModel.createIllagerArmorLayerSet(LayerDefinitions.INNER_ARMOR_DEFORMATION, LayerDefinitions.OUTER_ARMOR_DEFORMATION).map(layerDefinition -> layerDefinition.apply(VILLAGER_TRANSFORMER));
    }

    public static ArmorModelSet<LayerDefinition> createIllagerArmorLayerSet(CubeDeformation innerCubeDeformation, CubeDeformation outerCubeDeformation) {
        return HumanoidModel.createArmorMeshSet(LivingArmorModel::createArmedArmorMesh, (CubeDeformation)innerCubeDeformation, (CubeDeformation)outerCubeDeformation).map(meshDefinition -> LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)32));
    }

    public static ArmorModelSet<LayerDefinition> createArmedArmorLayerSet(CubeDeformation innerCubeDeformation, CubeDeformation outerCubeDeformation) {
        return LivingArmorModel.createArmedArmorMeshSet(LivingArmorModel::createArmedArmorMesh, innerCubeDeformation, outerCubeDeformation).map(meshDefinition -> LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)32));
    }

    public static ArmorModelSet<LayerDefinition> createWitchArmorLayerSet(CubeDeformation innerCubeDeformation, CubeDeformation outerCubeDeformation) {
        return LivingArmorModel.createArmedArmorLayerSet(innerCubeDeformation, outerCubeDeformation).map(layerDefinition -> layerDefinition.apply(LivingArmorModel::modifyWitchMesh));
    }

    private static ArmorModelSet<MeshDefinition> createArmedArmorMeshSet(Function<CubeDeformation, MeshDefinition> meshCreator, CubeDeformation innerCubeDeformation, CubeDeformation outerCubeDeformation) {
        MeshDefinition meshDefinition = meshCreator.apply(outerCubeDeformation);
        meshDefinition.getRoot().retainPartsAndChildren(Set.of("head"));
        MeshDefinition meshDefinition2 = meshCreator.apply(outerCubeDeformation);
        meshDefinition2.getRoot().retainPartsAndChildren(Set.of("body", "arms"));
        MeshDefinition meshDefinition3 = meshCreator.apply(innerCubeDeformation);
        meshDefinition3.getRoot().retainExactParts(Set.of("left_leg", "right_leg", "body"));
        MeshDefinition meshDefinition4 = meshCreator.apply(outerCubeDeformation);
        meshDefinition4.getRoot().retainExactParts(Set.of("left_leg", "right_leg"));
        return new ArmorModelSet((Object)meshDefinition, (Object)meshDefinition2, (Object)meshDefinition3, (Object)meshDefinition4);
    }

    private static MeshDefinition createArmedArmorMesh(CubeDeformation cubeDeformation) {
        MeshDefinition meshDefinition = ZombieVillagerModel.createBaseArmorMesh((CubeDeformation)cubeDeformation);
        LivingArmorModel.modifyOuterMesh(meshDefinition, cubeDeformation);
        LivingArmorModel.modifyInnerMesh(meshDefinition, cubeDeformation);
        return meshDefinition;
    }

    private static MeshDefinition modifyWitchMesh(MeshDefinition meshDefinition) {
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.getChild("head").addOrReplaceChild("nose", CubeListBuilder.create(), PartPose.ZERO);
        return meshDefinition;
    }

    private static void modifyOuterMesh(MeshDefinition meshDefinition, CubeDeformation outerCubeDeformation) {
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, outerCubeDeformation.extend(0.1f, 0.1f, 0.6f)), PartPose.ZERO);
        PartDefinition partDefinition3 = partDefinition.addOrReplaceChild("arms", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)-1.0f, (float)-0.75f, (float)0.0f, (float)0.0f));
        partDefinition3.addOrReplaceChild("right_shoulder", CubeListBuilder.create().texOffs(40, 16).addBox(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, outerCubeDeformation), PartPose.ZERO);
        partDefinition3.addOrReplaceChild("left_shoulder", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, outerCubeDeformation), PartPose.ZERO);
    }

    private static void modifyInnerMesh(MeshDefinition meshDefinition, CubeDeformation innerCubeDeformation) {
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, innerCubeDeformation.extend(-0.2f, 0.1f, 0.1f)), PartPose.offset((float)-2.0f, (float)12.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, innerCubeDeformation.extend(-0.2f, 0.1f, 0.1f)), PartPose.offset((float)2.0f, (float)12.0f, (float)0.0f));
    }
}

