/*
 * Decompiled with CFR 0.152.
 */
package com.hoshin.elytradurability.client;

import com.hoshin.elytradurability.core.EDIConfig;
import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="elytradurabilityindicator", value={Dist.CLIENT})
public class OverlayRenderer {
    private static final ResourceLocation ELYTRA_ICON = new ResourceLocation("elytradurabilityindicator", "textures/gui/elytra_icon.png");
    private static final Minecraft minecraft = Minecraft.m_91087_();
    private static Window window = minecraft.m_91268_();

    public static int x_center() {
        return window.m_85445_() / 2;
    }

    public static int y_center() {
        return window.m_85446_() / 2;
    }

    public static int bar_vertical_offset() {
        return (Integer)EDIConfig.CLIENT.BAR_VERTICAL_OFFSET.get();
    }

    public static int bar_height() {
        return (Integer)EDIConfig.CLIENT.BAR_HEIGHT.get();
    }

    public static int bar_width() {
        return (Integer)EDIConfig.CLIENT.BAR_WIDTH.get();
    }

    public static int icon_offset() {
        return (Integer)EDIConfig.CLIENT.ICON_OFFSET.get();
    }

    public static int full_bar_color() {
        return (Integer)EDIConfig.CLIENT.FULL_BAR_COLOR.get();
    }

    public static int damaged_bar_color() {
        return (Integer)EDIConfig.CLIENT.DAMAGED_BAR_COLOR.get();
    }

    public static boolean disappears_while_full() {
        return (Boolean)EDIConfig.CLIENT.DISAPPEARS_WHILE_FULL.get();
    }

    public static boolean only_while_flying() {
        return (Boolean)EDIConfig.CLIENT.ONLY_WHILE_FLYING.get();
    }

    public static boolean always_render_when_broken() {
        return (Boolean)EDIConfig.CLIENT.ALWAYS_RENDER_WHEN_BROKEN.get();
    }

    @SubscribeEvent
    public static void onRenderGui(RenderGuiOverlayEvent event) {
        GuiGraphics guiGraphics = event.getGuiGraphics();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack chestItem = player.m_6844_(EquipmentSlot.CHEST);
        if (player.m_5833_()) {
            return;
        }
        if (chestItem.m_41720_() != Items.f_42741_) {
            return;
        }
        if (OverlayRenderer.disappears_while_full() && !chestItem.m_41768_() && !player.m_21255_()) {
            return;
        }
        if (!(!OverlayRenderer.only_while_flying() || player.m_21255_() || OverlayRenderer.always_render_when_broken() && OverlayRenderer.computeBarMultiplier(chestItem) == 0.0f)) {
            return;
        }
        int barW1 = OverlayRenderer.bar_width();
        int barW2 = OverlayRenderer.computeRenderedBarWidth(chestItem);
        int barH = OverlayRenderer.bar_height();
        int iconSize = 16;
        int centerX = window.m_85445_() / 2 - 1;
        int centerY = window.m_85446_() / 2;
        int iconX = centerX - iconSize / 2 + 1;
        int iconY = centerY + OverlayRenderer.icon_offset();
        int barXFull = centerX - barW1 / 2;
        int barXDamaged = centerX - barW2 / 2;
        int barY1 = centerY + OverlayRenderer.bar_vertical_offset();
        int barY2 = barY1 + barH;
        guiGraphics.m_280509_(barXFull, barY1, barXFull + barW1, barY2, OverlayRenderer.full_bar_color());
        guiGraphics.m_280509_(barXDamaged, barY1, barXDamaged + barW2, barY2, OverlayRenderer.damaged_bar_color());
        guiGraphics.m_280163_(ELYTRA_ICON, iconX, iconY, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    public static int computeRenderedBarWidth(ItemStack itemStack) {
        return Math.round((float)OverlayRenderer.bar_width() * OverlayRenderer.computeBarMultiplier(itemStack));
    }

    public static float computeBarMultiplier(ItemStack itemStack) {
        int damage = itemStack.m_41773_();
        int max = itemStack.m_41776_();
        float remaining = max - damage;
        if (remaining == 1.0f) {
            return 0.0f;
        }
        return OverlayRenderer.clamp(remaining / (float)max, 0.0f, 1.0f);
    }

    public static float clamp(float value, float min, float max) {
        return Math.min(Math.max(value, min), max);
    }
}

