/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.constant.biome;

import com.teamtea.eclipticseasons.api.misc.ITranslatable;
import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public enum Rainfall implements ITranslatable
{
    RARE(Float.NEGATIVE_INFINITY, 0.1f, 0.0f, 0.1f),
    SCARCE(0.1f, 0.3f),
    MODERATE(0.3f, 0.6f),
    ADEQUATE(0.6f, 0.8f),
    ABUNDANT(0.8f, Float.POSITIVE_INFINITY, 0.8f, 1.0f);

    private float min;
    private float max;
    private float limitMin;
    private float limitMax;
    private static final Rainfall[] rainfall;

    private Rainfall(float min, float max) {
        this.min = min;
        this.max = max;
        this.limitMin = min;
        this.limitMax = max;
    }

    private Rainfall(float min, float max, float limitMin, float limitMax) {
        this.min = min;
        this.max = max;
        this.limitMin = limitMin;
        this.limitMax = limitMax;
    }

    public int getId() {
        return this.ordinal() + 1;
    }

    @Override
    public String getName() {
        return this.toString().toLowerCase(Locale.ROOT);
    }

    public boolean isInRainfall(float rainfall) {
        return this.min < rainfall && rainfall <= this.max;
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    public float getLimitedMin() {
        return this.limitMin;
    }

    public float getLimitedMax() {
        return this.limitMax;
    }

    @Override
    public Component getTranslation() {
        return Component.translatable((String)("info.eclipticseasons.environment.rainfall." + this.getName()));
    }

    public static Rainfall[] collectValues() {
        return rainfall;
    }

    public static Rainfall getRainfallLevel(float rainfall) {
        for (Rainfall r : Rainfall.collectValues()) {
            if (!r.isInRainfall(rainfall)) continue;
            return r;
        }
        return RARE;
    }

    public static float getRainfall(float rainfall) {
        for (Rainfall r : Rainfall.collectValues()) {
            if (!r.isInRainfall(rainfall)) continue;
            return Mth.clamp((float)((rainfall - r.getLimitedMin()) / (r.getLimitedMax() - r.getLimitedMin())), (float)0.0f, (float)1.0f) * 1.0f + (float)r.ordinal();
        }
        return 0.0f;
    }

    static {
        rainfall = Rainfall.values();
    }
}

