/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.constant.crop;

import com.teamtea.eclipticseasons.api.constant.biome.Humidity;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class CropHumidityInfo {
    private final Humidity min;
    private final Humidity max;

    public CropHumidityInfo(Humidity min, Humidity max) {
        this.min = min;
        this.max = max;
    }

    public CropHumidityInfo(Humidity env) {
        this.min = env;
        this.max = env;
    }

    public boolean isSuitable(Humidity env) {
        return this.min.getId() <= env.getId() && env.getId() <= this.max.getId();
    }

    public float getGrowChance(Humidity env) {
        float mul = 4.0f;
        if (this.isSuitable(env)) {
            return 1.0f;
        }
        if (env.getId() < this.min.getId()) {
            return Math.max(0.0f, 1.0f / (mul * (float)(this.min.getId() - env.getId()) * (float)(this.min.getId() - env.getId())));
        }
        return Math.max(0.0f, 1.0f / (mul * (float)(env.getId() - this.max.getId()) * (float)(env.getId() - this.max.getId())));
    }

    public List<Component> getTooltip() {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.translatable((String)"info.eclipticseasons.environment.humidity").withStyle(ChatFormatting.GRAY));
        if (this.min != this.max) {
            list.add((Component)((MutableComponent)this.min.getTranslation()).append((Component)Component.literal((String)" - ").withStyle(ChatFormatting.GRAY)).append(this.max.getTranslation()));
        } else {
            list.add(this.min.getTranslation());
        }
        return list;
    }

    public static List<Component> getTooltip(Humidity min, Humidity max) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.translatable((String)"info.eclipticseasons.environment.humidity").withStyle(ChatFormatting.GRAY));
        if (min != max) {
            list.add((Component)((MutableComponent)min.getTranslation()).append((Component)Component.literal((String)" - ").withStyle(ChatFormatting.GRAY)).append(max.getTranslation()));
        } else {
            list.add(min.getTranslation());
        }
        return list;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CropHumidityInfo that = (CropHumidityInfo)o;
        return this.min == that.min && this.max == that.max;
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }
}

