/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.constant.tag;

import com.teamtea.eclipticseasons.api.constant.tag.ClimateTypeBiomeTags;
import com.teamtea.eclipticseasons.api.misc.RegistryFilter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.neoforged.neoforge.common.Tags;

public class ClimateTypeFilters {
    public static final RegistryFilter<Biome> WARM_REGION = new RegistryFilter.TagHolder<Biome>(Tags.Biomes.IS_OVERWORLD);
    public static final RegistryFilter<Biome> HOT_REGION = new RegistryFilter.TagHolder<Biome>(Tags.Biomes.IS_HOT_OVERWORLD);
    public static final RegistryFilter<Biome> COLD_REGION = new RegistryFilter.And<Biome>(new RegistryFilter.Or(Tags.Biomes.IS_MOUNTAIN_PEAK, Tags.Biomes.IS_SNOWY, Tags.Biomes.IS_ICY), new RegistryFilter.Or(Tags.Biomes.IS_OVERWORLD));
    public static final RegistryFilter<Biome> SEASONAL = new RegistryFilter.TagHolder<Biome>(Tags.Biomes.IS_OVERWORLD);
    public static final RegistryFilter<Biome> SEASONAL_HOT = new RegistryFilter.TagHolder<Biome>(Tags.Biomes.IS_HOT_OVERWORLD);
    public static final RegistryFilter<Biome> SEASONAL_COLD = new RegistryFilter.And<Biome>(new RegistryFilter.Or(Tags.Biomes.IS_MOUNTAIN_PEAK, Tags.Biomes.IS_SNOWY, Tags.Biomes.IS_ICY), new RegistryFilter.Or(Tags.Biomes.IS_OVERWORLD));
    public static final RegistryFilter<Biome> MONSOONAL = new RegistryFilter.TagHolder<Biome>(Tags.Biomes.IS_SAVANNA);
    public static final RegistryFilter<Biome> RAINLESS = new RegistryFilter.TagHolder<Biome>(Tags.Biomes.IS_CAVE);
    public static final RegistryFilter<Biome> ARID = new RegistryFilter.Or<Biome>(Tags.Biomes.IS_BADLANDS, Tags.Biomes.IS_DESERT);
    public static final RegistryFilter<Biome> DROUGHTY = biomes -> List.of();
    public static final RegistryFilter<Biome> SOFT = new RegistryFilter.Or<Biome>(Tags.Biomes.IS_BEACH, Tags.Biomes.IS_OCEAN);
    public static final RegistryFilter<Biome> RAINY = new RegistryFilter.DirectHolder<Biome>(Biomes.JUNGLE);
    public static final RegistryFilter<Biome> IS_SMALL = new RegistryFilter.TagHolder<Biome>(Tags.Biomes.IS_RIVER);
    public static final RegistryFilter<Biome> SEASONAL_COLOR_CHANGE = SEASONAL;
    public static final RegistryFilter<Biome> SEASONAL_HOT_COLOR_CHANGE = SEASONAL_HOT;
    public static final RegistryFilter<Biome> SEASONAL_COLD_COLOR_CHANGE = SEASONAL_COLD;
    public static final RegistryFilter<Biome> MONSOONAL_COLOR_CHANGE = MONSOONAL;
    public static final RegistryFilter<Biome> NONE_COLOR_CHANGE = new RegistryFilter.Or<Biome>(Tags.Biomes.IS_CAVE, Tags.Biomes.IS_BADLANDS, Tags.Biomes.IS_DESERT, Tags.Biomes.IS_VOID);
    public static final RegistryFilter<Biome> SLIGHTLY_COLOR_CHANGE = new RegistryFilter.Or<Biome>(new RegistryFilter.TagHolder(Tags.Biomes.IS_BEACH), new RegistryFilter.TagHolder(Tags.Biomes.IS_OCEAN), new RegistryFilter.DirectHolder(Biomes.JUNGLE));
    public static final Map<TagKey<Biome>, RegistryFilter<Biome>> OVERWORLD_AGRO_BIOME_PRESENT = new LinkedHashMap<TagKey<Biome>, RegistryFilter<Biome>>(){
        {
            this.put(ClimateTypeBiomeTags.HOT_REGION, HOT_REGION);
            this.put(ClimateTypeBiomeTags.COLD_REGION, COLD_REGION);
            this.put(ClimateTypeBiomeTags.WARM_REGION, WARM_REGION);
        }
    };
    public static final Map<TagKey<Biome>, RegistryFilter<Biome>> BIOME_PRESENT = new LinkedHashMap<TagKey<Biome>, RegistryFilter<Biome>>(){
        {
            this.put(ClimateTypeBiomeTags.RAINLESS, RAINLESS);
            this.put(ClimateTypeBiomeTags.ARID, ARID);
            this.put(ClimateTypeBiomeTags.DROUGHTY, DROUGHTY);
            this.put(ClimateTypeBiomeTags.SOFT, SOFT);
            this.put(ClimateTypeBiomeTags.RAINY, RAINY);
            this.put(ClimateTypeBiomeTags.MONSOONAL, MONSOONAL);
            this.put(ClimateTypeBiomeTags.SEASONAL_HOT, SEASONAL_HOT);
            this.put(ClimateTypeBiomeTags.SEASONAL_COLD, SEASONAL_COLD);
            this.put(ClimateTypeBiomeTags.SEASONAL, SEASONAL);
        }
    };
    @Deprecated(forRemoval=true)
    public static final Map<TagKey<Biome>, RegistryFilter<Biome>> SMALL_BIOME_PRESENT = new LinkedHashMap<TagKey<Biome>, RegistryFilter<Biome>>(Map.of(ClimateTypeBiomeTags.IS_SMALL, IS_SMALL));
    public static final Map<TagKey<Biome>, RegistryFilter<Biome>> COLOR_BIOME_PRESENT = new LinkedHashMap<TagKey<Biome>, RegistryFilter<Biome>>(){
        {
            this.put(ClimateTypeBiomeTags.NONE_COLOR_CHANGE, NONE_COLOR_CHANGE);
            this.put(ClimateTypeBiomeTags.SLIGHTLY_COLOR_CHANGE, SLIGHTLY_COLOR_CHANGE);
            this.put(ClimateTypeBiomeTags.MONSOONAL_COLOR_CHANGE, MONSOONAL_COLOR_CHANGE);
            this.put(ClimateTypeBiomeTags.SEASONAL_HOT_COLOR_CHANGE, SEASONAL_HOT_COLOR_CHANGE);
            this.put(ClimateTypeBiomeTags.SEASONAL_COLD_COLOR_CHANGE, SEASONAL_COLD_COLOR_CHANGE);
            this.put(ClimateTypeBiomeTags.SEASONAL_COLOR_CHANGE, SEASONAL_COLOR_CHANGE);
        }
    };
}

