/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.data.client;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.data.client.ColorMode;
import com.teamtea.eclipticseasons.api.data.misc.SolarTermValueMap;
import com.teamtea.eclipticseasons.api.misc.util.HolderMappable;
import com.teamtea.eclipticseasons.api.misc.util.Mergable;
import com.teamtea.eclipticseasons.api.util.fast.Enum2IntMap;
import com.teamtea.eclipticseasons.api.util.fast.Enum2ObjectMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public record LeafColor(ColorSource colorSource, BlockPredicate blockPredicate, Optional<LocationPredicate> locationPredicate, Optional<SolarTermValueMap<ColorMode>> colors, Optional<SolarTermValueMap<List<ResourceLocation>>> sprites, Optional<SolarTermValueMap<Integer>> weights, Optional<Boolean> replace) implements HolderMappable<HolderSet<Block>, Pair<InstanceHolder, Instance>>
{
    public static final Codec<LeafColor> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)StringRepresentable.fromEnum(ColorSource::collectValues).fieldOf("source").orElse((Object)ColorSource.CUSTOM).forGetter(LeafColor::colorSource), (App)BlockPredicate.CODEC.fieldOf("block").forGetter(LeafColor::blockPredicate), (App)LocationPredicate.CODEC.optionalFieldOf("location").forGetter(LeafColor::locationPredicate), (App)SolarTermValueMap.codec(ColorMode.CODEC).optionalFieldOf("colors").forGetter(LeafColor::colors), (App)SolarTermValueMap.codec(ResourceLocation.CODEC.listOf()).optionalFieldOf("sprites").forGetter(LeafColor::sprites), (App)SolarTermValueMap.codec(Codec.INT).optionalFieldOf("weights").forGetter(LeafColor::weights), (App)Codec.BOOL.optionalFieldOf("replace").forGetter(LeafColor::replace)).apply((Applicative)ins, LeafColor::new));
    private static final SolarTermValueMap<ColorMode> EMPTY_MODE_MAP = new SolarTermValueMap(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    private static final SolarTermValueMap<List<ResourceLocation>> EMPTY_LIST_MAP = new SolarTermValueMap(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    private static final SolarTermValueMap<Integer> EMPTY_INTEGER_MAP = new SolarTermValueMap(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());

    @Override
    public Pair<HolderSet<Block>, Pair<InstanceHolder, Instance>> asHolderMapping() {
        return Pair.of((Object)this.blockPredicate().blocks().orElse(HolderSet.empty()), this.toInstance());
    }

    @NotNull
    public Pair<InstanceHolder, Instance> toInstance() {
        Enum2ObjectMap<SolarTerm, ColorMode> colorMap = this.colors.orElse(EMPTY_MODE_MAP).combine();
        Enum2ObjectMap<SolarTerm, List<ResourceLocation>> spriteMap = this.sprites.orElse(EMPTY_LIST_MAP).combine();
        Enum2ObjectMap<SolarTerm, Integer> weightMap = this.weights.orElse(EMPTY_INTEGER_MAP).combine();
        Enum2ObjectMap<SolarTerm, ColorMode.Instance> colorsE = SolarTermValueMap.convertToEnum2ObjectMap(SolarTerm.class, colorMap, ColorMode::toInstance);
        Enum2ObjectMap<SolarTerm, List<ResourceLocation>> spritesE = SolarTermValueMap.convertToEnum2ObjectMap(SolarTerm.class, spriteMap, Function.identity());
        Enum2IntMap<SolarTerm> weightsE = new Enum2IntMap<SolarTerm>(SolarTerm.class);
        weightMap.forEach(weightsE::put);
        return Pair.of((Object)new InstanceHolder(Optional.ofNullable(this.blockPredicate), this.locationPredicate), (Object)new Instance(this.colorSource, colorsE, spritesE, weightsE, this.replace.orElse(false)));
    }

    public static enum ColorSource implements StringRepresentable
    {
        MAP,
        BLOCK,
        TEXTURE,
        CUSTOM;

        private static final ColorSource[] VALUES;

        public static ColorSource[] collectValues() {
            return VALUES;
        }

        @NotNull
        public String getSerializedName() {
            return this.toString().toLowerCase(Locale.ROOT);
        }

        static {
            VALUES = ColorSource.values();
        }
    }

    public record InstanceHolder(Optional<BlockPredicate> blockPredicate, Optional<LocationPredicate> locationPredicate) {
        private static final InstanceHolder EMPTY = new InstanceHolder(Optional.empty(), Optional.empty());

        public boolean matches(Level level, int i, int j, int k, RandomSource random, BlockState blockstate) {
            LocationPredicate location;
            if (this.blockPredicate.isPresent()) {
                BlockPredicate predicate = this.blockPredicate.get();
                if (predicate.blocks().isPresent() && !((HolderSet)predicate.blocks().get()).contains(blockstate.getBlockHolder())) {
                    return false;
                }
                if (predicate.properties().isPresent() && !((StatePropertiesPredicate)predicate.properties().get()).matches(blockstate)) {
                    return false;
                }
            }
            if (this.locationPredicate.isPresent() && (location = this.locationPredicate.get()).biomes().isPresent()) {
                Holder biomeHolder = level.getBiome(new BlockPos(i, j, k));
                if (!((HolderSet)location.biomes().get()).contains(biomeHolder)) {
                    return false;
                }
            }
            return true;
        }
    }

    public record Instance(ColorSource colorSource, Enum2ObjectMap<SolarTerm, ColorMode.Instance> colors, Enum2ObjectMap<SolarTerm, List<ResourceLocation>> sprites, Enum2IntMap<SolarTerm> weights, boolean replace) implements Mergable<Instance>
    {
        private static final Enum2ObjectMap<SolarTerm, ColorMode.Instance> EMPTY_COLOR_MAP = new Enum2ObjectMap(SolarTerm.class);
        private static final Instance EMPTY = new Instance(ColorSource.MAP, new Enum2ObjectMap<SolarTerm, ColorMode.Instance>(SolarTerm.class), new Enum2ObjectMap<SolarTerm, List<ResourceLocation>>(SolarTerm.class), new Enum2IntMap<SolarTerm>(SolarTerm.class), false);

        @Override
        public Instance merge(Instance next) {
            Enum2ObjectMap<SolarTerm, ColorMode.Instance> newColors = new Enum2ObjectMap<SolarTerm, ColorMode.Instance>(SolarTerm.class);
            Enum2ObjectMap<SolarTerm, List<ResourceLocation>> newSprites = new Enum2ObjectMap<SolarTerm, List<ResourceLocation>>(SolarTerm.class);
            Enum2IntMap<SolarTerm> newWeights = new Enum2IntMap<SolarTerm>(SolarTerm.class);
            newColors.putAll(this.colors);
            newColors.putAll(next.colors);
            newSprites.putAll(this.sprites);
            newSprites.putAll(next.sprites);
            newWeights.putAll(this.weights);
            newWeights.putAll(next.weights);
            return new Instance(next.colorSource, newColors, newSprites, newWeights, next.replace());
        }
    }
}

