/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.data.client.model.multipart;

import com.google.common.base.Splitter;
import com.teamtea.eclipticseasons.api.data.client.model.multipart.ConditionLike;
import java.util.List;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class KeyValueConditionLike
implements ConditionLike {
    private static final Splitter PIPE_SPLITTER = Splitter.on((char)'|').omitEmptyStrings();
    public final String key;
    public final String value;

    public KeyValueConditionLike(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public KeyValueConditionLike(Property<?> property, Object object) {
        this(property.getName(), object.toString());
    }

    @NotNull
    public Predicate<BlockState> getPredicate(@NotNull StateDefinition<Block, BlockState> ignore) {
        boolean negate = this.value.startsWith("!");
        String val = negate ? this.value.substring(1) : this.value;
        List targetValues = PIPE_SPLITTER.splitToList((CharSequence)val);
        Predicate<BlockState> base = blockState -> {
            String currentValue = this.getStringValue((BlockState)blockState, this.key);
            return targetValues.contains(currentValue);
        };
        return negate ? base.negate() : base;
    }

    private String getStringValue(BlockState state, String key) {
        for (Property property : state.getProperties()) {
            if (!property.getName().equals(key)) continue;
            Comparable value = state.getValue(property);
            return String.valueOf(value);
        }
        return null;
    }

    public String toString() {
        return String.format("KeyValueStringCondition{key='%s', value='%s'}", this.key, this.value);
    }

    @Override
    public String getTypeKey() {
        return "KEY";
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getValue() {
        return this.value;
    }
}

