/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.data.client.model.multipart;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.teamtea.eclipticseasons.api.data.client.model.multipart.SelectorLike;
import com.teamtea.eclipticseasons.client.model.MultiPartBakedModelLike;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import net.minecraft.client.renderer.block.model.multipart.MultiPart;
import net.minecraft.client.renderer.block.model.multipart.Selector;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiPartLike
extends MultiPart {
    public static final Codec<MultiPartLike> CODEC = Codec.either(SelectorLike.CODEC, (Codec)SelectorLike.CODEC.listOf()).xmap(either -> new MultiPartLike((List)either.map(List::of, list -> list)), multi -> {
        List<SelectorLike> list = multi.getSelectorLikes();
        return list.size() == 1 ? Either.left((Object)((Object)list.get(0))) : Either.right(list);
    });
    public static final MultiPartLike EMPTY = new MultiPartLike(List.of());
    private final List<SelectorLike> selectorLikes;

    public MultiPartLike(List<SelectorLike> selectors) {
        super((StateDefinition)FakeStateDefinition.of(), List.copyOf(selectors));
        this.selectorLikes = selectors;
    }

    public boolean isValid() {
        return !this.getSelectorLikes().isEmpty();
    }

    @Nullable
    public BakedModel bake(@NotNull ModelBaker baker, @NotNull Function<Material, TextureAtlasSprite> spriteGetter, @NotNull ModelState state) {
        MultiPartBakedModelLike.Builder multipartbakedmodel$builder = new MultiPartBakedModelLike.Builder();
        for (Selector selector : this.getSelectors()) {
            BakedModel bakedmodel = selector.getVariant().bake(baker, spriteGetter, state);
            if (bakedmodel == null) continue;
            multipartbakedmodel$builder.add(selector.getPredicate((StateDefinition)FakeStateDefinition.of()), bakedmodel);
        }
        return multipartbakedmodel$builder.build();
    }

    @Generated
    public List<SelectorLike> getSelectorLikes() {
        return this.selectorLikes;
    }

    public static class FakeStateDefinition
    extends StateDefinition<Block, BlockState> {
        private static FakeStateDefinition EMPTY;

        protected FakeStateDefinition(Function<Block, BlockState> stateValueFunction, Block owner, StateDefinition.Factory<Block, BlockState> valueFunction, Map<String, Property<?>> propertiesByName) {
            super(stateValueFunction, (Object)owner, valueFunction, propertiesByName);
        }

        public static FakeStateDefinition of() {
            if (EMPTY == null) {
                EMPTY = new FakeStateDefinition(Block::defaultBlockState, Blocks.AIR, (StateDefinition.Factory<Block, BlockState>)((StateDefinition.Factory)BlockState::new), (Map<String, Property<?>>)ImmutableMap.of());
            }
            return EMPTY;
        }
    }
}

