/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.data.climate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.data.crop.CropGrowControl;
import com.teamtea.eclipticseasons.api.data.crop.GrowParameter;
import com.teamtea.eclipticseasons.api.util.codec.CodecUtil;
import com.teamtea.eclipticseasons.api.util.codec.ESExtraCodec;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public record AgroClimaticZone(HolderSet<Biome> biomes, Optional<GrowParameter> growParameter, Optional<Map<Either<Season, SolarTerm>, Float>> defaultMapping, Optional<Map<Either<Season, SolarTerm>, List<Pair<Either<Season, SolarTerm>, Float>>>> mapping, List<Pair<Season, Integer>> seasonalSignalDurations) {
    public static final Codec<Either<Season, SolarTerm>> EITHER_CODEC = Codec.either(ESExtraCodec.SEASON, ESExtraCodec.SOLAR_TERM);
    public static final Codec<Map<Either<Season, SolarTerm>, Float>> EITHER_MAP_PAIR_CODEC = CodecUtil.mapCodec(EITHER_CODEC, Codec.FLOAT);
    public static final Codec<Pair<Either<Season, SolarTerm>, Float>> EITHER_PAIR_CODEC = CodecUtil.pairCodec(EITHER_CODEC, Codec.FLOAT);
    public static final Codec<Map<Either<Season, SolarTerm>, List<Pair<Either<Season, SolarTerm>, Float>>>> EITHER_MAP_CODEC = CodecUtil.mapCodec(EITHER_CODEC, EITHER_PAIR_CODEC.listOf());
    public static final Codec<AgroClimaticZone> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CodecUtil.holderSetCodec(Registries.BIOME).fieldOf("biomes").forGetter(AgroClimaticZone::biomes), (App)GrowParameter.CODEC.optionalFieldOf("global").forGetter(AgroClimaticZone::growParameter), (App)EITHER_MAP_PAIR_CODEC.optionalFieldOf("default_mapping").forGetter(AgroClimaticZone::defaultMapping), (App)EITHER_MAP_CODEC.optionalFieldOf("mappings").forGetter(AgroClimaticZone::mapping), (App)CodecUtil.pairCodec(ESExtraCodec.SEASON, Codec.INT).listOf().optionalFieldOf("seasonal_signal_durations", List.of()).validate(AgroClimaticZone::checkSeasonalSignalDurations).forGetter(AgroClimaticZone::seasonalSignalDurations)).apply((Applicative)builder, AgroClimaticZone::new));

    private static DataResult<List<Pair<Season, Integer>>> checkSeasonalSignalDurations(List<Pair<Season, Integer>> pairList) {
        boolean result = true;
        int sum = 0;
        for (Pair<Season, Integer> p : pairList) {
            sum += ((Integer)p.getSecond()).intValue();
            if ((Integer)p.getSecond() >= 0) continue;
            result = false;
        }
        int count = sum;
        StringBuilder stringBuilder = new StringBuilder();
        if (count != 0 && count != 24) {
            result = false;
        }
        return !result ? DataResult.error(() -> "Term total length is " + count + String.valueOf(stringBuilder), List.of()) : DataResult.success(pairList);
    }

    @Deprecated(forRemoval=true, since="0.12")
    public GrowParameter buildFromList(CropGrowControl templateGrowth, List<Pair<Either<Season, SolarTerm>, Float>> mappings) {
        return this.buildFromList(null, templateGrowth, mappings);
    }

    @Deprecated(forRemoval=true, since="0.12")
    public GrowParameter getGrowParameterFromMapping(CropGrowControl templateGrowth, SolarTerm solarTerm) {
        return this.getGrowParameterFromMapping(null, templateGrowth, solarTerm);
    }

    public GrowParameter buildFromList(BlockState state, CropGrowControl templateGrowth, List<Pair<Either<Season, SolarTerm>, Float>> mappings) {
        GrowParameter growParameterResult = null;
        if (mappings != null && templateGrowth != null) {
            float chance = 0.0f;
            boolean any = false;
            int listSize = mappings.size();
            for (int m = 0; m < listSize; ++m) {
                GrowParameter orDefault;
                Pair<Either<Season, SolarTerm>, Float> eitherFloatMap = mappings.get(m);
                Either key = (Either)eitherFloatMap.getFirst();
                if (key.right().isPresent()) {
                    orDefault = templateGrowth.getGrowParameter((SolarTerm)key.right().get(), state);
                    if (orDefault == null) continue;
                    chance += orDefault.grow_chance() * ((Float)eitherFloatMap.getSecond()).floatValue();
                    any = true;
                    continue;
                }
                if (!key.left().isPresent() || (orDefault = templateGrowth.getGrowParameter((Season)key.left().get(), state)) == null) continue;
                chance += orDefault.grow_chance() * ((Float)eitherFloatMap.getSecond()).floatValue();
                any = true;
            }
            if (any) {
                growParameterResult = GrowParameter.builder().growChance(chance).end();
            }
        }
        return growParameterResult;
    }

    public GrowParameter getGrowParameterFromMapping(BlockState state, CropGrowControl templateGrowth, SolarTerm solarTerm) {
        Map<Either<Season, SolarTerm>, List<Pair<Either<Season, SolarTerm>, Float>>> eitherListMap;
        List list;
        GrowParameter growParameterResult = null;
        if (this.mapping().isPresent() && (growParameterResult = this.buildFromList(state, templateGrowth, list = (List)(eitherListMap = this.mapping().get()).getOrDefault(Either.right((Object)solarTerm), null))) == null) {
            list = eitherListMap.getOrDefault(Either.left((Object)solarTerm.getSeason()), null);
            growParameterResult = this.buildFromList(state, templateGrowth, list);
        }
        if (growParameterResult == null && this.defaultMapping().isPresent()) {
            ArrayList<Pair<Either<Season, SolarTerm>, Float>> pairs = new ArrayList<Pair<Either<Season, SolarTerm>, Float>>();
            for (Map.Entry<Either<Season, SolarTerm>, Float> s : this.defaultMapping().get().entrySet()) {
                Pair eitherFloatPair = Pair.of(s.getKey(), (Object)s.getValue());
                pairs.add((Pair<Either<Season, SolarTerm>, Float>)eitherFloatPair);
            }
            growParameterResult = this.buildFromList(state, templateGrowth, pairs);
        }
        if (growParameterResult == null && this.growParameter().isPresent()) {
            growParameterResult = this.growParameter().get();
        }
        return growParameterResult;
    }

    public static String getDescriptionId(@NotNull ResourceLocation resourceLocation) {
        return ESRegistries.createLangKey(ESRegistries.AGRO_CLIMATE, resourceLocation);
    }

    public static Builder builder(HolderSet<Biome> biomes) {
        return new Builder(biomes);
    }

    public static class Builder {
        private HolderSet<Biome> biomes;
        private GrowParameter growParameter;
        private Map<Either<Season, SolarTerm>, List<Pair<Either<Season, SolarTerm>, Float>>> mapping;
        private Map<Either<Season, SolarTerm>, Float> defaultMapping;
        private List<Pair<Season, Integer>> localSeason = new ArrayList<Pair<Season, Integer>>();

        private Builder(HolderSet<Biome> biomes) {
            this.biomes = biomes;
        }

        public Builder growParameter(GrowParameter growParameter) {
            this.growParameter = growParameter;
            return this;
        }

        public Builder mapping(Map<Either<Season, SolarTerm>, List<Pair<Either<Season, SolarTerm>, Float>>> mapping) {
            this.mapping = mapping;
            return this;
        }

        public Builder defaultMapping(Pair<Either<Season, SolarTerm>, Float> pair) {
            LinkedHashMap<Either<Season, SolarTerm>, Float> mapping2 = new LinkedHashMap<Either<Season, SolarTerm>, Float>(24);
            mapping2.put((Either)pair.getFirst(), (Float)pair.getSecond());
            this.defaultMapping = mapping2;
            return this;
        }

        public Builder add(Season season, int length) {
            this.localSeason.add((Pair<Season, Integer>)Pair.of((Object)season, (Object)length));
            return this;
        }

        public AgroClimaticZone end() {
            if (this.biomes == null) {
                throw new IllegalArgumentException("Biomes must not be null");
            }
            return new AgroClimaticZone(this.biomes, Optional.ofNullable(this.growParameter), Optional.ofNullable(this.defaultMapping), Optional.ofNullable(this.mapping), this.localSeason);
        }
    }
}

