/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.data.craft;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamtea.eclipticseasons.api.data.misc.PosAndBlockStateCheck;
import com.teamtea.eclipticseasons.config.CommonConfig;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public record HumidityControl(SizedIngredient ingredient, ItemStack result, int range, int level, int lasting_time, List<PosAndBlockStateCheck> checks, boolean infinity) {
    public static final Codec<HumidityControl> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)SizedIngredient.FLAT_CODEC.fieldOf("ingredient").forGetter(HumidityControl::ingredient), (App)ItemStack.CODEC.fieldOf("result").forGetter(HumidityControl::result), (App)Codec.INT.fieldOf("range").forGetter(HumidityControl::range), (App)Codec.INT.fieldOf("level").forGetter(HumidityControl::level), (App)Codec.INT.optionalFieldOf("lasting_time", (Object)6000).forGetter(HumidityControl::lasting_time), (App)PosAndBlockStateCheck.CODEC.listOf().fieldOf("checks").forGetter(HumidityControl::checks), (App)Codec.BOOL.optionalFieldOf("infinity", (Object)false).forGetter(HumidityControl::infinity)).apply((Applicative)ins, HumidityControl::new));

    public HumidityControl(SizedIngredient ingredient, ItemStack result, int range, int level, int lasting_time, List<PosAndBlockStateCheck> checks) {
        this(ingredient, result, range, level, lasting_time, checks, false);
    }

    public boolean noCost() {
        return (Boolean)CommonConfig.Crop.noCostHumidifier.get() != false || this.infinity || this.ingredient.test(this.result);
    }
}

