/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.data.crop;

import com.mojang.datafixers.util.Pair;
import com.teamtea.eclipticseasons.api.constant.biome.Humidity;
import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.data.crop.CropGrow;
import com.teamtea.eclipticseasons.api.data.crop.GrowParameter;
import com.teamtea.eclipticseasons.api.misc.util.Mergable;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.ApiStatus;

public record CropGrowControl(CropGrow base, Optional<IdentityHashMap<BlockState, CropGrow>> blocks, Optional<List<Pair<BlockPredicate, CropGrow>>> entities, Optional<BlockPredicate> notGreenHouse) implements Mergable<CropGrowControl>
{
    @Nonnull
    public CropGrow getCropGrow(@Nullable BlockState state) {
        if (state == null || this.blocks().isEmpty() || this.blocks().get().isEmpty()) {
            return this.base();
        }
        return this.blocks().map(m -> m.getOrDefault(state, this.base())).orElse(this.base());
    }

    @Deprecated(forRemoval=true, since="0.12")
    @ApiStatus.Internal
    public GrowParameter getGrowParameter(SolarTerm solarTerm) {
        return this.getGrowParameter(solarTerm, null);
    }

    @Deprecated(forRemoval=true, since="0.12")
    @ApiStatus.Internal
    public GrowParameter getGrowParameter(Season season) {
        return this.getGrowParameter(season, null);
    }

    @Deprecated(forRemoval=true, since="0.12")
    @ApiStatus.Internal
    public GrowParameter getGrowParameter(Humidity env) {
        return this.getGrowParameter(env, null);
    }

    @ApiStatus.Internal
    public GrowParameter getGrowParameter(SolarTerm solarTerm, BlockState state) {
        CropGrow cropGrow = this.getCropGrow(state);
        GrowParameter growParameter = cropGrow.solarTermsMap().getOrDefault(solarTerm, null);
        if (growParameter == null) {
            growParameter = cropGrow.seasonMap().getOrDefault(solarTerm.getSeason(), null);
        }
        if (growParameter == null) {
            growParameter = cropGrow.growParameter().orElse(null);
        }
        return growParameter;
    }

    @ApiStatus.Internal
    public GrowParameter getGrowParameter(Season season, BlockState state) {
        CropGrow cropGrow = this.getCropGrow(state);
        GrowParameter growParameter = cropGrow.seasonMap().getOrDefault(season, null);
        if (growParameter == null) {
            if (season == Season.NONE) {
                return cropGrow.solarTermsMap().getOrDefault(SolarTerm.NONE, null);
            }
            float a_chance = 0.0f;
            float b_chance = 0.0f;
            float c_chance = 0.0f;
            int ordinal = season.ordinal();
            boolean any = false;
            for (int l = ordinal * 6; l < ordinal * 6 + 6; ++l) {
                GrowParameter termParameter = cropGrow.solarTermsMap().getOrDefault(SolarTerm.collectValues()[l], null);
                if (termParameter == null) continue;
                a_chance += termParameter.grow_chance();
                b_chance += termParameter.fertile_chance();
                c_chance += termParameter.death_chance();
                any = true;
            }
            if (any) {
                growParameter = GrowParameter.builder().growChance(a_chance / 6.0f).fertileChance(b_chance / 6.0f).deathChance(c_chance / 6.0f).end();
            }
        }
        return growParameter;
    }

    @ApiStatus.Internal
    public GrowParameter getGrowParameter(Humidity env, BlockState state) {
        CropGrow cropGrow = this.getCropGrow(state);
        GrowParameter growParameter = cropGrow.humidMap().getOrDefault(env, null);
        if (growParameter == null) {
            growParameter = cropGrow.growParameter2().orElse(null);
        }
        return growParameter;
    }

    @ApiStatus.Internal
    public GrowParameter getGrowParameter(float env, BlockState state) {
        GrowParameter growParameter;
        block5: {
            Humidity.Environment environment = Humidity.getEnvironment(env);
            List<Humidity.Composition> compositions = environment.compositions();
            CropGrow cropGrow = this.getCropGrow(state);
            growParameter = cropGrow.humidMap().getOrDefault(environment.base(), null);
            if (growParameter == null) {
                growParameter = cropGrow.growParameter2().orElse(null);
            } else if (compositions.size() > 1) {
                float growChance = 0.0f;
                float fertileChance = 0.0f;
                float deathChance = 0.0f;
                for (Humidity.Composition composition : compositions) {
                    GrowParameter g = cropGrow.humidMap().getOrDefault(composition.humidity(), null);
                    if (g != null) {
                        growChance += g.grow_chance() * composition.percent();
                        fertileChance += g.fertile_chance() * composition.percent();
                        deathChance += g.death_chance() * composition.percent();
                        continue;
                    }
                    break block5;
                }
                growParameter = GrowParameter.builder().growChance(growChance).fertileChance(fertileChance).deathChance(deathChance).deadState(growParameter.deadState()).end();
            }
        }
        return growParameter;
    }

    @Override
    public CropGrowControl merge(CropGrowControl next) {
        CropGrowControl control = this;
        control.base().solarTermsMap().putAll(next.base().solarTermsMap());
        control.base().seasonMap().putAll(next.base().seasonMap());
        control.base().humidMap().putAll(next.base().humidMap());
        if (control.blocks().isPresent() && next.blocks().isPresent()) {
            control.blocks().get().putAll((Map<BlockState, CropGrow>)next.blocks().get());
        } else if (control.blocks().isEmpty() && next.blocks().isPresent()) {
            control = new CropGrowControl(control.base(), next.blocks(), control.entities(), control.notGreenHouse());
        }
        if (next.entities().isPresent()) {
            ArrayList arrayList = new ArrayList(control.entities().orElse(new ArrayList()));
            arrayList.addAll(next.entities().get());
            control = new CropGrowControl(control.base(), control.blocks(), Optional.of(arrayList), control.notGreenHouse());
        }
        if (control.notGreenHouse().isEmpty() && next.notGreenHouse().isPresent()) {
            control = new CropGrowControl(control.base(), control.blocks(), control.entities(), next.notGreenHouse());
        }
        return control;
    }
}

