/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.data.misc;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.JsonOps;
import com.teamtea.eclipticseasons.api.util.codec.CodecTranferUtil;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import net.minecraft.core.HolderLookup;
import net.minecraft.util.ExtraCodecs;

public class DRBiomeWrapper<T> {
    private final Optional<JsonElement> element;
    private Optional<T> value;

    public DRBiomeWrapper(Optional<JsonElement> jsonElement) {
        this.element = jsonElement;
        this.value = Optional.empty();
    }

    public DRBiomeWrapper(Optional<T> t, Void v) {
        this(Optional.empty());
        this.setValue(t);
    }

    public static <T> DRBiomeWrapper<T> of(T t) {
        return new DRBiomeWrapper<T>(Optional.ofNullable(t), null);
    }

    public static <T> Codec<DRBiomeWrapper<T>> codec() {
        return ExtraCodecs.JSON.xmap(c -> new DRBiomeWrapper(Optional.ofNullable(c)), c -> c.getElement().orElse(null));
    }

    public static <T> Codec<DRBiomeWrapper<T>> codec2(Codec<T> codecT) {
        return codecT.xmap(DRBiomeWrapper::of, c -> c.getValue().orElse(null));
    }

    public static <T> Codec<DRBiomeWrapper<T>> mapCodec(Codec<T> codecT) {
        return Codec.of(DRBiomeWrapper.codec2(codecT), DRBiomeWrapper.codec());
    }

    public void set(HolderLookup.Provider registries, Codec<T> codec) {
        this.element.ifPresent(jsonElement -> CodecTranferUtil.decode(registries, JsonOps.INSTANCE, codec, jsonElement, biomeHolderSet -> this.setValue(Optional.of(biomeHolderSet))));
    }

    public DRBiomeWrapper<T> build(HolderLookup.Provider registries, Codec<T> codec) {
        AtomicReference drBiomeWrapper = new AtomicReference();
        this.value.ifPresent(biomeHolderSet -> CodecTranferUtil.encode(registries, JsonOps.INSTANCE, codec, biomeHolderSet, jsonElement -> drBiomeWrapper.set(new DRBiomeWrapper(Optional.ofNullable(jsonElement)))));
        return (DRBiomeWrapper)drBiomeWrapper.get();
    }

    @Generated
    public Optional<JsonElement> getElement() {
        return this.element;
    }

    @Generated
    public Optional<T> getValue() {
        return this.value;
    }

    @Generated
    public void setValue(Optional<T> value) {
        this.value = value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DRBiomeWrapper)) {
            return false;
        }
        DRBiomeWrapper other = (DRBiomeWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Optional<JsonElement> this$element = this.getElement();
        Optional<JsonElement> other$element = other.getElement();
        if (this$element == null ? other$element != null : !((Object)this$element).equals(other$element)) {
            return false;
        }
        Optional<T> this$value = this.getValue();
        Optional<T> other$value = other.getValue();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DRBiomeWrapper;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<JsonElement> $element = this.getElement();
        result = result * 59 + ($element == null ? 43 : ((Object)$element).hashCode());
        Optional<T> $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DRBiomeWrapper(element=" + String.valueOf(this.getElement()) + ", value=" + String.valueOf(this.getValue()) + ")";
    }
}

