/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.data.season;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamtea.eclipticseasons.api.constant.solar.ISolarTerm;
import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.util.codec.ESExtraCodec;
import com.teamtea.eclipticseasons.common.misc.SimplePair;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;

public record SeasonPhase(Season season, ResourceLocation name, ChatFormatting color, Optional<Icon> icon, FontIcon fontIcon) implements ISolarTerm
{
    public static final Codec<SeasonPhase> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)ESExtraCodec.SEASON.fieldOf("season").forGetter(SeasonPhase::season), (App)ResourceLocation.CODEC.fieldOf("name").forGetter(SeasonPhase::name), (App)StringRepresentable.fromEnum(ChatFormatting::values).fieldOf("color").forGetter(SeasonPhase::color), (App)Icon.CODEC.optionalFieldOf("icon").forGetter(SeasonPhase::icon), (App)FontIcon.CODEC.fieldOf("font").forGetter(SeasonPhase::fontIcon)).apply((Applicative)ins, SeasonPhase::new));

    public String getMod() {
        return this.name().getNamespace().toLowerCase(Locale.ROOT);
    }

    public String getName() {
        return this.name().getPath().toLowerCase(Locale.ROOT);
    }

    @Override
    public MutableComponent getTranslation() {
        return Component.translatable((String)("info." + this.getMod() + ".environment.season_phase." + this.getName())).withStyle(this.color());
    }

    @Override
    public MutableComponent getTittleTranslation() {
        return Component.translatable((String)"info.eclipticseasons.environment.season_phase.hint").withStyle(this.color());
    }

    @Override
    public MutableComponent getAlternationText() {
        return Component.translatable((String)("info." + this.getMod() + ".environment.season_phase.alternation." + this.getName())).withStyle(this.color());
    }

    @Override
    public MutableComponent getPatternTranslation() {
        return Component.translatable((String)("info." + this.getMod() + ".environment.season_phase.pattern." + this.getName()), (Object[])new Object[]{this.getTranslation()}).withStyle(this.color());
    }

    @Override
    public ChatFormatting getColor() {
        return this.color();
    }

    @Override
    public ResourceLocation getIconFont() {
        return this.fontIcon().font();
    }

    @Override
    public ResourceLocation getIcon() {
        return this.icon().isPresent() ? this.icon().get().texture() : this.name().withPrefix(ESRegistries.SEASON_PHASE.location().getPath() + "/");
    }

    @Override
    public String getFontLabel() {
        return this.fontIcon().label();
    }

    @Override
    public SimplePair<Integer, Integer> getIconPosition() {
        return this.icon().isPresent() ? SimplePair.of(this.icon().get().x, this.icon().get().y) : SimplePair.of(0, 0);
    }

    @Override
    public int getIconAtlasSize() {
        return this.icon().isPresent() ? this.icon().get().size() : 30;
    }

    @Override
    public int getIconWidth() {
        return this.icon().isPresent() ? this.icon().get().width() : 30;
    }

    @Override
    public int getIconHeight() {
        return this.icon().isPresent() ? this.icon().get().height() : 30;
    }

    public record FontIcon(ResourceLocation font, String label) {
        public static final Codec<FontIcon> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(FontIcon::font), (App)Codec.STRING.fieldOf("label").forGetter(FontIcon::label)).apply((Applicative)ins, FontIcon::new));
    }

    public record Icon(ResourceLocation texture, int width, int height, int size, int x, int y) {
        public static final Codec<Icon> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(Icon::texture), (App)Codec.INT.optionalFieldOf("width", (Object)30).forGetter(Icon::width), (App)Codec.INT.optionalFieldOf("height", (Object)30).forGetter(Icon::height), (App)Codec.INT.optionalFieldOf("size", (Object)30).forGetter(Icon::size), (App)Codec.INT.optionalFieldOf("i", (Object)0).forGetter(Icon::x), (App)Codec.INT.optionalFieldOf("j", (Object)0).forGetter(Icon::y)).apply((Applicative)ins, Icon::new));

        public Icon(ResourceLocation texture) {
            this(texture, 30, 30, 30, 0, 0);
        }
    }
}

