/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.data.season.definition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamtea.eclipticseasons.api.data.season.definition.selector.IChangeSelector;
import com.teamtea.eclipticseasons.api.util.codec.CodecUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public record ChangeMode(BlockPredicate original, List<IChangeSelector> selectors, float chance, boolean fixedSeed) {
    public static final Codec<ChangeMode> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)BlockPredicate.CODEC.fieldOf("target").forGetter(ChangeMode::original), (App)CodecUtil.listFrom(IChangeSelector.CCODEC).fieldOf("place").forGetter(ChangeMode::selectors), (App)Codec.FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(0.0625f)).forGetter(ChangeMode::chance), (App)Codec.BOOL.optionalFieldOf("fixed_seed", (Object)false).forGetter(ChangeMode::fixedSeed)).apply((Applicative)ins, ChangeMode::new));

    public List<BlockState> getPossibleStates() {
        ArrayList<BlockState> blockStates;
        block5: {
            block4: {
                blockStates = new ArrayList<BlockState>();
                if (!this.original.blocks().isPresent()) break block4;
                for (Holder blockHolder : (HolderSet)this.original.blocks().get()) {
                    for (BlockState possibleState : ((Block)blockHolder.value()).getStateDefinition().getPossibleStates()) {
                        if (!this.original.properties().isEmpty() && !((StatePropertiesPredicate)this.original.properties().get()).matches(possibleState)) continue;
                        blockStates.add(possibleState);
                    }
                }
                break block5;
            }
            if (!this.original.properties().isPresent()) break block5;
            for (Block block : BuiltInRegistries.BLOCK) {
                for (BlockState possibleState : block.getStateDefinition().getPossibleStates()) {
                    if (!this.original.properties().isEmpty() && !((StatePropertiesPredicate)this.original.properties().get()).matches(possibleState)) continue;
                    blockStates.add(possibleState);
                }
            }
        }
        return blockStates;
    }

    public List<Block> getPossibleBlocks() {
        ArrayList<Block> blocks;
        block4: {
            block3: {
                blocks = new ArrayList<Block>();
                if (!this.original.blocks().isPresent()) break block3;
                for (Holder blockHolder : (HolderSet)this.original.blocks().get()) {
                    blocks.add((Block)blockHolder.value());
                }
                break block4;
            }
            if (!this.original.properties().isPresent()) break block4;
            block1: for (Block block : BuiltInRegistries.BLOCK) {
                for (BlockState possibleState : block.getStateDefinition().getPossibleStates()) {
                    if (!this.original.properties().isEmpty() && !((StatePropertiesPredicate)this.original.properties().get()).matches(possibleState)) continue;
                    blocks.add(block);
                    continue block1;
                }
            }
        }
        return blocks;
    }

    public boolean matchesState(BlockState state) {
        return !(!this.original.blocks().isEmpty() && !state.is((HolderSet)this.original.blocks().get()) || !this.original.properties().isEmpty() && !((StatePropertiesPredicate)this.original.properties().get()).matches(state));
    }

    private static boolean matchesBlockEntity(LevelReader level, @Nullable BlockEntity blockEntity, NbtPredicate nbtPredicate) {
        return blockEntity != null && nbtPredicate.matches((Tag)blockEntity.saveWithFullMetadata((HolderLookup.Provider)level.registryAccess()));
    }

    public boolean matches(BlockState state, Level level, BlockPos pos) {
        if (!this.original.requiresNbt()) {
            return this.matchesState(state);
        }
        if (!level.isLoaded(pos)) {
            return false;
        }
        return this.matchesState(level.getBlockState(pos)) && (this.original.nbt().isEmpty() || ChangeMode.matchesBlockEntity((LevelReader)level, level.getBlockEntity(pos), (NbtPredicate)this.original.nbt().get()));
    }

    @Generated
    public static ChangeModeBuilder builder() {
        return new ChangeModeBuilder();
    }

    @Generated
    public static class ChangeModeBuilder {
        @Generated
        private BlockPredicate original;
        @Generated
        private ArrayList<IChangeSelector> selectors;
        @Generated
        private float chance;
        @Generated
        private boolean fixedSeed;

        @Generated
        ChangeModeBuilder() {
        }

        @Generated
        public ChangeModeBuilder original(BlockPredicate original) {
            this.original = original;
            return this;
        }

        @Generated
        public ChangeModeBuilder selector(IChangeSelector selector) {
            if (this.selectors == null) {
                this.selectors = new ArrayList();
            }
            this.selectors.add(selector);
            return this;
        }

        @Generated
        public ChangeModeBuilder selectors(Collection<? extends IChangeSelector> selectors) {
            if (selectors == null) {
                throw new NullPointerException("selectors cannot be null");
            }
            if (this.selectors == null) {
                this.selectors = new ArrayList();
            }
            this.selectors.addAll(selectors);
            return this;
        }

        @Generated
        public ChangeModeBuilder clearSelectors() {
            if (this.selectors != null) {
                this.selectors.clear();
            }
            return this;
        }

        @Generated
        public ChangeModeBuilder chance(float chance) {
            this.chance = chance;
            return this;
        }

        @Generated
        public ChangeModeBuilder fixedSeed(boolean fixedSeed) {
            this.fixedSeed = fixedSeed;
            return this;
        }

        @Generated
        public ChangeMode build() {
            return new ChangeMode(this.original, switch (this.selectors == null ? 0 : this.selectors.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.selectors.get(0));
                default -> Collections.unmodifiableList(new ArrayList<IChangeSelector>(this.selectors));
            }, this.chance, this.fixedSeed);
        }

        @Generated
        public String toString() {
            return "ChangeMode.ChangeModeBuilder(original=" + String.valueOf(this.original) + ", selectors=" + String.valueOf(this.selectors) + ", chance=" + this.chance + ", fixedSeed=" + this.fixedSeed + ")";
        }
    }
}

