/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.util;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.constant.biome.Humidity;
import com.teamtea.eclipticseasons.api.constant.solar.ISolarTerm;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.common.core.biome.BiomeClimateManager;
import com.teamtea.eclipticseasons.common.core.solar.SolarTermHelper;
import com.teamtea.eclipticseasons.common.misc.SimplePair;
import com.teamtea.eclipticseasons.common.misc.SolarTermHumidityChart;
import com.teamtea.eclipticseasons.config.CommonConfig;
import java.io.File;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SequencedCollection;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import net.neoforged.fml.loading.FMLLoader;

public class SimpleUtil {
    public static long testTime(Runnable runnable) {
        long time = System.nanoTime();
        for (int zzz = 0; zzz < 10000000; ++zzz) {
            runnable.run();
        }
        long l = System.nanoTime() - time;
        long l1 = l / 1000000L;
        EclipticSeasons.logger(l1 + " ms", l);
        return l1;
    }

    public static String getModUse(int offset) {
        try {
            return Optional.of(Class.forName(Thread.currentThread().getStackTrace()[offset].getClassName())).map(Class::getProtectionDomain).map(ProtectionDomain::getCodeSource).map(CodeSource::getLocation).map(URL::getFile).map(it -> new File(it.split("%23")[0]).getAbsolutePath()).map(i -> FMLLoader.getLoadingModList().getModFiles().stream().filter(modFileInfo -> new File(modFileInfo.getFile().getFilePath().toString()).getAbsolutePath().equals(i)).findFirst().get()).map(modFileInfo -> modFileInfo.getFile().getModFileInfo().moduleName()).get();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static List<String> getModsUse(int offset) {
        ArrayList<String> strings = new ArrayList<String>();
        for (int i = 2; i < 15; ++i) {
            strings.add(SimpleUtil.getModUse(i));
        }
        return new ArrayList<String>(new HashSet(strings));
    }

    public static <E> void warningForModWrongCalling(ResourceKey<? extends Registry<? extends E>> registryKey) {
        SimpleUtil.warningForModWrongCalling("Warning for call " + String.valueOf(registryKey) + " at wrong time.");
    }

    public static void warningForModWrongCalling(String message) {
        HashSet<String> strings = new HashSet<String>(SimpleUtil.getModsUse(0));
        strings.removeIf(s -> s.equals("eclipticseasons"));
        strings.removeIf(s -> s.equals("neoforge"));
        strings.removeIf(s -> s.equals("minecraft"));
        strings.removeIf(String::isEmpty);
        EclipticSeasons.logger(message);
        EclipticSeasons.logger("Suspected mod: " + String.join((CharSequence)",", strings));
    }

    public static MutableComponent addSolarIconBefore(SolarTerm solarTerm, MutableComponent mutableComponent) {
        Style noBitstyle = mutableComponent.getStyle().withFont(mutableComponent.getStyle().getFont());
        Style aDefault = Style.EMPTY.withFont(ResourceLocation.withDefaultNamespace((String)"default"));
        Style style = Style.EMPTY.withFont(SolarTerm.getFont());
        return Component.literal((String)solarTerm.getFontLabel()).withStyle(style.withColor(TextColor.fromRgb((int)-1))).append((Component)Component.literal((String)" ").withStyle(aDefault).append((Component)mutableComponent));
    }

    public static MutableComponent addSolarIconBefore(ISolarTerm solarTerm, MutableComponent mutableComponent) {
        Style aDefault = Style.EMPTY.withFont(ResourceLocation.withDefaultNamespace((String)"default"));
        Style style = Style.EMPTY.withFont(solarTerm.getIconFont());
        return Component.literal((String)solarTerm.getFontLabel()).withStyle(style.withColor(TextColor.fromRgb((int)-1))).append((Component)Component.literal((String)" ").withStyle(aDefault).append((Component)mutableComponent));
    }

    public static MutableComponent getSolarTermMessage(SolarTerm solarTerm) {
        return Component.empty().append((Component)Component.translatable((String)"info.eclipticseasons.environment.solar_term.message", (Object[])new Object[]{CommonConfig.Season.enableInformIcon.getAsBoolean() ? SimpleUtil.addSolarIconBefore(solarTerm, solarTerm.getAlternationText()) : solarTerm.getAlternationText()}));
    }

    public static void sendSolarTermMessage(ServerPlayer player, SolarTerm solarTerm, boolean ignoreChangeCheck) {
        ISolarTerm iSolarTerm = SolarTermHelper.isChangedAndGet(player.level(), player.blockPosition(), solarTerm, solarTerm.getLastSolarTerm(), ignoreChangeCheck);
        if (iSolarTerm != null) {
            MutableComponent translatable = Component.translatable((String)"info.eclipticseasons.environment.solar_term.message", (Object[])new Object[]{(Boolean)CommonConfig.Season.enableInformIcon.get() != false ? SimpleUtil.addSolarIconBefore(iSolarTerm, iSolarTerm.getAlternationText()) : solarTerm.getAlternationText()});
            player.sendSystemMessage((Component)translatable, false);
        }
    }

    public static void printHumidityTable(Level level) {
        Registry biomes = level.registryAccess().registryOrThrow(Registries.BIOME);
        List collect = biomes.entrySet().stream().sorted(Map.Entry.comparingByKey()).toList();
        ArrayList ss = new ArrayList();
        SequencedCollection<SimplePair<ResourceLocation, Humidity>> pairs = new ArrayList<SimplePair>();
        for (Map.Entry e : collect) {
            Humidity humidity = Humidity.getHumid(((Biome)e.getValue()).getModifiedClimateSettings().downfall(), ((Biome)e.getValue()).getModifiedClimateSettings().temperature());
            if (!biomes.getHolderOrThrow((ResourceKey)e.getKey()).is(BiomeTags.IS_OVERWORLD) || !((ResourceKey)e.getKey()).location().getNamespace().contains("natures_spirit")) continue;
            ArrayList<String> s2 = new ArrayList<String>();
            s2.add(Component.translatable((String)Util.makeDescriptionId((String)"biome", (ResourceLocation)((ResourceKey)e.getKey()).location())).getString());
            s2.add(((ResourceKey)e.getKey()).location().toString());
            s2.add(humidity.getTranslation().getString());
            s2.add(humidity.toString());
            ss.add(s2);
            pairs.add(SimplePair.of(((ResourceKey)e.getKey()).location(), humidity));
        }
        pairs.sort(Comparator.comparing(SimplePair::getValue));
        pairs = pairs.reversed();
        StringBuilder stringBuilder = new StringBuilder("\n");
        for (SimplePair simplePair : pairs) {
            stringBuilder.append("\n|%s|%s|%s|%s|".formatted(Component.translatable((String)Util.makeDescriptionId((String)"biome", (ResourceLocation)((ResourceLocation)simplePair.getKey()))).getString(), simplePair.getKey(), ((Humidity)simplePair.getValue()).getTranslation().getString(), ((Humidity)simplePair.getValue()).getName()));
        }
        EclipticSeasons.logger(stringBuilder);
        EclipticSeasons.logger("------------------------end-----------------------");
    }

    public static void exportHumidityChart(Level level, String namespace) {
        SimpleUtil.printHumidityTable(level);
        Registry biomes = level.registryAccess().registryOrThrow(Registries.BIOME);
        List collect = biomes.entrySet().stream().sorted(Map.Entry.comparingByKey()).toList();
        for (Map.Entry e : collect) {
            if (!biomes.getHolderOrThrow((ResourceKey)e.getKey()).is(BiomeTags.IS_OVERWORLD) || !((ResourceKey)e.getKey()).location().getNamespace().contains(namespace)) continue;
            Holder<Biome> biomeHolder = BiomeClimateManager.getHolder(level.registryAccess(), (Biome)e.getValue());
            double[] humidities = new double[24];
            for (int i = 0; i < 24; ++i) {
                SolarTerm solarTerm = SolarTerm.collectValues()[i];
                humidities[i] = EclipticUtil.getHumidityConstantFloat(solarTerm, biomeHolder, !level.isClientSide());
            }
            String biomeName = Component.translatable((String)Util.makeDescriptionId((String)"biome", (ResourceLocation)((ResourceKey)e.getKey()).location())).getString();
            SolarTermHumidityChart chart = new SolarTermHumidityChart(biomeName, humidities);
            if (!new File("eclipticseasons").exists()) {
                new File("eclipticseasons").mkdir();
            }
            if (!new File("eclipticseasons/humid").exists()) {
                new File("eclipticseasons/humid").mkdir();
            }
            if (!new File("eclipticseasons/humid/" + namespace).exists()) {
                new File("eclipticseasons/humid/" + namespace).mkdir();
            }
            chart.exportToImage("%s/humid/%s/%s.png".formatted("eclipticseasons", namespace, biomeName), "png", 800, 400);
        }
    }

    public static <T> List<Holder<T>> holderSetToList(HolderSet<T> holders) {
        ArrayList<Holder<T>> holderList = new ArrayList<Holder<T>>();
        for (int i = 0; i < holders.size(); ++i) {
            holderList.add(holders.get(i));
        }
        return holderList;
    }

    private static int getWorldgenNoise(ServerPlayer player, ServerLevel level, BlockPos blockPos) {
        int x = QuartPos.fromBlock((int)blockPos.getX());
        int y = QuartPos.fromBlock((int)blockPos.getY());
        int z = QuartPos.fromBlock((int)blockPos.getZ());
        Climate.TargetPoint targetPoint = level.getChunkSource().randomState().sampler().sample(x, y, z);
        float c = Climate.unquantizeCoord((long)targetPoint.continentalness());
        float e = Climate.unquantizeCoord((long)targetPoint.erosion());
        float t = Climate.unquantizeCoord((long)targetPoint.temperature());
        float h = Climate.unquantizeCoord((long)targetPoint.humidity());
        float w = Climate.unquantizeCoord((long)targetPoint.weirdness());
        OverworldBiomeBuilder overworldBiomeBuilder = new OverworldBiomeBuilder();
        return 0;
    }
}

