/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.constant.biome.Humidity;
import com.teamtea.eclipticseasons.api.constant.biome.Rainfall;
import com.teamtea.eclipticseasons.api.constant.biome.Temperature;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.client.ClientEventHandler;
import com.teamtea.eclipticseasons.client.color.season.BiomeColorsHandler;
import com.teamtea.eclipticseasons.client.core.ExtraModelManager;
import com.teamtea.eclipticseasons.client.itemproperties.CounterItemProperty;
import com.teamtea.eclipticseasons.client.model.ItemRenderModel;
import com.teamtea.eclipticseasons.client.model.SnowyBakedModelWrapper;
import com.teamtea.eclipticseasons.client.model.loader.SnowOverlayModel;
import com.teamtea.eclipticseasons.client.particle.ButterflyParticle;
import com.teamtea.eclipticseasons.client.particle.FallenLeavesParticle;
import com.teamtea.eclipticseasons.client.particle.FireflyParticle;
import com.teamtea.eclipticseasons.client.particle.GreenHouseParticle;
import com.teamtea.eclipticseasons.client.particle.ParticleUtil;
import com.teamtea.eclipticseasons.client.particle.WildGooseParticle;
import com.teamtea.eclipticseasons.client.reload.ClientJsonCacheListener;
import com.teamtea.eclipticseasons.client.render.ber.BlockInBlockRender;
import com.teamtea.eclipticseasons.client.render.ber.CalendarBlockEntityRenderer;
import com.teamtea.eclipticseasons.client.render.ber.GreenHouseCoreFrameRenderer;
import com.teamtea.eclipticseasons.client.render.ber.GreenHouseCoreRenderer;
import com.teamtea.eclipticseasons.client.render.ber.PinWheelRenderer;
import com.teamtea.eclipticseasons.client.render.ber.QuestSignRenderer;
import com.teamtea.eclipticseasons.client.render.ber.WindChimesRenderer;
import com.teamtea.eclipticseasons.client.render.item.ClientGreenHouseItem;
import com.teamtea.eclipticseasons.client.render.item.GreenHouseCoreCoreItemRenderer;
import com.teamtea.eclipticseasons.client.render.item.GreenHouseCoreFrameItemRenderer;
import com.teamtea.eclipticseasons.client.render.item.GreenHouseCoreItemRenderer;
import com.teamtea.eclipticseasons.client.util.ClientClientAgent;
import com.teamtea.eclipticseasons.client.util.ClientCon;
import com.teamtea.eclipticseasons.client.util.ClientExtraUtil;
import com.teamtea.eclipticseasons.common.registry.BlockEntityRegistry;
import com.teamtea.eclipticseasons.common.registry.BlockRegistry;
import com.teamtea.eclipticseasons.common.registry.ItemRegistry;
import com.teamtea.eclipticseasons.common.registry.ParticleRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.registries.DeferredHolder;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientSetup {
    @SubscribeEvent
    public static void addTooltips(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(ClientEventHandler.mccc.class, ClientEventHandler.ccc::new);
    }

    @SubscribeEvent
    public static void blockRegister(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ParticleRegistry.FIREFLY, p_277215_ -> (particleType, level, x, y, z, p_277222_, p_277223_, p_277224_) -> new FireflyParticle(level, x, y, z, p_277215_));
        event.registerSpriteSet((ParticleType)ParticleRegistry.WILD_GOOSE, p_277215_ -> (particleType, level, x, y, z, p_277222_, p_277223_, p_277224_) -> new WildGooseParticle(level, x, y, z, 0.01, 0.01, 0.01, p_277215_));
        event.registerSpriteSet((ParticleType)ParticleRegistry.BUTTERFLY, p_277215_ -> (particleType, level, x, y, z, p_277222_, p_277223_, p_277224_) -> new ButterflyParticle(level, x, y, z, p_277215_));
        event.registerSpriteSet(ParticleRegistry.FALLEN_LEAVES, p_277215_ -> (particleType, level, x, y, z, p_277222_, p_277223_, p_277224_) -> new FallenLeavesParticle(level, x, y, z, p_277222_, p_277223_, p_277224_, (ColorParticleOption)particleType, p_277215_));
        event.registerSpriteSet(ParticleRegistry.FLYING_BLOOM, p_277215_ -> (particleType, level, x, y, z, p_277222_, p_277223_, p_277224_) -> new FallenLeavesParticle(level, x, y, z, p_277222_, p_277223_, p_277224_, (ColorParticleOption)particleType, p_277215_));
        event.registerSpriteSet(ParticleRegistry.GREENHOUSE, p_277215_ -> (particleType, level, x, y, z, p_277222_, p_277223_, p_277224_) -> new GreenHouseParticle(level, x, y, z, p_277222_, p_277223_, p_277224_, (ColorParticleOption)particleType, p_277215_));
    }

    @SubscribeEvent
    public static void registerExtraModels(ModelEvent.RegisterAdditional event) {
        event.register(ExtraModelManager.snowy_custom);
        event.register(ExtraModelManager.snowy_custom_ao);
        event.register(ExtraModelManager.stairs_top);
        event.register(ExtraModelManager.snowy_leaves_attach);
        event.register(ExtraModelManager.snowy_leaves_top);
        event.register(ExtraModelManager.snowy_fern);
        event.register(ExtraModelManager.snowy_grass);
        event.register(ExtraModelManager.snowy_tall_grass_top);
        event.register(ExtraModelManager.snowy_tall_grass_bottom);
        event.register(ExtraModelManager.snowy_large_fern_top);
        event.register(ExtraModelManager.snowy_large_fern_bottom);
        event.register(ExtraModelManager.overlay_2);
        event.register(ExtraModelManager.snow_height2);
        event.register(ExtraModelManager.snow_height2_top);
        event.register(ExtraModelManager.grass_flower);
        for (ModelResourceLocation flowerOnGrass : ExtraModelManager.flower_on_grass) {
            event.register(flowerOnGrass);
        }
        for (ModelResourceLocation flowerOnGrass : ExtraModelManager.fourleaf_clovers) {
            event.register(flowerOnGrass);
        }
        for (ModelResourceLocation flowerOnGrass : ExtraModelManager.snow_edge_overlays) {
            event.register(flowerOnGrass);
        }
        event.register(ExtraModelManager.ice);
    }

    @SubscribeEvent
    public static void onClientEvent(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            BiomeColors.GRASS_COLOR_RESOLVER = BiomeColorsHandler.GRASS_COLOR;
            BiomeColors.FOLIAGE_COLOR_RESOLVER = BiomeColorsHandler.FOLIAGE_COLOR;
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockRegistry.bamboo_wind_chimes.get()), (RenderType)RenderType.cutoutMipped());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockRegistry.paper_wind_chimes.get()), (RenderType)RenderType.cutoutMipped());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockRegistry.wind_chimes.get()), (RenderType)RenderType.cutoutMipped());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockRegistry.pinwheel_blue.get()), (RenderType)RenderType.cutoutMipped());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockRegistry.pinwheel_lime.get()), (RenderType)RenderType.cutoutMipped());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockRegistry.pinwheel_orange.get()), (RenderType)RenderType.cutoutMipped());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockRegistry.block_in_copper_grate_block.get()), (RenderType)RenderType.cutoutMipped());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockRegistry.block_in_exposed_copper_grate_block.get()), (RenderType)RenderType.cutoutMipped());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockRegistry.block_in_weathered_copper_grate_block.get()), (RenderType)RenderType.cutoutMipped());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockRegistry.block_in_oxidized_copper_grate_block.get()), (RenderType)RenderType.cutoutMipped());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockRegistry.block_in_waxed_copper_grate_block.get()), (RenderType)RenderType.cutoutMipped());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockRegistry.block_in_waxed_exposed_copper_grate_block.get()), (RenderType)RenderType.cutoutMipped());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockRegistry.block_in_waxed_weathered_copper_grate_block.get()), (RenderType)RenderType.cutoutMipped());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockRegistry.block_in_waxed_oxidized_copper_grate_block.get()), (RenderType)RenderType.cutoutMipped());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockRegistry.block_in_wooden_grate_block.get()), (RenderType)RenderType.cutoutMipped());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockRegistry.hygrometer.get()), (RenderType)RenderType.cutoutMipped());
            ItemProperties.register((Item)((Item)ItemRegistry.hyetometer.get()), (ResourceLocation)ItemRegistry.hyetometer.getId(), (ItemPropertyFunction)new CounterItemProperty(EclipticUtil::getRainfallAt, Rainfall.collectValues().length));
            ItemProperties.register((Item)((Item)ItemRegistry.hygrometer.get()), (ResourceLocation)ItemRegistry.hygrometer.getId(), (ItemPropertyFunction)new CounterItemProperty((level, pos) -> {
                float humidityAt = EclipticUtil.getHumidityLevelAt(level, pos);
                humidityAt = ClientExtraUtil.modifyHumidity(level, pos, humidityAt);
                return Humidity.getHumid(humidityAt);
            }, Humidity.collectValues().length));
            ItemProperties.register((Item)((Item)ItemRegistry.thermometer.get()), (ResourceLocation)ItemRegistry.thermometer.getId(), (ItemPropertyFunction)new CounterItemProperty(EclipticUtil::getTemperatureAt, Temperature.collectValues().length));
            ClientCon.agent = new ClientClientAgent();
        });
    }

    @SubscribeEvent
    public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)BlockEntityRegistry.calendar_entity_type.get(), CalendarBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockEntityRegistry.pinwheel_entity_type.get(), PinWheelRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockEntityRegistry.wind_chimes_entity_type.get(), WindChimesRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockEntityRegistry.greenhouse_core_container_entity_type.get(), GreenHouseCoreFrameRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockEntityRegistry.greenhouse_core_entity_type.get(), GreenHouseCoreRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockEntityRegistry.season_quest_hanging_sign_entity_type.get(), QuestSignRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockEntityRegistry.block_in_copper_grate_block_entity_type.get(), BlockInBlockRender::new);
    }

    @SubscribeEvent
    public static void onClientEvent(RegisterClientExtensionsEvent event) {
        event.registerItem((IClientItemExtensions)new ClientGreenHouseItem(new GreenHouseCoreItemRenderer(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels())), new Item[]{(Item)ItemRegistry.spring_greenhouse_core_item.get(), (Item)ItemRegistry.summer_greenhouse_core_item.get(), (Item)ItemRegistry.autumn_greenhouse_core_item.get(), (Item)ItemRegistry.winter_greenhouse_core_item.get()});
        event.registerItem((IClientItemExtensions)new ClientGreenHouseItem(new GreenHouseCoreCoreItemRenderer(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels())), new Item[]{(Item)ItemRegistry.spring_greenhouse_essence_item.get(), (Item)ItemRegistry.summer_greenhouse_essence_item.get(), (Item)ItemRegistry.autumn_greenhouse_essence_item.get(), (Item)ItemRegistry.winter_greenhouse_essence_item.get()});
        event.registerItem((IClientItemExtensions)new ClientGreenHouseItem(new GreenHouseCoreFrameItemRenderer(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels())), new Item[]{(Item)ItemRegistry.greenhouse_core_container_item.get()});
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onModelBaked(ModelEvent.ModifyBakingResult event) {
        ParticleUtil.onReloadResource();
        Map modelRegistry = event.getModels();
        ExtraModelManager.clearForRebaked(modelRegistry);
        ArrayList<ModelResourceLocation> bakedModels = new ArrayList<ModelResourceLocation>(List.of(ExtraModelManager.snowy_custom, ExtraModelManager.snowy_custom_ao, ExtraModelManager.stairs_top, ExtraModelManager.snowy_leaves_attach, ExtraModelManager.snowy_leaves_top, ExtraModelManager.stairs_top, ExtraModelManager.snowy_fern, ExtraModelManager.snowy_grass, ExtraModelManager.snowy_tall_grass_top, ExtraModelManager.snowy_tall_grass_bottom, ExtraModelManager.snowy_large_fern_top, ExtraModelManager.snowy_large_fern_bottom, ExtraModelManager.overlay_2, ExtraModelManager.snow_height2, ExtraModelManager.snow_height2_top, ExtraModelManager.snowOverlayLeaves, ExtraModelManager.snowySlabBottom, ExtraModelManager.snowOverlayBlock));
        List.of(BlockRegistry.snowyBlock, BlockRegistry.snowyLeaves, BlockRegistry.snowySlab, BlockRegistry.snowyStairs, BlockRegistry.snowyVine).forEach(bh -> bakedModels.addAll(((Block)bh.get()).getStateDefinition().getPossibleStates().stream().map(BlockModelShaper::stateToModelLocation).toList()));
        for (ModelResourceLocation modelResourceLocation : bakedModels) {
            BakedModel bakedModel1 = (BakedModel)modelRegistry.get(modelResourceLocation);
            if (bakedModel1 != null) {
                modelRegistry.put(modelResourceLocation, new SnowyBakedModelWrapper<BakedModel>(bakedModel1));
                continue;
            }
            EclipticSeasons.logger("Missing Model", modelResourceLocation);
        }
        for (DeferredHolder deferredHolder : List.of(ItemRegistry.greenhouse_core_container_item, ItemRegistry.spring_greenhouse_core_item, ItemRegistry.summer_greenhouse_core_item, ItemRegistry.autumn_greenhouse_core_item, ItemRegistry.winter_greenhouse_core_item, ItemRegistry.spring_greenhouse_essence_item, ItemRegistry.summer_greenhouse_essence_item, ItemRegistry.autumn_greenhouse_essence_item, ItemRegistry.winter_greenhouse_essence_item)) {
            ModelResourceLocation inventory = ModelResourceLocation.inventory((ResourceLocation)deferredHolder.getId());
            BakedModel itemModel = modelRegistry.getOrDefault(inventory, null);
            if (itemModel == null) continue;
            modelRegistry.put(inventory, new ItemRenderModel<BakedModel>(itemModel));
        }
    }

    @SubscribeEvent
    public static void onRegisterColorHandlersEvent_Block(RegisterColorHandlersEvent.Block event) {
        event.register((state, blockAndTintGetter, pos, i) -> {
            if (i == 1) {
                return blockAndTintGetter != null && pos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)blockAndTintGetter, (BlockPos)pos) : GrassColor.getDefaultColor();
            }
            return -1;
        }, new Block[]{Blocks.DANDELION});
        event.register(BiomeColorsHandler::getSpruceColor, new Block[]{Blocks.SPRUCE_LEAVES});
        event.register(BiomeColorsHandler::getBirchColor, new Block[]{Blocks.BIRCH_LEAVES});
        event.register(BiomeColorsHandler::getMangroveColor, new Block[]{Blocks.MANGROVE_LEAVES});
    }

    @SubscribeEvent
    public static void onRegisterColorHandlersEvent_Item(RegisterColorHandlersEvent.Item event) {
    }

    @SubscribeEvent
    public static void onRegisterShader(RegisterShadersEvent event) {
    }

    @SubscribeEvent
    public static void onRegisterClientReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener(ClientJsonCacheListener.biomeCache);
        event.registerReloadListener(ClientJsonCacheListener.leafCache);
        event.registerReloadListener(ClientJsonCacheListener.snowDefOverrideCache);
        event.registerReloadListener(ClientJsonCacheListener.ambientCache);
        event.registerReloadListener(ClientJsonCacheListener.seasonDefCache);
    }

    @SubscribeEvent
    public static void registerExtraModels(ModelEvent.RegisterGeometryLoaders event) {
        event.register(EclipticSeasons.rl("snow_overlay"), (IGeometryLoader)SnowOverlayModel.Loader.INSTANCE);
    }
}

