/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.itemproperties;

import com.teamtea.eclipticseasons.api.misc.ITranslatable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CounterItemProperty
implements ClampedItemPropertyFunction {
    private final BiomePosFunction<Level, BlockPos, ITranslatable> biomeIntegerFunction;
    private final float maxLength;

    public CounterItemProperty(BiomePosFunction<Level, BlockPos, ITranslatable> biomeIntegerFunction, float maxLength) {
        this.biomeIntegerFunction = biomeIntegerFunction;
        this.maxLength = maxLength;
    }

    public float unclampedCall(@NotNull ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
        Object newEntity = entity != null ? entity : stack.getEntityRepresentation();
        level = this.tryFixLevelAnyway((Entity)newEntity, level);
        if (level != null) {
            BlockPos blockPosition = newEntity.blockPosition();
            return (float)this.biomeIntegerFunction.apply((Level)level, blockPosition).ordinal() * (1.0f / (this.maxLength - 1.0f));
        }
        return 0.0f;
    }

    @javax.annotation.Nullable
    private ClientLevel tryFixLevelAnyway(Entity entity, @javax.annotation.Nullable ClientLevel level) {
        if (entity == null) {
            return null;
        }
        return level == null && entity.level() instanceof ClientLevel ? (ClientLevel)entity.level() : level;
    }

    @FunctionalInterface
    public static interface BiomePosFunction<B, P, I> {
        public I apply(B var1, P var2);
    }
}

