/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.MultiPartBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.MultipartModelData;
import net.neoforged.neoforge.common.util.ConcatenatedListView;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiPartBakedModelLike
extends MultiPartBakedModel {
    protected final List<Pair<Predicate<BlockState>, BakedModel>> selectors;

    public MultiPartBakedModelLike(List<Pair<Predicate<BlockState>, BakedModel>> pSelectors) {
        super(pSelectors);
        this.selectors = pSelectors;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState pState, @Nullable Direction pDirection, @NotNull RandomSource pRandom, @NotNull ModelData modelData, @Nullable RenderType renderType) {
        if (pState == null) {
            return Collections.emptyList();
        }
        BitSet bitset = this.getSelectors(pState);
        ArrayList list = Lists.newArrayList();
        long k = pRandom.nextLong();
        for (int j = 0; j < bitset.length(); ++j) {
            if (!bitset.get(j)) continue;
            BakedModel model = (BakedModel)this.selectors.get(j).getRight();
            list.add(model.getQuads(pState, pDirection, RandomSource.create((long)k), MultipartModelData.resolve((ModelData)modelData, (BakedModel)model), renderType));
        }
        return ConcatenatedListView.of((List)list);
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return ChunkRenderTypeSet.all();
    }

    public static class Builder {
        protected final List<Pair<Predicate<BlockState>, BakedModel>> selectors = Lists.newArrayList();

        public void add(Predicate<BlockState> pPredicate, BakedModel pModel) {
            this.selectors.add((Pair<Predicate<BlockState>, BakedModel>)Pair.of(pPredicate, (Object)pModel));
        }

        public BakedModel build() {
            return new MultiPartBakedModelLike(this.selectors);
        }
    }
}

