/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.model;

import com.mojang.datafixers.util.Pair;
import com.teamtea.eclipticseasons.api.misc.BiomeHolderPredicate;
import com.teamtea.eclipticseasons.api.misc.client.IMapSlice;
import com.teamtea.eclipticseasons.client.core.ExtraModelManager;
import com.teamtea.eclipticseasons.client.model.SeasonGoingModel;
import com.teamtea.eclipticseasons.client.util.ClientCon;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import com.teamtea.eclipticseasons.compat.vanilla.IExtendBlockView;
import java.util.List;
import lombok.Generated;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.BakedModelWrapper;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.neoforged.neoforge.client.model.data.MultipartModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeasonBiomeGoingModel<T extends BakedModel>
extends BakedModelWrapper<T> {
    public static final ModelProperty<Holder<Biome>> BIOME_PROPERTY = new ModelProperty();
    private final List<Pair<BiomeHolderPredicate, SeasonGoingModel<T>>> models;

    public SeasonBiomeGoingModel(T originalModel, List<Pair<BiomeHolderPredicate, SeasonGoingModel<T>>> models) {
        super(originalModel);
        this.models = models;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
        if ((extraData = MultipartModelData.resolve((ModelData)extraData, (BakedModel)this)).has(BIOME_PROPERTY)) {
            Holder biomeHolder = (Holder)extraData.get(BIOME_PROPERTY);
            for (Pair<BiomeHolderPredicate, SeasonGoingModel<T>> model : this.models) {
                if (!((BiomeHolderPredicate)model.getFirst()).test(biomeHolder)) continue;
                return ((SeasonGoingModel)((Object)model.getSecond())).getQuads(state, side, rand, extraData, renderType);
            }
        }
        return super.getQuads(state, side, rand, extraData, renderType);
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, BlockState state, ModelData modelData) {
        BlockPos.MutableBlockPos mutableBlockPos;
        Holder<Biome> holder;
        ModelData.Builder builder = super.getModelData(level, pos, state, modelData).derive();
        if (level instanceof IMapSlice) {
            IMapSlice iMapSlice = (IMapSlice)level;
            holder = MapChecker.idToBiome(ClientCon.getUseLevel(), iMapSlice.getSurfaceFaceBiomeId(pos));
        } else {
            holder = MapChecker.getSurfaceBiome(ClientCon.getUseLevel(), pos);
        }
        ModelData.Builder modelData1 = builder.with(BIOME_PROPERTY, holder);
        long l = state.getSeed(pos);
        if (level instanceof IExtendBlockView) {
            IExtendBlockView extendBlockView = (IExtendBlockView)level;
            mutableBlockPos = extendBlockView.getModelCheckPos();
        } else {
            mutableBlockPos = null;
        }
        if (ExtraModelManager.canSnowy(level, pos, state, l, mutableBlockPos)) {
            modelData1.with(SeasonGoingModel.SNOW_PROPERTY, (Object)true);
        }
        return modelData1.build();
    }

    @Generated
    public List<Pair<BiomeHolderPredicate, SeasonGoingModel<T>>> getModels() {
        return this.models;
    }
}

