/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.model.bakequad;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.Arrays;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class BakedQuadRetextured
extends BakedQuad {
    private final TextureAtlasSprite texture;
    public static int uvIndex = DefaultVertexFormat.BLOCK.getOffset(VertexFormatElement.UV0) / 4;
    public static int uv2Index = DefaultVertexFormat.BLOCK.getOffset(VertexFormatElement.UV1) / 4;
    public static int normalIndex = DefaultVertexFormat.BLOCK.getOffset(VertexFormatElement.NORMAL) / 4;
    public static int verticeSpace = DefaultVertexFormat.BLOCK.getVertexSize() / 4;

    public BakedQuadRetextured(BakedQuad quad, TextureAtlasSprite textureIn) {
        super(Arrays.copyOf(quad.getVertices(), quad.getVertices().length), -1, quad.getDirection(), quad.getSprite(), quad.isShade(), quad.hasAmbientOcclusion());
        this.texture = textureIn;
        this.remapQuad();
    }

    private void remapQuad() {
        for (int i = 0; i < 4; ++i) {
            int j = verticeSpace * i;
            this.vertices[j + BakedQuadRetextured.uvIndex] = Float.floatToRawIntBits(this.texture.getU(BakedQuadRetextured.getUnInterpolatedU(this.sprite, Float.intBitsToFloat(this.vertices[j + uvIndex]))));
            this.vertices[j + BakedQuadRetextured.uvIndex + 1] = Float.floatToRawIntBits(this.texture.getV(BakedQuadRetextured.getUnInterpolatedV(this.sprite, Float.intBitsToFloat(this.vertices[j + uvIndex + 1]))));
        }
    }

    public TextureAtlasSprite getSprite() {
        return this.texture;
    }

    private static float getUnInterpolatedU(TextureAtlasSprite sprite, float u) {
        float f = sprite.getU1() - sprite.getU0();
        return (u - sprite.getU0()) / f;
    }

    private static float getUnInterpolatedV(TextureAtlasSprite sprite, float v) {
        float f = sprite.getV1() - sprite.getV0();
        return (v - sprite.getV0()) / f;
    }

    public boolean isTinted() {
        return false;
    }
}

