/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.model.bakequad;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;

public class QuadFixer {
    public static int posIndex = DefaultVertexFormat.BLOCK.getOffset(VertexFormatElement.POSITION) / 4;
    public static int vertice_Space = DefaultVertexFormat.BLOCK.getVertexSize() / 4;

    public static List<Object> getBakeQuadInfo(BakedQuad bakedQuad) {
        ArrayList<Object> stringLike = new ArrayList<Object>();
        stringLike.add(bakedQuad.getSprite().contents().name());
        stringLike.add(",");
        stringLike.add(bakedQuad.getDirection());
        stringLike.add(",");
        stringLike.addAll(List.of(Float.valueOf(QuadFixer.getMinX(bakedQuad)), ",", Float.valueOf(QuadFixer.getMinY(bakedQuad)), ",", Float.valueOf(QuadFixer.getMinZ(bakedQuad)), ",", Float.valueOf(QuadFixer.getMaxX(bakedQuad)), ",", Float.valueOf(QuadFixer.getMaxY(bakedQuad)), ",", Float.valueOf(QuadFixer.getMaxZ(bakedQuad))));
        return stringLike;
    }

    public static float getMinValue(int[] vertices, int index) {
        float minV = 1.0f;
        for (int i = 0; i < 4; ++i) {
            int j = vertice_Space * i;
            float v = Float.intBitsToFloat(vertices[j + posIndex + index]);
            if (!(v < minV)) continue;
            minV = v;
        }
        float epsilon = 1.0E-7f;
        return Math.abs(minV) < epsilon ? 0.0f : minV;
    }

    public static float getMaxValue(int[] vertices, int index) {
        float maxV = -1.0f;
        for (int i = 0; i < 4; ++i) {
            int j = vertice_Space * i;
            float v = Float.intBitsToFloat(vertices[j + posIndex + index]);
            if (!(v > maxV)) continue;
            maxV = v;
        }
        return maxV;
    }

    public static float getMaxX(BakedQuad bakedQuad) {
        return QuadFixer.getMaxValue(bakedQuad.getVertices(), 0);
    }

    public static float getMaxY(BakedQuad bakedQuad) {
        return QuadFixer.getMaxValue(bakedQuad.getVertices(), 1);
    }

    public static float getMaxZ(BakedQuad bakedQuad) {
        return QuadFixer.getMaxValue(bakedQuad.getVertices(), 2);
    }

    public static float getMinX(BakedQuad bakedQuad) {
        return QuadFixer.getMinValue(bakedQuad.getVertices(), 0);
    }

    public static float getMinY(BakedQuad bakedQuad) {
        return QuadFixer.getMinValue(bakedQuad.getVertices(), 1);
    }

    public static float getMinZ(BakedQuad bakedQuad) {
        return QuadFixer.getMinValue(bakedQuad.getVertices(), 2);
    }

    public static boolean cover(BakedQuad bakedQuad, BakedQuad testQuad) {
        boolean result;
        float x0 = QuadFixer.getMinX(bakedQuad);
        float x1 = QuadFixer.getMaxX(bakedQuad);
        float x2 = QuadFixer.getMinX(testQuad);
        float x3 = QuadFixer.getMaxX(testQuad);
        float y0 = QuadFixer.getMinY(bakedQuad);
        float y1 = QuadFixer.getMaxY(bakedQuad);
        float y2 = QuadFixer.getMinY(testQuad);
        float y3 = QuadFixer.getMaxY(testQuad);
        float z0 = QuadFixer.getMinZ(bakedQuad);
        float z1 = QuadFixer.getMaxZ(bakedQuad);
        float z2 = QuadFixer.getMinZ(testQuad);
        float z3 = QuadFixer.getMaxZ(testQuad);
        boolean bl = result = (x0 == x1 ? 1 : 0) + (y0 == y1 ? 1 : 0) + (z0 == z1 ? 1 : 0) >= 2;
        if (result) {
            return false;
        }
        if (bakedQuad.getDirection() == Direction.UP) {
            if (y0 > y3 && x1 >= x3 && x0 <= x2 && z1 >= z3 && z0 <= z2) {
                return true;
            }
        } else if (bakedQuad.getDirection() == testQuad.getDirection() && (x0 == x1 && x2 == x3 && x0 == x2 ? z0 <= z2 && z1 >= z3 : z0 == z1 && z2 == z3 && z0 == z2 && x0 <= x2 && x1 >= x3)) {
            return y1 > y3;
        }
        return false;
    }

    public static ArrayList<BakedQuad> fixQuadCTM(ArrayList<BakedQuad> quadsCTM) {
        quadsCTM.removeIf(bakedQuad -> bakedQuad.getDirection() == Direction.DOWN);
        quadsCTM.removeIf(bakedQuad -> bakedQuad.getSprite() == null || bakedQuad.getSprite().contents().name().getPath().contains("grape_small_leaves"));
        quadsCTM.removeIf(bakedQuad -> bakedQuad.getSprite() == null || bakedQuad.getSprite().contents().name().getPath().contains("grape_stage"));
        quadsCTM.sort(Comparator.comparingDouble(b -> QuadFixer.getMaxY((BakedQuad)b)).reversed());
        ArrayList<BakedQuad> visibleFaces = new ArrayList<BakedQuad>();
        for (int i = 0; i < quadsCTM.size(); ++i) {
            BakedQuad faceA = quadsCTM.get(i);
            boolean isCovered = false;
            for (int j = 0; j < i; ++j) {
                BakedQuad faceB = quadsCTM.get(j);
                if (!QuadFixer.cover(faceB, faceA)) continue;
                isCovered = true;
                break;
            }
            if (isCovered) continue;
            visibleFaces.add(faceA);
        }
        return visibleFaces;
    }

    public static Direction getDirectionQuickly(BakedQuad instance) {
        float nz;
        float edge1X;
        float edge2X;
        float ny;
        float edge2Y;
        float edge1Z;
        int[] vertices = instance.getVertices();
        float x0 = Float.intBitsToFloat(vertices[0]);
        float y0 = Float.intBitsToFloat(vertices[1]);
        float z0 = Float.intBitsToFloat(vertices[2]);
        float x1 = Float.intBitsToFloat(vertices[8]);
        float y1 = Float.intBitsToFloat(vertices[9]);
        float z1 = Float.intBitsToFloat(vertices[10]);
        float x3 = Float.intBitsToFloat(vertices[24]);
        float y3 = Float.intBitsToFloat(vertices[25]);
        float edge1Y = y1 - y0;
        float z3 = Float.intBitsToFloat(vertices[26]);
        float edge2Z = z3 - z0;
        float nx = edge1Y * edge2Z - (edge1Z = z1 - z0) * (edge2Y = y3 - y0);
        float len = (float)Math.sqrt(nx * nx + (ny = edge1Z * (edge2X = x3 - x0) - (edge1X = x1 - x0) * edge2Z) * ny + (nz = edge1X * edge2Y - edge1Y * edge2X) * nz);
        if (len > 1.0E-6f) {
            nx /= len;
            ny /= len;
            nz /= len;
        } else {
            return instance.getDirection();
        }
        if (Math.abs(ny) >= 0.2588f) {
            return Direction.UP;
        }
        return Math.abs(nx) > Math.abs(nz) ? (nx > 0.0f ? Direction.EAST : Direction.WEST) : (nz > 0.0f ? Direction.SOUTH : Direction.NORTH);
    }

    public static Direction getDirectionQuickly2(BakedQuad instance) {
        int[] vertices = instance.getVertices();
        if (vertices.length < 32) {
            return instance.getDirection();
        }
        float[][] pos = new float[4][3];
        for (int i = 0; i < 4; ++i) {
            pos[i][0] = Float.intBitsToFloat(vertices[i * 8]);
            pos[i][1] = Float.intBitsToFloat(vertices[i * 8 + 1]);
            pos[i][2] = Float.intBitsToFloat(vertices[i * 8 + 2]);
        }
        int a = 0;
        int b = 1;
        int c = 2;
        float minLen = 1.0E-6f;
        for (int i = 0; i < 4; ++i) {
            for (int j = i + 1; j < 4; ++j) {
                for (int k = j + 1; k < 4; ++k) {
                    float[] v1 = new float[]{pos[j][0] - pos[i][0], pos[j][1] - pos[i][1], pos[j][2] - pos[i][2]};
                    float[] v2 = new float[]{pos[k][0] - pos[i][0], pos[k][1] - pos[i][1], pos[k][2] - pos[i][2]};
                    float[] fArray = new float[]{v1[1] * v2[2] - v1[2] * v2[1], v1[2] * v2[0] - v1[0] * v2[2], v1[0] * v2[1] - v1[1] * v2[0]};
                    float[] cross = fArray;
                    float len = cross[0] * cross[0] + cross[1] * cross[1] + cross[2] * cross[2];
                    if (!(len > minLen)) continue;
                    a = i;
                    b = j;
                    c = k;
                    minLen = len;
                }
            }
        }
        if (minLen <= 1.0E-6f) {
            return instance.getDirection();
        }
        float[] edge1 = new float[]{pos[b][0] - pos[a][0], pos[b][1] - pos[a][1], pos[b][2] - pos[a][2]};
        float[] edge2 = new float[]{pos[c][0] - pos[a][0], pos[c][1] - pos[a][1], pos[c][2] - pos[a][2]};
        float nx = edge1[1] * edge2[2] - edge1[2] * edge2[1];
        float ny = edge1[2] * edge2[0] - edge1[0] * edge2[2];
        float nz = edge1[0] * edge2[1] - edge1[1] * edge2[0];
        float len = (float)Math.sqrt(nx * nx + ny * ny + nz * nz);
        nx /= len;
        ny /= len;
        nz /= len;
        if (Math.abs(ny) >= 0.2588f) {
            return Direction.UP;
        }
        return Math.abs(nx) > Math.abs(nz) ? (nx > 0.0f ? Direction.EAST : Direction.WEST) : (nz > 0.0f ? Direction.SOUTH : Direction.NORTH);
    }
}

