/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class FireflyParticle
extends TextureSheetParticle {
    private final SpriteSet spriteSet;
    private boolean isBlink;
    private Vec3 nextPos;

    public FireflyParticle(ClientLevel level, double x, double y, double z, SpriteSet spriteSet) {
        super(level, x, y, z);
        this.lifetime = 800;
        this.gravity = 1.0E-4f;
        this.spriteSet = spriteSet;
        this.isBlink = false;
        this.setSpriteFromAge(this.spriteSet);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float patialTicks) {
        super.render(vertexConsumer, camera, patialTicks);
    }

    protected void renderRotatedQuad(VertexConsumer pBuffer, Quaternionf pQuaternion, float pX, float pY, float pZ, float pPartialTicks) {
        float quadSize1 = this.getQuadSize(pPartialTicks);
        float u0 = this.getU0();
        float u1 = this.getU1();
        float v0 = this.getV0();
        float v1 = this.getV1();
        int i = this.getLightColor(pPartialTicks);
        i = 0xF000F0;
        if ((double)this.age >= (double)this.lifetime * 0.8) {
            i = this.getLightColor(pPartialTicks);
        }
        double crossY = 0.0;
        if (Minecraft.getInstance().getCameraEntity() != null) {
            Vec3 viewVec = Minecraft.getInstance().getCameraEntity().getLookAngle();
            double vx = viewVec.x;
            double vz = viewVec.z;
            crossY = vx * this.zd - vz * this.xd;
            if (crossY < (double)0.01f) {
                float ut = u0;
                u0 = u1;
                u1 = ut;
            }
        }
        this.renderVertex(pBuffer, pQuaternion, pX, pY, pZ, 1.0f, -1.0f, quadSize1, u1, v1, i, 1.0f);
        this.renderVertex(pBuffer, pQuaternion, pX, pY, pZ, 1.0f, 1.0f, quadSize1, u1, v0, i, 1.0f);
        this.renderVertex(pBuffer, pQuaternion, pX, pY, pZ, -1.0f, 1.0f, quadSize1, u0, v0, i, 1.0f);
        this.renderVertex(pBuffer, pQuaternion, pX, pY, pZ, -1.0f, -1.0f, quadSize1, u0, v1, i, 1.0f);
        if (this.isBlink) {
            TextureAtlasSprite sp1 = this.spriteSet.get(1, 1);
            u0 = sp1.getU0();
            u1 = sp1.getU1();
            v0 = sp1.getV0();
            v1 = sp1.getV1();
            if (crossY < (double)0.01f) {
                float ut = u0;
                u0 = u1;
                u1 = ut;
            }
            this.renderVertex(pBuffer, pQuaternion, pX, pY, pZ, 1.0f, -1.0f, quadSize1, u1, v1, i, 0.5f);
            this.renderVertex(pBuffer, pQuaternion, pX, pY, pZ, 1.0f, 1.0f, quadSize1, u1, v0, i, 0.5f);
            this.renderVertex(pBuffer, pQuaternion, pX, pY, pZ, -1.0f, 1.0f, quadSize1, u0, v0, i, 0.5f);
            this.renderVertex(pBuffer, pQuaternion, pX, pY, pZ, -1.0f, -1.0f, quadSize1, u0, v1, i, 0.5f);
        }
    }

    protected void renderVertex(VertexConsumer pBuffer, Quaternionf pQuaternion, float pX, float pY, float pZ, float pXOffset, float pYOffset, float pQuadSize, float pU, float pV, int pPackedLight, float alpha) {
        Vector3f vector3f = new Vector3f(pXOffset, pYOffset, 0.0f).rotate((Quaternionfc)pQuaternion).mul(pQuadSize).add(pX, pY, pZ);
        pBuffer.addVertex(vector3f.x(), vector3f.y(), vector3f.z()).setUv(pU, pV).setColor(this.rCol, this.gCol, this.bCol, alpha).setLight(pPackedLight);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime || this.onGround) {
            this.remove();
        } else {
            this.isBlink = this.age % 8 > 4 && (double)this.age < (double)this.lifetime * 0.8;
            Vec3 nowPos = new Vec3(this.x, this.y, this.z);
            BlockPos targetPosition = BlockPos.containing((double)(this.x + this.xd), (double)(this.y + this.yd), (double)(this.z + this.zd));
            Vec3 vec3 = Entity.collideBoundingBox((Entity)null, (Vec3)new Vec3(this.xd, this.yd, this.zd), (AABB)this.getBoundingBox(), (Level)this.level, List.of());
            if (this.nextPos != null && (!NaturalSpawner.isValidEmptySpawnBlock((BlockGetter)this.level, (BlockPos)targetPosition, (BlockState)this.level.getBlockState(targetPosition), (FluidState)this.level.getFluidState(targetPosition), (EntityType)EntityType.BAT) || targetPosition.getY() <= this.level.getMinBuildHeight() || Math.abs(vec3.y) < (double)1.0E-5f || this.onGround || this.level.getNearestPlayer(this.x + this.xd, this.y + this.yd, this.z + this.zd, 1.0, false) != null)) {
                this.nextPos = null;
            }
            if (this.nextPos == null || this.nextPos.closerThan((Position)nowPos, 1.0) || this.nextPos.distanceTo(nowPos) > 100.0) {
                this.nextPos = this.findNextPosition().getCenter();
                re = this.nextPos.subtract(nowPos).multiply(0.02, 0.02, 0.02);
                this.xd = re.x;
                this.yd = re.y;
                this.zd = re.z;
            } else {
                re = this.nextPos.subtract(nowPos).multiply(0.02, 0.02, 0.02);
                this.xd = 0.78 * this.xd + 0.3 * Math.abs(this.random.nextGaussian()) * re.x;
                this.yd = 0.8 * this.yd + 0.25 * Math.abs(this.random.nextGaussian()) * re.y;
                this.zd = 0.78 * this.zd + 0.3 * Math.abs(this.random.nextGaussian()) * re.z;
            }
            BlockPos pos = BlockPos.containing((double)this.x, (double)(this.y - (double)0.1f), (double)this.z);
            if (!NaturalSpawner.isValidEmptySpawnBlock((BlockGetter)this.level, (BlockPos)pos, (BlockState)this.level.getBlockState(pos), (FluidState)this.level.getFluidState(pos), (EntityType)EntityType.BAT)) {
                this.yd = 0.05f;
            }
            this.move(this.xd, this.yd, this.zd);
        }
    }

    protected BlockPos findNextPosition() {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(this.x, this.y, this.z);
        do {
            double i = this.x + this.random.nextGaussian() * 4.0;
            double j = this.y + this.random.nextGaussian() * 2.0;
            double k = this.z + this.random.nextGaussian() * 4.0;
            blockpos$mutableblockpos.set(i, j, k);
        } while (!NaturalSpawner.isValidEmptySpawnBlock((BlockGetter)this.level, (BlockPos)blockpos$mutableblockpos, (BlockState)this.level.getBlockState((BlockPos)blockpos$mutableblockpos), (FluidState)this.level.getFluidState((BlockPos)blockpos$mutableblockpos), (EntityType)EntityType.BAT));
        return blockpos$mutableblockpos;
    }
}

