/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.particle;

import com.mojang.datafixers.util.Pair;
import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.EclipticSeasonsApi;
import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.constant.tag.EclipticBlockTags;
import com.teamtea.eclipticseasons.api.data.client.ColorMode;
import com.teamtea.eclipticseasons.api.data.client.LeafColor;
import com.teamtea.eclipticseasons.client.particle.FallenLeavesParticle;
import com.teamtea.eclipticseasons.client.util.ClientCon;
import com.teamtea.eclipticseasons.client.util.ClientRef;
import com.teamtea.eclipticseasons.client.util.ColorHelper;
import com.teamtea.eclipticseasons.common.core.map.SnowyRemover;
import com.teamtea.eclipticseasons.common.registry.AttachmentRegistry;
import com.teamtea.eclipticseasons.common.registry.ItemRegistry;
import com.teamtea.eclipticseasons.common.registry.ParticleRegistry;
import com.teamtea.eclipticseasons.config.ClientConfig;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.TestOnly;

public class ParticleUtil {
    private static Holder<Biome> nowBiome = null;
    private static final Map<BlockState, Pair<Color, Integer>> LEAVES_COLOR_MAP = new IdentityHashMap<BlockState, Pair<Color, Integer>>();

    public static void createParticle(ClientLevel clientLevel, int x, int y, int z) {
        if (!((Boolean)ClientConfig.Particle.seasonParticle.get()).booleanValue()) {
            return;
        }
    }

    public static void doAnimateTick(ClientLevel clientLevel, int x, int y, int z, int b, RandomSource random, BlockPos.MutableBlockPos blockpos$mutableblockpos) {
        int i = x + random.nextInt(b) - random.nextInt(b);
        int j = y + random.nextInt(b) - random.nextInt(b);
        int k = z + random.nextInt(b) - random.nextInt(b);
        blockpos$mutableblockpos.set(i, j, k);
        BlockState blockstate = clientLevel.getBlockState((BlockPos)blockpos$mutableblockpos);
        ParticleUtil.doAnimateTick(clientLevel, x, y, z, b, random, blockpos$mutableblockpos, blockstate);
    }

    public static boolean doAnimateTick(ClientLevel clientLevel, int x, int y, int z, int b, RandomSource random, BlockPos.MutableBlockPos blockpos$mutableblockpos, BlockState blockstate) {
        SnowyRemover data;
        SnowyRemover.SnowyFlag snowyFlag;
        ParticleOptions indicatorParticleOptions;
        Season sd;
        List<Pair<LeafColor.InstanceHolder, LeafColor.Instance>> pairs;
        if (!((Boolean)ClientConfig.Particle.seasonParticle.get()).booleanValue()) {
            return false;
        }
        int i = blockpos$mutableblockpos.getX();
        int j = blockpos$mutableblockpos.getY();
        int k = blockpos$mutableblockpos.getZ();
        Block block = blockstate.getBlock();
        boolean replace = false;
        boolean isLeaf = false;
        List<Pair<LeafColor.InstanceHolder, LeafColor.Instance>> list = pairs = !blockstate.isAir() ? null : ClientRef.leaveColors.get(block);
        if (pairs != null) {
            for (Pair<LeafColor.InstanceHolder, LeafColor.Instance> pair : pairs) {
                if (!((LeafColor.InstanceHolder)pair.getFirst()).matches((Level)clientLevel, i, j, k, random, blockstate)) continue;
                isLeaf = true;
                LeafColor.Instance second = (LeafColor.Instance)pair.getSecond();
                Integer chanceW = null;
                if (second.weights().contains(ClientCon.nowSolarTerm)) {
                    chanceW = second.weights().get(ClientCon.nowSolarTerm);
                } else {
                    switch (ClientCon.nowSolarTerm.getSeason()) {
                        case SPRING: {
                            chanceW = 17;
                            break;
                        }
                        case SUMMER: {
                            chanceW = 27;
                            break;
                        }
                        case AUTUMN: {
                            chanceW = 9;
                            break;
                        }
                        case WINTER: {
                            chanceW = 15;
                        }
                    }
                }
                if (second.sprites().get(ClientCon.nowSolarTerm) == null) break;
                if (chanceW != null && random.nextInt((chanceW = Integer.valueOf(chanceW * (int)((float)((Integer)ClientConfig.Particle.fallenLeavesDropWeight.get()).intValue() * 0.4f))).intValue()) == 0) {
                    ParticleUtil.fallenLeaves(clientLevel, (BlockPos)blockpos$mutableblockpos, random, blockstate, second);
                }
                replace = second.replace();
                break;
            }
        }
        if (!isLeaf && ((Boolean)ClientConfig.Particle.fallenLeaves.get()).booleanValue() && block instanceof LeavesBlock && !blockstate.is(EclipticBlockTags.NONE_FALLEN_LEAVES) && (sd = ClientCon.nowSolarTerm.getSeason()) != Season.NONE) {
            int chanceW = 19;
            switch (sd) {
                case SPRING: {
                    chanceW = 17;
                    break;
                }
                case SUMMER: {
                    chanceW = 27;
                    break;
                }
                case AUTUMN: {
                    chanceW = 9;
                    break;
                }
                case WINTER: {
                    chanceW = 15;
                }
            }
            if (random.nextInt(chanceW *= (int)((float)((Integer)ClientConfig.Particle.fallenLeavesDropWeight.get()).intValue() * 0.4f)) == 0) {
                ParticleUtil.fallenLeaves(clientLevel, (BlockPos)blockpos$mutableblockpos, random, blockstate, null);
            }
        }
        if (((Boolean)ClientConfig.Particle.butterfly.get()).booleanValue() && ClientCon.nowSolarTerm.getSeason() == Season.SPRING && ClientCon.isDay && !blockstate.isAir() && blockstate.is(EclipticBlockTags.HABITAT_BUTTERFLY) && !EclipticSeasonsApi.getInstance().isRainOrSnowAt((Level)clientLevel, (BlockPos)blockpos$mutableblockpos) && clientLevel.canSeeSky((BlockPos)blockpos$mutableblockpos) && random.nextInt((int)(1024.0f * ((float)((Integer)ClientConfig.Particle.butterflySpawnWeight.get()).intValue() * 0.1f))) == 0) {
            clientLevel.addParticle((ParticleOptions)ParticleRegistry.BUTTERFLY, false, (double)i + 0.5, (double)j + 0.8, (double)k + 0.5, 0.0, 5.0E-4, 0.0);
        }
        if (((Boolean)ClientConfig.Particle.firefly.get()).booleanValue() && ClientCon.nowSolarTerm.getSeason() == Season.SUMMER && ClientCon.isEvening && !blockstate.isAir() && blockstate.is(EclipticBlockTags.HABITAT_FIREFLY) && !EclipticSeasonsApi.getInstance().isRainOrSnowAt((Level)clientLevel, (BlockPos)blockpos$mutableblockpos) && clientLevel.canSeeSky((BlockPos)blockpos$mutableblockpos) && random.nextInt((int)(160.0f * ((float)((Integer)ClientConfig.Particle.fireflySpawnWeight.get()).intValue() * 0.1f))) == 0) {
            clientLevel.addParticle((ParticleOptions)ParticleRegistry.FIREFLY, false, (double)i + 0.5, (double)j + 0.8, (double)k + 0.5, 0.0, 5.0E-4, 0.0);
        }
        if (((Boolean)ClientConfig.Particle.wildGoose.get()).booleanValue() && ClientCon.nowSolarTerm.getSeason() == Season.AUTUMN && ClientCon.isNoon && clientLevel.canSeeSky((BlockPos)blockpos$mutableblockpos) && clientLevel.isEmptyBlock((BlockPos)blockpos$mutableblockpos) && !EclipticSeasonsApi.getInstance().isRainAt((Level)clientLevel, (BlockPos)blockpos$mutableblockpos) && ((Biome)clientLevel.getBiome((BlockPos)blockpos$mutableblockpos).value()).getBaseTemperature() < 0.95f && random.nextInt((int)(2295.0f * ((float)((Integer)ClientConfig.Particle.wildGooseSpawnWeight.get()).intValue() * 0.1f))) == 0) {
            clientLevel.addParticle((ParticleOptions)ParticleRegistry.WILD_GOOSE, false, (double)(x + random.nextInt(16, 32) * (random.nextBoolean() ? -1 : 1)), (double)(y + random.nextInt(15, 32)), (double)(z + random.nextInt(16, 32) * (random.nextBoolean() ? -1 : 1)), 0.0, 5.0E-4, 0.0);
        }
        if (random.nextInt(b) == 0 && Minecraft.getInstance().player != null && Minecraft.getInstance().player.getItemInHand(InteractionHand.MAIN_HAND).getItem() == ItemRegistry.ice_wand.get() && (indicatorParticleOptions = (snowyFlag = (data = (SnowyRemover)clientLevel.getChunkAt((BlockPos)blockpos$mutableblockpos).getData(AttachmentRegistry.SNOWY_REMOVER)).getSnowyFlag((BlockPos)blockpos$mutableblockpos)).getIndicatorParticleOptions(random)) != null) {
            j = clientLevel.getHeight(Heightmap.Types.MOTION_BLOCKING, i, k);
            clientLevel.addParticle(indicatorParticleOptions, false, (double)i + 0.5, (double)j + 0.3, (double)k + 0.5, 0.0, -1.0E-4, 0.0);
        }
        return replace;
    }

    public static void fallenLeaves(ClientLevel level, BlockPos pos, RandomSource random, BlockState state, LeafColor.Instance leafInfo) {
        if (!state.isAir()) {
            int color = -1;
            if (leafInfo == null) {
                int blockColor;
                pair = ParticleUtil.getOrCreateColor(state);
                color = ((Color)pair.getFirst()).getRGB();
                if ((Integer)pair.getSecond() != -1 && (blockColor = Minecraft.getInstance().getBlockColors().getColor(state, (BlockAndTintGetter)level, pos, ((Integer)pair.getSecond()).intValue())) != -1) {
                    int n = color = color == -1 ? blockColor : ColorHelper.simplyMixColor(color, 0.25f, blockColor, 0.75f);
                }
                if (color == -1) {
                    color = state.getMapColor((BlockGetter)level, (BlockPos)pos).col;
                }
            } else {
                color = switch (leafInfo.colorSource()) {
                    default -> throw new MatchException(null, null);
                    case LeafColor.ColorSource.MAP -> state.getMapColor((BlockGetter)level, (BlockPos)pos).col;
                    case LeafColor.ColorSource.BLOCK -> Minecraft.getInstance().getBlockColors().getColor(state, (BlockAndTintGetter)level, pos, 0);
                    case LeafColor.ColorSource.TEXTURE -> {
                        int color2;
                        pair = ParticleUtil.getOrCreateColor(state);
                        int textureColor = ((Color)pair.getFirst()).getRGB();
                        if ((Integer)pair.getSecond() != -1 && (color2 = Minecraft.getInstance().getBlockColors().getColor(state, (BlockAndTintGetter)level, pos, 0)) != -1) {
                            textureColor = textureColor == -1 ? color2 : ColorHelper.simplyMixColor(textureColor, 0.25f, color2, 0.75f);
                        }
                        yield textureColor;
                    }
                    case LeafColor.ColorSource.CUSTOM -> {
                        ColorMode.Instance orDefault1 = leafInfo.colors().getOrDefault(ClientCon.nowSolarTerm, null);
                        if (orDefault1 != null) {
                            yield orDefault1.value();
                        }
                        yield -1;
                    }
                };
            }
            VoxelShape voxelshape = state.getShape((BlockGetter)level, pos);
            double d0 = 0.25;
            int finalColor = color;
            int finalColor1 = color;
            voxelshape.forAllBoxes((x0, y0, z0, x1, y1, z1) -> {
                double x = Math.min(1.0, x1 - x0);
                double y = Math.min(1.0, y1 - y0);
                double z = Math.min(1.0, z1 - z0);
                int aX = Math.min(1, Mth.ceil((double)(x / 0.25)));
                int aY = Math.min(1, Mth.ceil((double)(y / 0.25)));
                int aZ = Math.min(1, Mth.ceil((double)(z / 0.25)));
                for (int pX = 0; pX < aX; ++pX) {
                    for (int pY = -aY; pY < 0; ++pY) {
                        for (int pZ = 0; pZ < aZ; ++pZ) {
                            double d4 = ((double)pX + 0.5) / (double)aX;
                            double d5 = ((double)pY + 0.5) / (double)aY;
                            double d6 = ((double)pZ + 0.5) / (double)aZ;
                            double d7 = d4 * x + x0;
                            double d8 = d5 * y + y0;
                            double d9 = d6 * z + z0;
                            if (d5 > (double)0.49f) {
                                d5 = 0.42f;
                            }
                            if (leafInfo == null || leafInfo.sprites().getOrDefault(ClientCon.nowSolarTerm, null) == null) {
                                level.addParticle((ParticleOptions)ColorParticleOption.create(ParticleRegistry.FALLEN_LEAVES, (int)finalColor), (double)pos.getX() + d7, (double)pos.getY() + d8, (double)pos.getZ() + d9, Mth.clamp((double)(d4 - 0.5), (double)-0.25, (double)0.25), (d5 - 0.5) * 0.75, Mth.clamp((double)(d6 - 0.5), (double)-0.25, (double)0.25));
                                continue;
                            }
                            List<ResourceLocation> resourceLocations = leafInfo.sprites().get(ClientCon.nowSolarTerm);
                            if (resourceLocations.isEmpty()) continue;
                            TextureAtlas textureAtlas = (TextureAtlas)Minecraft.getInstance().getTextureManager().getTexture(TextureAtlas.LOCATION_PARTICLES);
                            ResourceLocation resourceLocation = resourceLocations.get(random.nextInt(resourceLocations.size()));
                            Minecraft.getInstance().particleEngine.add((Particle)new FallenLeavesParticle(level, (double)pos.getX() + d7, (double)pos.getY() + d8, (double)pos.getZ() + d9, Mth.clamp((double)(d4 - 0.5), (double)-0.25, (double)0.25), (d5 - 0.5) * 0.75, Mth.clamp((double)(d6 - 0.5), (double)-0.25, (double)0.25), ColorParticleOption.create(ParticleRegistry.FALLEN_LEAVES, (int)finalColor1), textureAtlas.getSprite(resourceLocation)));
                        }
                    }
                }
            });
        }
    }

    public static void onReloadResource() {
        LEAVES_COLOR_MAP.clear();
    }

    public static Pair<Color, Integer> getOrCreateColor(BlockState state) {
        Minecraft mc = Minecraft.getInstance();
        Color c = Color.WHITE;
        try {
            Pair orDefault = LEAVES_COLOR_MAP.getOrDefault(state, null);
            if (orDefault != null) {
                // empty if block
            }
            BakedModel blockModel = mc.getBlockRenderer().getBlockModel(state);
            int tintIndex = -1;
            block2: for (Direction direction : new Direction[]{Direction.UP, Direction.DOWN, Direction.SOUTH, Direction.EAST, Direction.NORTH, Direction.WEST, null}) {
                List quads = blockModel.getQuads(state, direction, mc.level.getRandom(), ModelData.EMPTY, ItemBlockRenderTypes.getChunkRenderType((BlockState)state));
                for (BakedQuad quad : quads) {
                    if (quad.getTintIndex() == -1) continue;
                    tintIndex = quad.getTintIndex();
                    continue block2;
                }
            }
            TextureAtlasSprite texture = blockModel.getParticleIcon(ModelData.EMPTY);
            ArrayList<Integer> rlist = new ArrayList<Integer>();
            ArrayList<Integer> glist = new ArrayList<Integer>();
            ArrayList<Integer> blist = new ArrayList<Integer>();
            for (int i = 0; i < texture.contents().width(); ++i) {
                for (int j = 0; j < texture.contents().height(); ++j) {
                    int b;
                    int g;
                    int color = 0xFF000000 | texture.getPixelRGBA(0, i, j);
                    int r = color & 0xFF;
                    if (r * (g = color >> 8 & 0xFF) * (b = color >> 16 & 0xFF) <= 0) continue;
                    rlist.add(r);
                    glist.add(g);
                    blist.add(b);
                }
            }
            c = new Color((int)ColorHelper.getAvg(rlist), (int)ColorHelper.getAvg(glist), (int)ColorHelper.getAvg(blist));
            Pair colorIntegerPair = Pair.of((Object)c, (Object)tintIndex);
            LEAVES_COLOR_MAP.put(state, (Pair<Color, Integer>)colorIntegerPair);
            return colorIntegerPair;
        }
        catch (Exception exception) {
            EclipticSeasons.logger(exception);
            return Pair.of((Object)c, (Object)-1);
        }
    }

    @TestOnly
    private static Color getColorFromSpriteResource(TextureAtlasSprite texture) throws IOException {
        Optional resource = Minecraft.getInstance().getResourceManager().getResource(texture.contents().name().withPrefix("textures/").withSuffix(".png"));
        Color c = Color.WHITE;
        if (resource.isPresent()) {
            BufferedImage image = ImageIO.read(((Resource)resource.get()).open());
            ArrayList<Integer> rlist = new ArrayList<Integer>();
            ArrayList<Integer> glist = new ArrayList<Integer>();
            ArrayList<Integer> blist = new ArrayList<Integer>();
            for (int i = 0; i < image.getWidth(); ++i) {
                for (int j = 0; j < image.getHeight(); ++j) {
                    int b;
                    int g;
                    int color = 0xFF000000 | image.getRGB(i, j);
                    int r = color >> 16 & 0xFF;
                    if (r * (g = color >> 8 & 0xFF) * (b = color & 0xFF) <= 0) continue;
                    rlist.add(r);
                    glist.add(g);
                    blist.add(b);
                }
            }
            c = new Color((int)ColorHelper.getAvg(rlist), (int)ColorHelper.getAvg(glist), (int)ColorHelper.getAvg(blist));
        }
        return c;
    }
}

