/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.reload;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.data.client.BiomeColor;
import com.teamtea.eclipticseasons.api.data.client.LeafColor;
import com.teamtea.eclipticseasons.api.data.client.SeasonalBiomeAmbient;
import com.teamtea.eclipticseasons.api.data.client.model.ESModelLoadedJson;
import com.teamtea.eclipticseasons.api.data.client.model.seasonal.SeasonBlockDefinition;
import com.teamtea.eclipticseasons.api.data.client.model.seasonal.SeasonalTexture;
import com.teamtea.eclipticseasons.api.data.season.SnowDefinition;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class ClientJsonCacheListener<T>
extends SimpleJsonResourceReloadListener {
    private final Map<ResourceLocation, JsonElement> elementMap = new HashMap<ResourceLocation, JsonElement>();
    private static final Gson GSON = new GsonBuilder().setLenient().create();
    public static final String DIRECTORY_TEST = "eclipticseasons/test";
    public static final String DIRECTORY_BIOME = "eclipticseasons/biome_colors";
    public static final String DIRECTORY_LEAF = "eclipticseasons/particles/fallen_leaves";
    public static final String DIRECTORY_SNOW_DEFINITION = "eclipticseasons/snow_definitions";
    public static final String DIRECTORY_AMBIENT = "eclipticseasons/ambient";
    public static final String DIRECTORY_MODEL_DEFINITION = "eclipticseasons/model_definitions";
    public static final String DIRECTORY_SEASON_DEFINITION = "eclipticseasons/season_definitions";
    public static final String DIRECTORY_SEASON_TEXTURES = "eclipticseasons/season_textures";
    public static final ClientJsonCacheListener<ESModelLoadedJson> modelDefCache = new ClientJsonCacheListener(GSON, "eclipticseasons/model_definitions");
    public static final ClientJsonCacheListener<SeasonalTexture> textureReMappingsCache = new ClientJsonCacheListener(GSON, "eclipticseasons/season_textures");
    public static final ClientJsonCacheListener<BiomeColor> biomeCache = new ClientJsonCacheListener(GSON, "eclipticseasons/biome_colors");
    public static final ClientJsonCacheListener<LeafColor> leafCache = new ClientJsonCacheListener(GSON, "eclipticseasons/particles/fallen_leaves");
    public static final ClientJsonCacheListener<SnowDefinition> snowDefOverrideCache = new ClientJsonCacheListener(GSON, "eclipticseasons/snow_definitions");
    public static final ClientJsonCacheListener<SeasonalBiomeAmbient> ambientCache = new ClientJsonCacheListener(GSON, "eclipticseasons/ambient");
    public static final ClientJsonCacheListener<SeasonBlockDefinition> seasonDefCache = new ClientJsonCacheListener(GSON, "eclipticseasons/season_definitions");
    private final String directory;

    public ClientJsonCacheListener(Gson gson, String directory) {
        super(gson, directory);
        this.directory = directory;
    }

    protected Map<ResourceLocation, JsonElement> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        Map prepare = super.prepare(resourceManager, profiler);
        this.elementMap.clear();
        this.elementMap.putAll(prepare);
        return prepare;
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
    }

    public CompletableFuture<Map<ResourceLocation, JsonElement>> prepareAsync(ResourceManager resourceManager, ProfilerFiller profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            ConcurrentHashMap<ResourceLocation, JsonElement> prepare = new ConcurrentHashMap<ResourceLocation, JsonElement>();
            ClientJsonCacheListener.scanDirectoryAsync(resourceManager, this.directory, GSON, prepare, executor).join();
            this.elementMap.clear();
            this.elementMap.putAll(prepare);
            return prepare;
        }, executor);
    }

    public static CompletableFuture<Void> scanDirectoryAsync(ResourceManager resourceManager, String name, Gson gson, ConcurrentMap<ResourceLocation, JsonElement> output, Executor executor) {
        FileToIdConverter fileToIdConverter = FileToIdConverter.json((String)name);
        Map matching = fileToIdConverter.listMatchingResources(resourceManager);
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (Map.Entry entry : matching.entrySet()) {
            ResourceLocation file = (ResourceLocation)entry.getKey();
            ResourceLocation id = fileToIdConverter.fileToId(file);
            Resource resource = (Resource)entry.getValue();
            CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                try (BufferedReader reader = resource.openAsReader();){
                    JsonElement element = (JsonElement)GsonHelper.fromJson((Gson)gson, (Reader)reader, JsonElement.class);
                    JsonElement previous = output.putIfAbsent(id, element);
                    if (previous != null) {
                        throw new IllegalStateException("Duplicate data file ignored with ID " + String.valueOf(id));
                    }
                }
                catch (JsonParseException | IOException | IllegalArgumentException e) {
                    EclipticSeasons.LOGGER.error("Couldn't parse data file {} from {}", (Object)id, (Object)file, (Object)e);
                }
            }, executor);
            futures.add(future);
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    public Map<ResourceLocation, JsonElement> getElementMap() {
        return this.elementMap;
    }

    public Map<ResourceLocation, T> build(Codec<T> codec, RegistryAccess registryAccess) {
        return this.getResourceLocationTMap(codec, (DynamicOps<JsonElement>)registryAccess.createSerializationContext((DynamicOps)JsonOps.INSTANCE));
    }

    public Map<ResourceLocation, T> build(Codec<T> codec) {
        JsonOps dynamicops = JsonOps.INSTANCE;
        return this.getResourceLocationTMap(codec, (DynamicOps<JsonElement>)dynamicops);
    }

    @NotNull
    private Map<ResourceLocation, T> getResourceLocationTMap(Codec<T> codec, DynamicOps<JsonElement> dynamicops) {
        HashMap map = new HashMap();
        this.elementMap.forEach((resourceLocation, jsonElement) -> {
            try {
                codec.parse(dynamicops, jsonElement).resultOrPartial(x -> {
                    String formatted = "Unable to load %s: '%s' due to: %s".formatted(this.getName().replace("eclipticseasons/", ""), resourceLocation, x);
                    EclipticSeasons.LOGGER.warn(formatted);
                }).ifPresent(t -> map.put(resourceLocation, t));
            }
            catch (Exception e) {
                String formatted = "Unable to load %s with exception: '%s' due to: %s".formatted(this.getName().replace("eclipticseasons/", ""), resourceLocation, e);
                EclipticSeasons.LOGGER.warn(formatted);
            }
        });
        return map;
    }

    @NotNull
    public String getName() {
        return this.directory;
    }
}

