/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.render.ber;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.data.quest.SeasonQuest;
import com.teamtea.eclipticseasons.common.block.blockentity.QuestHangingSignBlockEntity;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.Vec3;

public class QuestSignRenderer
extends HangingSignRenderer {
    private final Map<WoodType, HangingSignRenderer.HangingSignModel> hangingSignModels = (Map)WoodType.values().collect(ImmutableMap.toImmutableMap(p_249901_ -> p_249901_, p_251956_ -> new HangingSignRenderer.HangingSignModel(context.bakeLayer(ModelLayers.createHangingSignModelName((WoodType)p_251956_)))));
    private static final Vec3 TEXT_OFFSET = new Vec3(0.0, (double)-0.32f, (double)0.073f);
    private static final int OUTLINE_RENDER_DISTANCE = Mth.square((int)16);
    private final Font font;
    private final Material materail;

    public QuestSignRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        this.font = context.getFont();
        this.materail = QuestSignRenderer.createHangingSignMaterial(EclipticSeasons.rl("frame"));
    }

    public void render(SignBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (blockEntity instanceof QuestHangingSignBlockEntity) {
            QuestHangingSignBlockEntity questHangingSignBlockEntity = (QuestHangingSignBlockEntity)blockEntity;
            BlockState blockstate = blockEntity.getBlockState();
            SignBlock signblock = (SignBlock)blockstate.getBlock();
            WoodType woodtype = questHangingSignBlockEntity.getSignType().type();
            HangingSignRenderer.HangingSignModel hangingsignrenderer$hangingsignmodel = this.hangingSignModels.get(woodtype);
            hangingsignrenderer$hangingsignmodel.evaluateVisibleParts(blockstate);
            this.renderSignWithText(questHangingSignBlockEntity, poseStack, bufferSource, packedLight, packedOverlay, blockstate, signblock, woodtype, (Model)hangingsignrenderer$hangingsignmodel);
        }
    }

    void renderSignWithText(QuestHangingSignBlockEntity signEntity, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, BlockState state, SignBlock signBlock, WoodType woodType, Model model) {
        poseStack.pushPose();
        this.translateSign(poseStack, -signBlock.getYRotationDegrees(state), state);
        this.renderSign(poseStack, buffer, packedLight, packedOverlay, woodType, model);
        this.renderSignText(signEntity.getBlockPos(), signEntity.getFrontText(), poseStack, buffer, packedLight, signEntity.getTextLineHeight(), signEntity.getMaxTextLineWidth(), true, signEntity.getSeasonQuest());
        this.renderSignDecoration(poseStack, buffer, packedLight, packedOverlay, woodType, model);
        poseStack.popPose();
    }

    void translateSign(PoseStack poseStack, float yRot, BlockState state) {
        poseStack.translate(0.5, 0.9375, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(yRot));
        poseStack.translate(0.0f, -0.3125f, 0.0f);
    }

    void renderSign(PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, WoodType woodType, Model model) {
        poseStack.pushPose();
        float f = this.getSignModelRenderScale();
        poseStack.scale(f, -f, -f);
        Material material = this.getSignMaterial(woodType);
        VertexConsumer vertexconsumer = material.buffer(buffer, arg_0 -> ((Model)model).renderType(arg_0));
        this.renderSignModel(poseStack, packedLight, packedOverlay, model, vertexconsumer);
        poseStack.popPose();
    }

    void renderSignDecoration(PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, WoodType woodType, Model model) {
        poseStack.pushPose();
        float f = this.getSignModelRenderScale();
        poseStack.scale(f, -f, -f);
        VertexConsumer vertexconsumer = this.materail.buffer(buffer, arg_0 -> ((Model)model).renderType(arg_0));
        this.renderSignModel(poseStack, LightTexture.pack((int)8, (int)15), packedOverlay, model, vertexconsumer);
        poseStack.popPose();
    }

    void renderSignModel(PoseStack poseStack, int packedLight, int packedOverlay, Model model, VertexConsumer vertexConsumer) {
        HangingSignRenderer.HangingSignModel hangingsignrenderer$hangingsignmodel = (HangingSignRenderer.HangingSignModel)model;
        hangingsignrenderer$hangingsignmodel.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    Material getSignMaterial(WoodType woodType) {
        return Sheets.getHangingSignMaterial((WoodType)woodType);
    }

    Vec3 getTextOffset() {
        return TEXT_OFFSET;
    }

    void renderSignText(BlockPos pos, SignText text, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int lineHeight, int maxWidth, boolean isFrontText, SeasonQuest seasonQuest) {
        int l;
        boolean flag;
        int k;
        poseStack.pushPose();
        this.translateSignText(poseStack, isFrontText, this.getTextOffset());
        boolean b = text.hasGlowingText();
        b = seasonQuest != null && seasonQuest.glowing().isPresent();
        int textColor = text.getColor().getTextColor();
        textColor = seasonQuest != null && seasonQuest.color().isPresent() ? seasonQuest.color().get().intValue() : Color.WHITE.getRGB();
        int i = QuestSignRenderer.getDarkColor(textColor, b);
        int j = 4 * lineHeight / 2;
        FormattedCharSequence[] aformattedcharsequence = text.getRenderMessages(Minecraft.getInstance().isTextFilteringEnabled(), component -> {
            List list = this.font.split((FormattedText)component, maxWidth);
            return list.isEmpty() ? FormattedCharSequence.EMPTY : (FormattedCharSequence)list.get(0);
        });
        if (b) {
            k = Color.WHITE.getRGB();
            flag = QuestSignRenderer.isOutlineVisible(pos, k);
            l = 0xF000F0;
        } else {
            k = i;
            flag = false;
            l = packedLight;
        }
        poseStack.scale(0.8f, 0.8f, 0.8f);
        for (int i1 = 0; i1 < 4; ++i1) {
            FormattedCharSequence formattedcharsequence = aformattedcharsequence[i1];
            float f = -this.font.width(formattedcharsequence) / 2;
            poseStack.pushPose();
            float abs = Mth.abs((float)f);
            if (abs > 32.0f) {
                poseStack.scale(32.0f / abs * 0.97f, 1.0f, 1.0f);
            }
            if (flag) {
                this.font.drawInBatch8xOutline(formattedcharsequence, f, (float)(i1 * lineHeight - j), k, i, poseStack.last().pose(), buffer, l);
            } else {
                this.font.drawInBatch(formattedcharsequence, f, (float)(i1 * lineHeight - j), k, false, poseStack.last().pose(), buffer, Font.DisplayMode.POLYGON_OFFSET, 0, l);
            }
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    private void translateSignText(PoseStack poseStack, boolean isFrontText, Vec3 offset) {
        if (!isFrontText) {
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        }
        float f = 0.015625f * this.getSignTextRenderScale();
        poseStack.translate(offset.x, offset.y, offset.z);
        poseStack.scale(f, -f, f);
    }

    static boolean isOutlineVisible(BlockPos pos, int textColor) {
        if (textColor == DyeColor.BLACK.getTextColor()) {
            return true;
        }
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer localplayer = minecraft.player;
        if (localplayer != null && minecraft.options.getCameraType().isFirstPerson() && localplayer.isScoping()) {
            return true;
        }
        Entity entity = minecraft.getCameraEntity();
        return entity != null && entity.distanceToSqr(Vec3.atCenterOf((Vec3i)pos)) < (double)OUTLINE_RENDER_DISTANCE;
    }

    private static Material createHangingSignMaterial(ResourceLocation resourceLocation) {
        return new Material(Sheets.SIGN_SHEET, ResourceLocation.fromNamespaceAndPath((String)resourceLocation.getNamespace(), (String)("entity/signs/hanging/" + resourceLocation.getPath())));
    }

    public static int getDarkColor(int i, boolean hasGlowingText) {
        if (i == DyeColor.BLACK.getTextColor()) {
            return -988212;
        }
        double d0 = 0.4;
        int j = (int)((double)FastColor.ARGB32.red((int)i) * 0.4);
        int k = (int)((double)FastColor.ARGB32.green((int)i) * 0.4);
        int l = (int)((double)FastColor.ARGB32.blue((int)i) * 0.4);
        return FastColor.ARGB32.color((int)0, (int)j, (int)k, (int)l);
    }
}

