/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.render.ber;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.client.render.TryAnimation;
import com.teamtea.eclipticseasons.client.render.TryKeyframe;
import com.teamtea.eclipticseasons.client.render.ber.XYZ;
import com.teamtea.eclipticseasons.common.block.base.SimpleHorizontalEntityBlock;
import com.teamtea.eclipticseasons.common.block.blockentity.WindChimesBlockEntity;
import com.teamtea.eclipticseasons.common.registry.BlockRegistry;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3f;

public class WindChimesRenderer
implements BlockEntityRenderer<WindChimesBlockEntity> {
    public static final Material WINDRING_RESOURCE_LOCATION = new Material(InventoryMenu.BLOCK_ATLAS, EclipticSeasons.rl("block/windring_entity"));
    public static final Material WINDRING_RESOURCE_LOCATION_BAMBOO = new Material(InventoryMenu.BLOCK_ATLAS, EclipticSeasons.rl("block/windring_bamboo_entity"));
    public static final Material WINDRING_RESOURCE_LOCATION_PAPER = new Material(InventoryMenu.BLOCK_ATLAS, EclipticSeasons.rl("block/windring_paper_entity"));
    private ModelPart windringModelPart = WindChimesRenderer.createBodyLayer().bakeRoot();
    private ModelPart windringModelPartPaper = WindChimesRenderer.createBodyLayer_Paper().bakeRoot();
    private ModelPart windringModelPartBamboo = WindChimesRenderer.createBodyLayer_Bamboo().bakeRoot();
    private static final Vector3f ANIMATION_VECTOR_CACHE = new Vector3f();

    public WindChimesRenderer(BlockEntityRendererProvider.Context pContext) {
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition top = partdefinition.addOrReplaceChild("top", CubeListBuilder.create().texOffs(36, 32).addBox(-0.95f, -1.75f, -1.05f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.45f, (float)15.25f, (float)8.45f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        PartDefinition bone = partdefinition.addOrReplaceChild("bone", CubeListBuilder.create().texOffs(36, 0).addBox(-4.4898f, -6.0f, 3.507f, 9.0f, 16.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(36, 16).addBox(-4.4898f, -6.0f, -3.493f, 9.0f, 16.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(0, 10).addBox(3.5102f, -6.0f, -4.493f, 0.0f, 16.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(18, 10).addBox(-3.4898f, -6.0f, -4.493f, 0.0f, 16.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(36, 36).addBox(-0.8898f, 3.0f, -1.093f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-4.6102f, -8.1f, -4.493f, 9.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.5102f, (float)7.0f, (float)8.493f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        PartDefinition cube_r1 = bone.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(18, 35).addBox(2.0f, -11.0f, 1.9f, 0.0f, 16.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0102f, (float)4.0f, (float)-5.993f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition cube_r2 = bone.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 35).addBox(2.0f, -11.0f, 1.9f, 0.0f, 16.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.9898f, (float)4.0f, (float)-2.993f, (float)0.0f, (float)0.7854f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createBodyLayer_Paper() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition bone = partdefinition.addOrReplaceChild("bone", CubeListBuilder.create().texOffs(16, 16).addBox(-1.5f, 14.0f, 0.0f, 3.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(22, 16).addBox(-1.5f, -1.0f, 0.0f, 3.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.0f, (float)15.0f, (float)8.0f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        PartDefinition bone2 = partdefinition.addOrReplaceChild("bone2", CubeListBuilder.create().texOffs(16, 21).addBox(-1.5f, 8.0f, 0.0f, 3.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(0, 16).addBox(-2.0f, 9.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.0f, (float)15.0f, (float)8.0f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        PartDefinition bone3 = partdefinition.addOrReplaceChild("bone3", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.0f, (float)15.0f, (float)8.0f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        PartDefinition top = partdefinition.addOrReplaceChild("top", CubeListBuilder.create().texOffs(22, 16).addBox(-1.5f, -1.0f, 0.0f, 3.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.0f, (float)15.0f, (float)8.0f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public static LayerDefinition createBodyLayer_Bamboo() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition bone = partdefinition.addOrReplaceChild("bone", CubeListBuilder.create().texOffs(20, 10).addBox(0.3666f, 3.0f, -2.2f, 0.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.2667f, (float)7.0f, (float)7.6f, (float)0.0f, (float)-1.5708f, (float)-3.1416f));
        PartDefinition bone2 = partdefinition.addOrReplaceChild("bone2", CubeListBuilder.create().texOffs(0, 10).addBox(-2.2333f, -7.0f, -2.1f, 5.0f, 11.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.2667f, (float)7.0f, (float)7.6f, (float)0.0f, (float)-1.5708f, (float)-3.1416f));
        PartDefinition top = partdefinition.addOrReplaceChild("top", CubeListBuilder.create().texOffs(0, -9).addBox(0.3666f, -11.0f, -6.2f, 0.0f, 8.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.2667f, (float)7.0f, (float)7.6f, (float)0.0f, (float)-1.5708f, (float)-3.1416f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void render(WindChimesBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLight, int combinedOverlay) {
        ModelPart useModel = this.windringModelPart;
        Material material = WINDRING_RESOURCE_LOCATION;
        AnimationDefinition animationDefinition = TryAnimation.animation;
        BlockState blockState = blockEntity.getBlockState();
        Block block = blockState.getBlock();
        float size = 0.075f;
        if (block == BlockRegistry.bamboo_wind_chimes.get()) {
            useModel = this.windringModelPartBamboo;
            material = WINDRING_RESOURCE_LOCATION_BAMBOO;
            size = 0.35f;
            animationDefinition = TryAnimation.animation_bamboo;
        } else if (block == BlockRegistry.paper_wind_chimes.get()) {
            useModel = this.windringModelPartPaper;
            material = WINDRING_RESOURCE_LOCATION_PAPER;
            size = 0.35f;
            animationDefinition = TryAnimation.animation_paper;
        }
        if (blockEntity.isShaking()) {
            size += 0.75f;
        }
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.0f, 0.5f);
        poseStack.mulPose(XYZ.deg_to_rad(0, SimpleHorizontalEntityBlock.getRotateYByFacing(blockEntity.getBlockState()), 0));
        poseStack.translate(-0.5f, 0.0f, -0.5f);
        useModel.getAllParts().forEach(ModelPart::resetPose);
        long seed = blockState.getSeed(blockEntity.getBlockPos());
        long time = (blockEntity.getLevel().getGameTime() + Math.abs(seed)) % 50L;
        if (time == 0L && blockEntity.isShaking()) {
            if (blockEntity.getLevel().getRandom().nextBoolean()) {
                blockEntity.setShaking(false);
            } else {
                size -= 0.5f;
            }
        }
        long renderTicks = (long)(((float)time + partialTicks) * 40.0f);
        TryKeyframe.animate(useModel, animationDefinition, renderTicks, size += 0.001f * (float)(seed % 50L), ANIMATION_VECTOR_CACHE);
        VertexConsumer vertexconsumer = material.buffer(bufferIn, RenderType::entityCutout);
        useModel.render(poseStack, vertexconsumer, combinedLight, combinedOverlay);
        poseStack.popPose();
    }
}

