/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.sound;

import com.teamtea.eclipticseasons.client.util.ClientCon;
import com.teamtea.eclipticseasons.common.block.blockentity.WindChimesBlockEntity;
import java.lang.ref.WeakReference;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;

public class WindChimeSoundInstance
extends AbstractTickableSoundInstance {
    private final WeakReference<WindChimesBlockEntity> windChimes;
    private static final float VOLUME_MIN = 0.0f;
    private static final float VOLUME_MAX = 1.2f;
    private static final float PITCH_MIN = 0.0f;

    public WindChimeSoundInstance(WindChimesBlockEntity windChimes, SoundEvent soundEvent, SoundSource source, RandomSource random) {
        super(soundEvent, source, random);
        this.windChimes = new WeakReference<WindChimesBlockEntity>(windChimes);
        this.x = windChimes.getBlockPos().getX();
        this.y = windChimes.getBlockPos().getY();
        this.z = windChimes.getBlockPos().getZ();
        this.looping = true;
        this.delay = 0;
        this.volume = 0.0f;
        this.relative = true;
    }

    public void tick() {
        WindChimesBlockEntity windChimesBlockEntity;
        Object t = this.windChimes.get();
        if (t instanceof WindChimesBlockEntity && !(windChimesBlockEntity = (WindChimesBlockEntity)((Object)t)).isRemoved()) {
            float f;
            float f2 = f = windChimesBlockEntity.isShaking() ? 0.7f : 0.1f;
            if (this.isRelative() && ClientCon.agent.getCameraEntity() != null) {
                double maxDistanceSq;
                Vec3 soundPos;
                Vec3 cameraPos = ClientCon.agent.getCameraEntity().getPosition(1.0f);
                double distanceSq = cameraPos.distanceToSqr(soundPos = windChimesBlockEntity.getBlockPos().getCenter());
                f = distanceSq > (maxDistanceSq = (double)(4096.0f * f)) && maxDistanceSq > 0.0 ? (f *= 0.0f) : (f *= 1.0f - (float)(distanceSq / maxDistanceSq));
            }
            if (f >= 0.001f) {
                this.pitch = Mth.lerp((float)Mth.clamp((float)f, (float)this.getMinPitch(), (float)this.getMaxPitch()), (float)this.getMinPitch(), (float)this.getMaxPitch());
                this.volume = Mth.lerp((float)Mth.clamp((float)f, (float)0.0f, (float)0.5f), (float)0.0f, (float)1.2f);
            } else {
                this.pitch = 0.0f;
                this.volume = 0.0f;
            }
        } else {
            this.stop();
        }
    }

    private float getMinPitch() {
        return 0.2f;
    }

    private float getMaxPitch() {
        return 1.1f;
    }

    public boolean canStartSilent() {
        return true;
    }
}

