/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common;

import com.teamtea.eclipticseasons.api.data.misc.ESSortInfo;
import com.teamtea.eclipticseasons.api.event.CanPlantGrowEvent;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.common.core.SolarHolders;
import com.teamtea.eclipticseasons.common.core.biome.BiomeClimateManager;
import com.teamtea.eclipticseasons.common.core.biome.WeatherManager;
import com.teamtea.eclipticseasons.common.core.crop.CropGrowthHandler;
import com.teamtea.eclipticseasons.common.core.crop.CropInfoManager;
import com.teamtea.eclipticseasons.common.core.crop.NaturalPlantHandler;
import com.teamtea.eclipticseasons.common.core.map.BiomeHolder;
import com.teamtea.eclipticseasons.common.core.map.ChunkInfoMap;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import com.teamtea.eclipticseasons.common.core.snow.SnowChecker;
import com.teamtea.eclipticseasons.common.core.snow.SnowyMapChecker;
import com.teamtea.eclipticseasons.common.core.solar.SolarDataManager;
import com.teamtea.eclipticseasons.common.network.SimpleNetworkHandler;
import com.teamtea.eclipticseasons.common.network.message.HumidModifyMessage;
import com.teamtea.eclipticseasons.common.registry.ModAdvancements;
import com.teamtea.eclipticseasons.config.CommonConfig;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.entity.player.BonemealEvent;
import net.neoforged.neoforge.event.entity.player.CanContinueSleepingEvent;
import net.neoforged.neoforge.event.entity.player.CanPlayerSleepEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.BlockGrowFeatureEvent;
import net.neoforged.neoforge.event.level.ChunkDataEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.level.ChunkWatchEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.level.SleepFinishedTimeEvent;
import net.neoforged.neoforge.event.level.block.CropGrowEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="eclipticseasons")
public class AllListener {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onTagsUpdatedEventEarly(TagsUpdatedEvent tagsUpdatedEvent) {
        ESSortInfo.resetUpdate(tagsUpdatedEvent.getRegistryAccess(), tagsUpdatedEvent.getUpdateCause() == TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD);
        BiomeClimateManager.resetBiomeTags(tagsUpdatedEvent.getRegistryAccess(), tagsUpdatedEvent.getUpdateCause() == TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD);
    }

    @SubscribeEvent
    public static void onTagsUpdatedEvent(TagsUpdatedEvent tagsUpdatedEvent) {
        BiomeClimateManager.resetBiomeTemps(tagsUpdatedEvent.getRegistryAccess(), tagsUpdatedEvent.getUpdateCause() == TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD);
        WeatherManager.informUpdateBiomes(tagsUpdatedEvent.getRegistryAccess(), tagsUpdatedEvent.getUpdateCause() == TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD);
        CropInfoManager.init(tagsUpdatedEvent);
        CropGrowthHandler.resetUpdate(tagsUpdatedEvent.getRegistryAccess(), tagsUpdatedEvent.getUpdateCause() == TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD);
        NaturalPlantHandler.resetUpdate(tagsUpdatedEvent.getRegistryAccess(), tagsUpdatedEvent.getUpdateCause() == TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD);
        SnowChecker.resetUpdate(tagsUpdatedEvent.getRegistryAccess(), tagsUpdatedEvent.getUpdateCause() == TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD);
    }

    @SubscribeEvent
    public static void onServerAboutToStartEvent(ServerAboutToStartEvent event) {
        WeatherManager.BIOME_WEATHER_LIST.clear();
        WeatherManager.BIOME_WEATHER_QUERY_LIST.clear();
        WeatherManager.NEXT_CHECK_BIOME_MAP.clear();
    }

    @SubscribeEvent
    public static void onServerStoppingEvent(ServerStoppingEvent event) {
        CropGrowthHandler.clearOnClientExitOrServerClose();
        NaturalPlantHandler.clearOnClientExitOrServerClose();
        BiomeClimateManager.clearOnClientExitOrServerClose();
        SnowChecker.clearOnClientExitOrServerClose();
        ESSortInfo.clearOnClientExitOrServerClose();
    }

    @SubscribeEvent
    public static void onSleepFinishedTimeEvent(CanPlayerSleepEvent event) {
        if (event.getVanillaProblem() == Player.BedSleepingProblem.NOT_POSSIBLE_NOW) {
            BlockPos pos = event.getPos();
            Level level = event.getLevel();
            if (EclipticUtil.hasLocalWeather(level) && WeatherManager.isThunderAtBiome(level, pos)) {
                event.setProblem(null);
            }
        }
    }

    @SubscribeEvent
    public static void onSleepFinishedTimeEvent(CanContinueSleepingEvent event) {
        if (!event.mayContinueSleeping() && event.getProblem() == Player.BedSleepingProblem.NOT_POSSIBLE_NOW) {
            BlockPos pos = event.getEntity().getSleepingPos().orElse(null);
            Level level = event.getEntity().level();
            if (pos != null && EclipticUtil.hasLocalWeather(level) && WeatherManager.isThunderAtBiome(level, pos)) {
                event.setContinueSleeping(true);
            }
        }
    }

    @SubscribeEvent
    public static void onSleepFinishedTimeEvent(SleepFinishedTimeEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            long newTime = event.getNewTime();
            long oldDayTime = level.getDayTime();
            WeatherManager.updateAfterSleep(level, newTime, oldDayTime);
        }
    }

    @SubscribeEvent
    public static void onLevelLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            if (((List)CommonConfig.Season.validDimensions.get()).contains(level.dimension().location().toString())) {
                MapChecker.validDimension.add((Level)level);
            }
            WeatherManager.createLevelBiomeWeatherList((Level)level);
            SolarHolders.createSaveData((Level)level, SolarDataManager.get(level));
        }
    }

    @SubscribeEvent
    public static void onLevelUnloadEvent(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            WeatherManager.BIOME_WEATHER_LIST.remove(level);
            WeatherManager.NEXT_CHECK_BIOME_MAP.remove(level);
            WeatherManager.BIOME_WEATHER_QUERY_LIST.remove(level);
            SolarHolders.DATA_MANAGER_MAP.remove(level);
            MapChecker.unloadLevel(level);
            MapChecker.validDimension.removeIf(l -> l.equals(level));
        }
    }

    @SubscribeEvent
    public static void onChunkUnloadEvent(ChunkEvent.Unload event) {
        MapChecker.unloadChunk(event.getChunk().getLevel(), event.getChunk().getPos());
        CropGrowthHandler.unloadChunk(event.getChunk().getLevel(), event.getChunk().getPos());
    }

    @SubscribeEvent
    public static void onChunkDataSaveEvent(ChunkDataEvent.Save event) {
        Level level;
        SolarDataManager data;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level && (data = SolarHolders.getSaveData(level = (Level)levelAccessor)) != null) {
            data.saveChunk(event.getChunk().getPos(), event.getData());
        }
    }

    @SubscribeEvent
    public static void onChunkDataLoadEvent(ChunkDataEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            SolarHolders.getSaveDataLazy(level).ifPresent(solarDataManager -> solarDataManager.loadChunk(event.getChunk().getPos(), event.getData()));
        }
    }

    @SubscribeEvent
    public static void onLevelTick(LevelTickEvent.Post event) {
        ServerLevel serverLevel;
        SolarDataManager data;
        Level level = event.getLevel();
        if (level instanceof ServerLevel && (data = SolarHolders.getSaveData((Level)(serverLevel = (ServerLevel)level))) != null) {
            data.tickLevel(serverLevel);
        }
        MapChecker.tickLevel(level);
    }

    @SubscribeEvent
    public static void onLevelTickPre(LevelTickEvent.Pre event) {
        if (event.getLevel() instanceof ServerLevel) {
            WeatherManager.tickAverageWeather(event.getLevel());
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            WeatherManager.onLoggedIn(serverPlayer, true);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            WeatherManager.onLoggedIn(serverPlayer, false);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.Clone event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Thread t = new Thread(() -> {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                WeatherManager.onLoggedIn(serverPlayer, false);
            });
            t.start();
        }
    }

    @SubscribeEvent
    public static void onCropGrowUp(CanPlantGrowEvent event) {
        CropGrowthHandler.beforeCropGrowUp(event);
    }

    @SubscribeEvent
    public static void onCropGrowUp(CropGrowEvent.Pre event) {
        if (!CommonConfig.isForceCropCompatMode()) {
            CropGrowthHandler.beforeCropGrowUp(event);
        }
    }

    @SubscribeEvent
    public static void onCropGrowUp(BlockGrowFeatureEvent event) {
        CropGrowthHandler.beforeCropGrowUp(event);
    }

    @SubscribeEvent
    public static void onCropGrowUp(BonemealEvent event) {
        CropGrowthHandler.beforeCropGrowUp(event);
    }

    @SubscribeEvent
    public static void onPlayerTickPre(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            WeatherManager.tickPlayerSeasonEffect(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onPlayerTickPost(PlayerTickEvent.Post event) {
        ServerPlayer serverPlayer;
        Level level;
        Player player = event.getEntity();
        if (player instanceof ServerPlayer && (level = (serverPlayer = (ServerPlayer)player).level()).getGameTime() % 20L == 0L) {
            ModAdvancements.parentNeedCriterion.get().trigger(serverPlayer);
            SolarDataManager data = SolarHolders.getSaveData(level);
            if (data != null) {
                float v = data.calculateHumidityModification(serverPlayer.blockPosition(), false);
                SimpleNetworkHandler.send(serverPlayer, new HumidModifyMessage(serverPlayer.blockPosition(), v));
            }
        }
    }

    @SubscribeEvent
    public static void onChunkWatch(ChunkWatchEvent.Sent event) {
        MapChecker.sendChunkLoginInfo(event.getLevel(), event.getChunk(), event.getPos(), event.getPlayer());
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        ChunkAccess chunk = event.getChunk();
        BiomeHolder biomeHolder = null;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            if (event.isNewChunk()) {
                MapChecker.setNewChunk(serverLevel, chunk);
            }
            biomeHolder = MapChecker.getOrUpdateChunkBiomeData(serverLevel, chunk, event.getChunk().getPos());
        }
        if ((levelAccessor = event.getLevel()) instanceof Level) {
            Level level = (Level)levelAccessor;
            ChunkInfoMap chunkInfoMap = MapChecker.forceChunkUpdateHeight(level, chunk);
            if (EclipticUtil.canSnowyBlockInteract() && biomeHolder != null && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                int biomeDataVersion = EclipticUtil.getBiomeDataVersion(level);
                if (biomeHolder.version() != biomeDataVersion || !biomeHolder.hasUpdated()) {
                    biomeHolder = null;
                }
                if (biomeHolder != null) {
                    SnowyMapChecker.forceChunkUpdateHeight(serverLevel, chunk, chunkInfoMap, biomeHolder, true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onNeighborNotifyEvent(BlockEvent.NeighborNotifyEvent event) {
    }
}

