/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public record SolarTermsRecord(Object2IntLinkedOpenHashMap<SolarTerm> solarTerms) {
    public static final int size = SolarTerm.collectValues().length;
    public static final Codec<SolarTermsRecord> CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(solarHolderInstance -> solarHolderInstance.group((App)Codec.INT.sizeLimitedListOf(size).fieldOf("solar_terms").forGetter(solarHolder -> solarHolder.solarTerms().keySet().stream().map(Enum::ordinal).toList()), (App)Codec.INT.sizeLimitedListOf(size).optionalFieldOf("solar_terms_counter").forGetter(solarHolder -> Optional.of(solarHolder.solarTerms().values().stream().toList()))).apply((Applicative)solarHolderInstance, (intArray, counter) -> {
        Object2IntLinkedOpenHashMap solarTerms = new Object2IntLinkedOpenHashMap();
        int i = 0;
        int intArrayLength = intArray.size();
        while (i < intArrayLength) {
            int id = (Integer)intArray.get(i);
            int finalI = i++;
            solarTerms.put((Object)SolarTerm.collectValues()[id], counter.map(c -> (Integer)c.get(finalI)).orElse(1).intValue());
        }
        return new SolarTermsRecord((Object2IntLinkedOpenHashMap<SolarTerm>)solarTerms);
    })));
    public static final StreamCodec<RegistryFriendlyByteBuf, SolarTermsRecord> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, SolarTermsRecord>(){

        public SolarTermsRecord decode(RegistryFriendlyByteBuf byteBuf) {
            IntList intArray = byteBuf.readIntIdList();
            IntList counter = byteBuf.readIntIdList();
            Object2IntLinkedOpenHashMap solarTerms = new Object2IntLinkedOpenHashMap();
            int intArrayLength = intArray.size();
            for (int i = 0; i < intArrayLength; ++i) {
                int id = intArray.getInt(i);
                solarTerms.put((Object)SolarTerm.collectValues()[id], counter.getInt(i));
            }
            return new SolarTermsRecord((Object2IntLinkedOpenHashMap<SolarTerm>)solarTerms);
        }

        public void encode(RegistryFriendlyByteBuf byteBuf, SolarTermsRecord solarHolder) {
            byteBuf.writeIntIdList((IntList)solarHolder.solarTerms.keySet().stream().map(Enum::ordinal).collect(Collectors.toCollection(IntArrayList::new)));
            byteBuf.writeIntIdList((IntList)solarHolder.solarTerms.values().stream().collect(Collectors.toCollection(IntArrayList::new)));
        }
    };

    public boolean addAndCheck(SolarTerm st) {
        this.solarTerms.addTo((Object)st, 1);
        return this.solarTerms.size() < 24;
    }
}

