/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.util.codec.ESExtraCodec;
import com.teamtea.eclipticseasons.common.block.base.SimpleEntityBlock;
import com.teamtea.eclipticseasons.common.block.blockentity.GreenHouseCoreBlockEntity;
import com.teamtea.eclipticseasons.common.core.crop.CropGrowthHandler;
import com.teamtea.eclipticseasons.common.registry.BlockEntityRegistry;
import com.teamtea.eclipticseasons.common.registry.BlockRegistry;
import com.teamtea.eclipticseasons.common.registry.ItemRegistry;
import com.teamtea.eclipticseasons.common.registry.ParticleRegistry;
import com.teamtea.eclipticseasons.config.ClientConfig;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GreenHouseCoreBlock
extends SimpleEntityBlock {
    public static final IntegerProperty POWER = BlockStateProperties.POWER;
    public static final MapCodec<GreenHouseCoreBlock> CODEC = RecordCodecBuilder.mapCodec(blockInstance -> blockInstance.group((App)ESExtraCodec.SEASON.fieldOf("season").forGetter(GreenHouseCoreBlock::getSeason), (App)GreenHouseCoreBlock.propertiesCodec()).apply((Applicative)blockInstance, GreenHouseCoreBlock::new));
    private final Season season;

    public GreenHouseCoreBlock(Season season, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)POWER, (Comparable)Integer.valueOf(0)));
        this.season = season;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{POWER}));
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)BlockEntityRegistry.greenhouse_core_entity_type.get()).create(pPos, pState);
    }

    @Override
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        if (!((Boolean)ClientConfig.Particle.seasonGreenhouse.get()).booleanValue()) {
            return;
        }
        int count = (Integer)ClientConfig.Particle.SeasonGreenhouseParticleSpawnCount.get();
        Direction direction = Direction.DOWN;
        Integer color = this.getSeason().getColor().getColor();
        float r = (float)FastColor.ARGB32.red((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.green((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
        ColorParticleOption colorParticleOption = ColorParticleOption.create(ParticleRegistry.GREENHOUSE, (float)r, (float)g, (float)b);
        for (int i = 0; i < count; ++i) {
            boolean inRoom;
            double z;
            double y;
            double d0 = (double)pos.getX() + (random.nextDouble() * 32.0 - 16.0);
            double d1 = (double)pos.getY() - 0.5 - random.nextDouble() * 10.0 + 2.0;
            double d2 = (double)pos.getZ() + (random.nextDouble() * 32.0 - 16.0);
            double d3 = (random.nextDouble() - 0.5) * 0.4;
            double x = d0 + (double)direction.getStepX() * d3;
            BlockPos blockPos = new BlockPos((int)x, (int)(y = d1 + (double)direction.getStepY() * d3), (int)(z = d2 + (double)direction.getStepZ() * d3));
            boolean bl = inRoom = level.isEmptyBlock(blockPos) && CropGrowthHandler.isInRoom((LevelAccessor)level, blockPos, Blocks.AIR.defaultBlockState(), Optional.empty());
            if (!inRoom) continue;
            level.addParticle((ParticleOptions)colorParticleOption, x, y, z, random.nextGaussian() * 0.005, 0.005 + random.nextDouble() * 0.02, random.nextGaussian() * 0.005);
        }
    }

    public Season getSeason() {
        return this.season;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level worldIn, BlockState state, BlockEntityType<T> blockEntityType) {
        return !worldIn.isClientSide ? GreenHouseCoreBlock.createTickerHelper(blockEntityType, (BlockEntityType)BlockEntityRegistry.greenhouse_core_entity_type.get(), GreenHouseCoreBlockEntity::tick) : null;
    }

    protected int getSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return (Integer)blockState.getValue((Property)POWER);
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (player.isShiftKeyDown()) {
            if (level instanceof ServerLevel) {
                level.playSound(null, pos, SoundEvents.SMALL_AMETHYST_BUD_BREAK, SoundSource.BLOCKS);
                Item item = switch (this.getSeason()) {
                    case Season.SPRING -> (Item)ItemRegistry.spring_greenhouse_essence_item.get();
                    case Season.SUMMER -> (Item)ItemRegistry.summer_greenhouse_essence_item.get();
                    case Season.AUTUMN -> (Item)ItemRegistry.autumn_greenhouse_essence_item.get();
                    case Season.WINTER -> (Item)ItemRegistry.winter_greenhouse_essence_item.get();
                    default -> Items.AIR;
                };
                Block.popResource((Level)level, (BlockPos)pos.above(), (ItemStack)new ItemStack((ItemLike)item));
                level.setBlockAndUpdate(pos, ((Block)BlockRegistry.greenhouse_core_container.get()).defaultBlockState());
            }
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }
}

