/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.block;

import com.mojang.serialization.MapCodec;
import com.teamtea.eclipticseasons.api.constant.biome.Humidity;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.client.util.ClientCon;
import com.teamtea.eclipticseasons.common.block.CalendarBlock;
import com.teamtea.eclipticseasons.common.block.base.WallPlacedBlock;
import com.teamtea.eclipticseasons.common.core.SolarHolders;
import com.teamtea.eclipticseasons.common.core.crop.CropGrowthHandler;
import com.teamtea.eclipticseasons.common.core.solar.SolarDataManager;
import com.teamtea.eclipticseasons.common.misc.SimpleVoxelShapeUtils;
import java.util.Optional;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class HygrometerBlock
extends WallPlacedBlock {
    public final VoxelShape[] SHAPES = new VoxelShape[4];
    public static final IntegerProperty POWER = BlockStateProperties.POWER;

    public HygrometerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        VoxelShape base = Shapes.box((double)0.0625, (double)0.0, (double)0.75, (double)0.9375, (double)0.6875, (double)1.0);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            this.SHAPES[direction.get2DDataValue()] = SimpleVoxelShapeUtils.rotateVoxelShape(base, Direction.Axis.Y, HygrometerBlock.getRotateYByFacing((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction)));
        }
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return HygrometerBlock.simpleCodec(CalendarBlock::new);
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.SHAPES[((Direction)pState.getValue((Property)FACING)).get2DDataValue()];
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.randomTick(state, level, pos, random);
        this.tick(state, level, pos, random);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.tick(state, level, pos, random);
        HygrometerBlock.updateLevel(level, state, pos);
        level.scheduleTick(pos, (Block)this, 200);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{POWER}));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return null;
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        level.scheduleTick(pos, (Block)this, 200);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return HygrometerBlock.getNewState(context.getLevel(), super.getStateForPlacement(context), context.getClickedPos());
    }

    private static void updateLevel(ServerLevel level, BlockState state, BlockPos pos) {
        BlockState oldState = state;
        if ((state = HygrometerBlock.getNewState((Level)level, state, pos)) != oldState) {
            level.setBlock(pos, state, 3);
            level.playSound(null, pos, SoundEvents.SMALL_AMETHYST_BUD_PLACE, SoundSource.BLOCKS);
        }
    }

    private static BlockState getNewState(Level level, BlockState state, BlockPos pos) {
        SolarDataManager data = SolarHolders.getSaveData(level);
        if (data != null) {
            BlockPos checkPos = pos.relative((Direction)state.getValue((Property)FACING));
            float chance = 0.0f;
            for (int i = 0; i < 20; ++i) {
                chance += CropGrowthHandler.isInRoom((LevelAccessor)level, checkPos, level.getBlockState(checkPos), Optional.of(BlockPredicate.Builder.block().of(new Block[]{state.getBlock()}).build())) ? 1.0f : 0.0f;
            }
            float humidityAt = EclipticUtil.getHumidityLevelAt(level, data.getSolarTerm(), CropGrowthHandler.getCropBiome((LevelAccessor)level, pos), pos, !level.isClientSide());
            if (chance > 8.0f) {
                humidityAt += level.isClientSide() ? ClientCon.humidityModificationLevel : data.calculateHumidityModification(checkPos);
            }
            int p = HygrometerBlock.getPowerFromHumidityLevel(Humidity.getHumid(humidityAt).ordinal());
            state = (BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(p));
        }
        return state;
    }

    protected int getSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return (Integer)blockState.getValue((Property)POWER);
    }

    public static int getHumidityLevelFromPower(int power) {
        return Mth.clamp((int)Math.round((float)power * 4.0f / 15.0f), (int)0, (int)4);
    }

    public static int getPowerFromHumidityLevel(int humidityLevel) {
        return Math.round((float)humidityLevel * 15.0f / 4.0f);
    }
}

