/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.block;

import com.mojang.serialization.MapCodec;
import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.common.registry.BlockRegistry;
import com.teamtea.eclipticseasons.config.CommonConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class IceOrSnowCauldronBlock
extends AbstractCauldronBlock {
    public static final CauldronInteraction.InteractionMap EMPTY = CauldronInteraction.newInteractionMap((String)EclipticSeasons.rl("empty").toString());

    public IceOrSnowCauldronBlock(BlockBehaviour.Properties properties) {
        super(properties, EMPTY);
        this.registerDefaultState(this.defaultBlockState());
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return Items.CAULDRON.getDefaultInstance();
    }

    protected MapCodec<? extends AbstractCauldronBlock> codec() {
        return IceOrSnowCauldronBlock.simpleCodec(IceOrSnowCauldronBlock::new);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        Block block = state.getBlock();
        if (block == BlockRegistry.snow_cauldron.get() && stack.is(ItemTags.SHOVELS)) {
            return IceOrSnowCauldronBlock.givePlayerResult(stack, new ItemStack((ItemLike)Items.SNOWBALL, 4), Blocks.SNOW.defaultBlockState(), level, pos, player);
        }
        if (block == BlockRegistry.ice_cauldron.get() && stack.is(ItemTags.PICKAXES)) {
            return IceOrSnowCauldronBlock.givePlayerResult(stack, new ItemStack((ItemLike)Items.ICE), Blocks.ICE.defaultBlockState(), level, pos, player);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public boolean isFull(BlockState state) {
        return true;
    }

    @NotNull
    protected static ItemInteractionResult givePlayerResult(ItemStack stack, ItemStack result, BlockState state, Level level, BlockPos pos, Player player) {
        if (!level.isClientSide) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)result);
            player.awardStat(Stats.USE_CAULDRON);
            player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
            level.setBlockAndUpdate(pos, Blocks.CAULDRON.defaultBlockState());
            level.playSound(null, pos, state.getSoundType((LevelReader)level, pos, (Entity)player).getHitSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            level.gameEvent(null, (Holder)GameEvent.FLUID_PICKUP, pos);
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public static void handleChange(BlockState state, Level level, BlockPos pos, Biome.Precipitation precipitation) {
        if (((Boolean)CommonConfig.Debug.disableIceOrSnowCauldron.get()).booleanValue()) {
            return;
        }
        if (precipitation == Biome.Precipitation.SNOW) {
            BlockState blockstate = null;
            if (state.getBlock() == Blocks.POWDER_SNOW_CAULDRON) {
                blockstate = ((Block)BlockRegistry.snow_cauldron.get()).defaultBlockState();
            } else if (state.getBlock() == Blocks.WATER_CAULDRON) {
                blockstate = ((Block)BlockRegistry.ice_cauldron.get()).defaultBlockState();
            }
            if (blockstate != null) {
                level.setBlockAndUpdate(pos, blockstate);
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)blockstate));
            }
        }
    }

    public static void init() {
        CauldronInteraction.EMPTY.map().put(Items.SNOW_BLOCK, (state, level, pos, player, hand, stack) -> {
            IceOrSnowCauldronBlock.fillEmptyCauldron(level, pos, player, hand, stack, ((Block)BlockRegistry.snow_cauldron.get()).defaultBlockState(), SoundEvents.SNOW_PLACE);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        });
        CauldronInteraction.EMPTY.map().put(Items.ICE, (state, level, pos, player, hand, stack) -> {
            IceOrSnowCauldronBlock.fillEmptyCauldron(level, pos, player, hand, stack, ((Block)BlockRegistry.ice_cauldron.get()).defaultBlockState(), SoundEvents.GLASS_PLACE);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        });
    }

    protected static void fillEmptyCauldron(Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack filledStack, BlockState state, SoundEvent soundEvent) {
        if (((Boolean)CommonConfig.Debug.disableIceOrSnowCauldron.get()).booleanValue()) {
            return;
        }
        if (!level.isClientSide) {
            filledStack.consume(1, (LivingEntity)player);
            player.awardStat(Stats.FILL_CAULDRON);
            player.awardStat(Stats.ITEM_USED.get((Object)filledStack.getItem()));
            level.setBlockAndUpdate(pos, state);
            level.playSound(null, pos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.gameEvent(null, (Holder)GameEvent.BLOCK_PLACE, pos);
        }
    }

    public Component getTip() {
        if (this == BlockRegistry.snow_cauldron.get()) {
            return Component.translatable((String)"info.eclipticseasons.snow_cauldron.extraction");
        }
        if (this == BlockRegistry.ice_cauldron.get()) {
            return Component.translatable((String)"info.eclipticseasons.ice_cauldron.extraction");
        }
        return Component.empty();
    }
}

