/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.block;

import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.common.block.blockentity.QuestHangingSignBlockEntity;
import com.teamtea.eclipticseasons.common.registry.BlockEntityRegistry;
import com.teamtea.eclipticseasons.common.registry.ItemRegistry;
import com.teamtea.eclipticseasons.common.registry.ParticleRegistry;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuestWallHangingSignBlock
extends WallHangingSignBlock {
    protected String descriptionId = null;

    public QuestWallHangingSignBlock(BlockBehaviour.Properties properties) {
        super(WoodType.OAK, properties);
    }

    @NotNull
    public String getDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = Util.makeDescriptionId((String)"block", (ResourceLocation)BuiltInRegistries.BLOCK.getKey((Object)this));
        }
        return this.descriptionId;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return ((Item)ItemRegistry.seasonal_prayer_scroll_item.get()).getDefaultInstance();
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntityRegistry.season_quest_hanging_sign_entity_type.get()).create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return QuestWallHangingSignBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)BlockEntityRegistry.season_quest_hanging_sign_entity_type.get()), QuestHangingSignBlockEntity::tick);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof QuestHangingSignBlockEntity) {
            QuestHangingSignBlockEntity questHangingSignBlockEntity = (QuestHangingSignBlockEntity)blockEntity;
            if (!level.isClientSide() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                questHangingSignBlockEntity.finishSeasonQuest(serverPlayer);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return InteractionResult.PASS;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        QuestWallHangingSignBlock.addSeasonalParticle(state, level, pos, random);
    }

    public static void addSeasonalParticle(BlockState state, Level level, BlockPos pos, RandomSource random) {
        Direction direction = Direction.DOWN;
        int color = Season.collectValues()[random.nextInt(Season.collectValues().length)].getColor().getColor();
        float r = (float)FastColor.ARGB32.red((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.green((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
        ColorParticleOption colorParticleOption = ColorParticleOption.create(ParticleRegistry.GREENHOUSE, (float)r, (float)g, (float)b);
        for (int i = 0; i < 2; ++i) {
            double z;
            double y;
            double x;
            double d0 = (double)pos.getX() + (random.nextDouble() - 0.5) + 0.5;
            double d1 = (double)pos.getY() + (random.nextDouble() - 0.5) - 0.125;
            double d2 = (double)pos.getZ() + (random.nextDouble() - 0.5) + 0.5;
            double d3 = (random.nextDouble() - 0.5) * 0.4;
            if (random.nextInt(6) != 0 || !level.isEmptyBlock(new BlockPos((int)(x = d0 + (double)direction.getStepX() * d3), (int)(y = d1 + (double)direction.getStepY() * d3), (int)(z = d2 + (double)direction.getStepZ() * d3)))) continue;
            level.addParticle((ParticleOptions)colorParticleOption, x, y, z, random.nextGaussian() * 0.005, 0.001 + random.nextDouble() * 0.02, random.nextGaussian() * 0.005);
        }
    }

    protected void spawnDestroyParticles(Level level, Player player, BlockPos pos, BlockState state) {
        level.levelEvent(player, 2001, pos, QuestWallHangingSignBlock.getId((BlockState)state));
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockState blockState = super.playerWillDestroy(level, pos, state, player);
        if (!level.isClientSide() && player.isCreative()) {
            QuestHangingSignBlockEntity.removeSign(level, pos);
        }
        return blockState;
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!(movedByPiston || level.isClientSide() || newState.is((Block)this))) {
            QuestHangingSignBlockEntity.popSign(level, pos);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }
}

