/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.block.blockentity;

import com.mojang.serialization.DynamicOps;
import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.data.craft.HumidityControl;
import com.teamtea.eclipticseasons.api.data.misc.ESSortInfo;
import com.teamtea.eclipticseasons.api.data.misc.PosAndBlockStateCheck;
import com.teamtea.eclipticseasons.common.block.blockentity.base.SyncBlockEntity;
import com.teamtea.eclipticseasons.common.core.SolarHolders;
import com.teamtea.eclipticseasons.common.core.crop.HumidityControlProvider;
import com.teamtea.eclipticseasons.common.core.solar.SolarDataManager;
import com.teamtea.eclipticseasons.common.registry.BlockEntityRegistry;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class HumidityControlBlockEntity
extends SyncBlockEntity {
    protected HumidityControl humidityControl;
    protected int time = 0;

    public HumidityControlBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.humidity_control_entity_type.get(), pos, state);
    }

    public HumidityControlBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("time", this.time);
        if (this.humidityControl != null) {
            RegistryOps dynamicops = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            HumidityControl.CODEC.encodeStart((DynamicOps)dynamicops, (Object)this.humidityControl).resultOrPartial(EclipticSeasons::logger).ifPresent(tag1 -> tag.put("humidity_control", tag1));
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.time = tag.getInt("time");
        if (tag.contains("humidity_control")) {
            RegistryOps dynamicops = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            HumidityControl.CODEC.parse((DynamicOps)dynamicops, (Object)tag.get("humidity_control")).resultOrPartial(EclipticSeasons::logger).ifPresent(humidityControl -> {
                this.humidityControl = humidityControl;
            });
        } else {
            this.humidityControl = null;
        }
    }

    public void setRemoved() {
        SolarDataManager manager = SolarHolders.getSaveData(this.level);
        if (manager != null) {
            manager.removeHumidityControlProvider(this.getBlockPos());
        }
        super.setRemoved();
    }

    protected boolean isRecipeCacheValid(@NotNull HumidityControl humidityControl) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (PosAndBlockStateCheck c : humidityControl.checks()) {
                if (c.matches(serverLevel, this.getBlockPos())) continue;
                return false;
            }
        }
        return true;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, HumidityControlBlockEntity blockEntity) {
        SolarDataManager manager = SolarHolders.getSaveData(level);
        int hl = blockEntity.getHumidityModifiedLevel();
        float rl = blockEntity.getHumidityModifiedRange();
        if (manager != null) {
            HumidityControlProvider nearHumidityControlProvider = manager.queryHumidityControlProvider(blockPos);
            if (nearHumidityControlProvider != null && (float)hl == nearHumidityControlProvider.getLevel() && rl == nearHumidityControlProvider.getRange()) {
                if (nearHumidityControlProvider.getRemainTime() < 10) {
                    nearHumidityControlProvider.addRemainTime(100);
                }
            } else if (hl != 0) {
                manager.addHumidityControlProvider(blockPos, new HumidityControlProvider(hl, rl, 240));
            } else if (nearHumidityControlProvider != null) {
                manager.removeHumidityControlProvider(blockPos);
            }
        }
        blockEntity.endTick();
        blockEntity.searchRecipe();
    }

    protected void searchRecipe() {
        if (this.humidityControl == null) {
            for (HumidityControl humidityControl : ESSortInfo.sorted2(this.level.registryAccess().registryOrThrow(ESRegistries.HUMIDITY_CONTROL))) {
                if (!this.isRecipeCacheValid(humidityControl)) continue;
                this.humidityControl = humidityControl;
                this.time = humidityControl.lasting_time();
                this.setChanged();
                break;
            }
        }
    }

    protected boolean hasNoRecipe() {
        return this.humidityControl == null;
    }

    protected void endTick() {
        if (this.humidityControl != null && this.time <= 0) {
            this.endRecipe();
        } else if (this.humidityControl != null && this.isRecipeCacheValid(this.humidityControl)) {
            if (!this.humidityControl.noCost()) {
                --this.time;
                this.setChanged();
            }
        } else if (this.humidityControl != null || this.time > 0) {
            this.resetRecipe();
        }
    }

    protected void endRecipe() {
        this.humidityControl = null;
        this.time = 0;
        this.setChanged();
    }

    protected void resetRecipe() {
        this.humidityControl = null;
        this.time = 0;
        this.setChanged();
    }

    public int getHumidityModifiedLevel() {
        return this.humidityControl != null && this.isRecipeCacheValid(this.humidityControl) ? this.humidityControl.level() : 0;
    }

    public int getHumidityModifiedRange() {
        return this.humidityControl != null && this.isRecipeCacheValid(this.humidityControl) ? this.humidityControl.range() : 0;
    }
}

