/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.block.blockentity;

import com.mojang.serialization.DynamicOps;
import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.data.climate.AgroClimaticZone;
import com.teamtea.eclipticseasons.api.data.misc.ESSortInfo;
import com.teamtea.eclipticseasons.api.data.quest.SeasonQuest;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.common.core.crop.CropGrowthHandler;
import com.teamtea.eclipticseasons.common.registry.BlockEntityRegistry;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class QuestHangingSignBlockEntity
extends SignBlockEntity {
    public static final ModelProperty<SignBlock> SIGN_BLOCK_MODEL_PROPERTY = new ModelProperty();
    private SignBlock sign;
    private SeasonQuest seasonQuest;
    private int sleepTime = 0;

    public QuestHangingSignBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)BlockEntityRegistry.season_quest_hanging_sign_entity_type.get(), pos, blockState);
    }

    public static void popSign(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof QuestHangingSignBlockEntity) {
            QuestHangingSignBlockEntity blockEntity2 = (QuestHangingSignBlockEntity)blockEntity;
            if (blockEntity2.sign != null) {
                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)blockEntity2.getSignType().asItem().getDefaultInstance());
            }
        }
    }

    public static void removeSign(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof QuestHangingSignBlockEntity) {
            QuestHangingSignBlockEntity blockEntity2 = (QuestHangingSignBlockEntity)blockEntity;
            blockEntity2.setSignType(null);
        }
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putString("sign_type", BuiltInRegistries.BLOCK.getKey((Object)this.getSignType()).toString());
        if (this.seasonQuest != null) {
            RegistryOps dynamicops = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            SeasonQuest.CODEC.encodeStart((DynamicOps)dynamicops, (Object)this.seasonQuest).resultOrPartial(EclipticSeasons::logger).ifPresent(tag1 -> tag.put("season_quest", tag1));
        }
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        Block block;
        super.loadAdditional(tag, registries);
        if (tag.contains("sign_type") && (block = (Block)BuiltInRegistries.BLOCK.get(EclipticSeasons.parse(tag.getString("sign_type")))) instanceof SignBlock) {
            SignBlock signBlock;
            this.sign = signBlock = (SignBlock)block;
        }
        if (tag.contains("season_quest")) {
            RegistryOps dynamicops = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            SeasonQuest.CODEC.parse((DynamicOps)dynamicops, (Object)tag.get("season_quest")).resultOrPartial(EclipticSeasons::logger).ifPresent(seasonQuest1 -> {
                this.seasonQuest = seasonQuest1;
            });
        } else {
            this.seasonQuest = null;
        }
    }

    protected void inventoryChanged() {
        super.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void setSignType(SignBlock signType) {
        this.sign = signType;
        this.inventoryChanged();
    }

    public SignBlock getSignType() {
        return this.sign != null ? this.sign : (SignBlock)Blocks.OAK_WALL_HANGING_SIGN;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, QuestHangingSignBlockEntity sign) {
        if (!level.isClientSide()) {
            if (sign.getSeasonQuest() == null) {
                if (sign.sleepTime == 0) {
                    sign.createSeasonalQuest();
                    if (sign.getSeasonQuest() != null) {
                        sign.setQuestText();
                    } else {
                        sign.sleepTime = 100;
                    }
                } else {
                    --sign.sleepTime;
                }
                sign.setChanged();
            } else if (level.getRandom().nextInt(128) == 0) {
                SolarTerm nowSolarTerm = EclipticUtil.getNowSolarTerm(level);
                Holder<AgroClimaticZone> agroClimaticZoneHolder = CropGrowthHandler.getclimateTypeHolder(CropGrowthHandler.getCropBiome((LevelAccessor)level, pos));
                if (QuestHangingSignBlockEntity.isInvalidQuest(sign.getSeasonQuest(), nowSolarTerm, agroClimaticZoneHolder)) {
                    sign.resetQuest();
                }
            }
        }
    }

    private void setQuestText() {
        SeasonQuest signSeasonQuest = this.getSeasonQuest();
        if (signSeasonQuest != null) {
            SignText signText = new SignText();
            Component title = signSeasonQuest.tittle().orElse((Component)Component.translatable((String)"block.eclipticseasons.season_quest_ceiling_hanging_sign"));
            signText = signText.setMessage(0, title);
            if (signSeasonQuest.description().isPresent()) {
                for (int i = 0; i < signSeasonQuest.description().get().size() && i < 3; ++i) {
                    signText = signText.setMessage(i + 1, signSeasonQuest.description().get().get(i));
                }
            } else if (!signSeasonQuest.need().isEmpty()) {
                for (int i = 0; i < signSeasonQuest.need().size() && i < 3; ++i) {
                    ItemPredicate itemPredicate = signSeasonQuest.need().get(i);
                    HolderSet holders = itemPredicate.items().orElse(HolderSet.empty());
                    if (holders.size() <= 0) continue;
                    Item value = (Item)holders.get(0).value();
                    MutableComponent c = Component.translatable((String)"eclipticseasons.season_quest.hint.item_count", (Object[])new Object[]{value.getName(value.getDefaultInstance()), itemPredicate.count().max().orElse(itemPredicate.count().min().orElse(0))});
                    signText = signText.setMessage(i + 1, (Component)c);
                }
            }
            this.setText(signText, true);
        }
    }

    public void createSeasonalQuest() {
        this.level.registryAccess().registry(ESRegistries.SEASON_QUEST).ifPresent(seasonQuests -> {
            SolarTerm nowSolarTerm = EclipticUtil.getNowSolarTerm(this.level);
            Holder<AgroClimaticZone> agroClimaticZoneHolder = CropGrowthHandler.getclimateTypeHolder(CropGrowthHandler.getCropBiome((LevelAccessor)this.level, this.getBlockPos()));
            ArrayList<SeasonQuest> seasonQuestList = new ArrayList<SeasonQuest>();
            int totalWeight = 0;
            for (Map.Entry entry : ESSortInfo.sorted(seasonQuests.entrySet())) {
                SeasonQuest quest = (SeasonQuest)entry.getValue();
                if (QuestHangingSignBlockEntity.isInvalidQuest(quest, nowSolarTerm, agroClimaticZoneHolder)) continue;
                seasonQuestList.add(quest);
                totalWeight += quest.weight().orElse(10).intValue();
            }
            if (totalWeight < 1) {
                return;
            }
            int randWeight = this.level.getRandom().nextInt(totalWeight);
            int currentWeight = 0;
            for (SeasonQuest quest : seasonQuestList) {
                if (randWeight >= (currentWeight += quest.weight().orElse(1).intValue())) continue;
                this.seasonQuest = quest;
            }
        });
        if (this.seasonQuest == null) {
            this.showLoadingText();
        }
    }

    private static boolean isInvalidQuest(SeasonQuest quest, SolarTerm nowSolarTerm, Holder<AgroClimaticZone> agroClimaticZoneHolder) {
        if (quest.start().isPresent() != quest.end().isPresent()) {
            return true;
        }
        if (quest.start().isPresent() && !nowSolarTerm.isInTerms(quest.start().get(), quest.end().get())) {
            return true;
        }
        return agroClimaticZoneHolder == null || quest.climate().isPresent() && !quest.climate().get().contains(agroClimaticZoneHolder);
    }

    public SeasonQuest getSeasonQuest() {
        return this.seasonQuest;
    }

    public void finishSeasonQuest(ServerPlayer player) {
        SeasonQuest quest = this.getSeasonQuest();
        if (quest != null) {
            boolean isOk = true;
            QuestMatcher questMatcher = new QuestMatcher();
            for (ItemPredicate itemPredicate : quest.need()) {
                if (questMatcher.setPredicate(itemPredicate).test(player)) continue;
                isOk = false;
                break;
            }
            if (isOk) {
                for (ItemPredicate itemPredicate : quest.need()) {
                    questMatcher.setPredicate(itemPredicate).consume(player);
                }
                for (ItemStack stack : quest.award()) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack.copy());
                }
                this.resetQuest();
            }
        }
    }

    private void resetQuest() {
        this.seasonQuest = null;
        this.sleepTime = 100;
        this.inventoryChanged();
        this.showLoadingText();
    }

    private void showLoadingText() {
        this.setText(new SignText().setMessage(1, (Component)Component.translatable((String)"eclipticseasons.season_quest.hint.loading")), true);
    }

    public int getMaxTextLineWidth() {
        return 400;
    }

    @NotNull
    public ModelData getModelData() {
        return ModelData.builder().with(SIGN_BLOCK_MODEL_PROPERTY, (Object)this.getSignType()).build();
    }

    public static final class QuestMatcher
    implements Predicate<ItemStack> {
        private ItemPredicate predicate;
        private boolean strict = false;

        @Override
        public boolean test(ItemStack stack) {
            if (this.predicate.items().isPresent() && !stack.is((HolderSet)this.predicate.items().get())) {
                return false;
            }
            if (this.strict && !this.predicate.count().matches(stack.getCount())) {
                return false;
            }
            if (!this.predicate.components().test((DataComponentHolder)stack)) {
                return false;
            }
            for (ItemSubPredicate itemsubpredicate : this.predicate.subPredicates().values()) {
                if (itemsubpredicate.matches(stack)) continue;
                return false;
            }
            return true;
        }

        public QuestMatcher setPredicate(ItemPredicate predicate) {
            this.predicate = predicate;
            return this;
        }

        public QuestMatcher setStrict(boolean strict) {
            this.strict = strict;
            return this;
        }

        public boolean hasEnoughAmount(int count) {
            int cc = QuestMatcher.getCount(this.predicate);
            return count >= cc;
        }

        public static int getCount(ItemPredicate predicate) {
            return predicate.count().max().orElse(predicate.count().min().orElse(0));
        }

        @Override
        public boolean test(ServerPlayer player) {
            int i = player.getInventory().clearOrCountMatchingItems((Predicate)this, 0, (Container)player.inventoryMenu.getCraftSlots());
            return this.hasEnoughAmount(i);
        }

        public boolean consume(ServerPlayer player) {
            int i = player.getInventory().clearOrCountMatchingItems((Predicate)this, QuestMatcher.getCount(this.predicate), (Container)player.inventoryMenu.getCraftSlots());
            return this.hasEnoughAmount(i);
        }
    }
}

