/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.core.biome;

import com.mojang.datafixers.util.Pair;
import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.constant.climate.BiomeClimateSettings;
import com.teamtea.eclipticseasons.api.constant.climate.ISnowTerm;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.constant.tag.ClimateTypeBiomeTags;
import com.teamtea.eclipticseasons.api.constant.tag.ClimateTypeFilters;
import com.teamtea.eclipticseasons.api.data.climate.BiomesClimateSettings;
import com.teamtea.eclipticseasons.api.data.misc.ESSortInfo;
import com.teamtea.eclipticseasons.api.data.season.SeasonPhase;
import com.teamtea.eclipticseasons.api.data.weather.CustomRain;
import com.teamtea.eclipticseasons.api.data.weather.CustomSnowTerm;
import com.teamtea.eclipticseasons.api.misc.IBiomeTagHolder;
import com.teamtea.eclipticseasons.api.misc.RegistryFilter;
import com.teamtea.eclipticseasons.api.util.SimpleUtil;
import com.teamtea.eclipticseasons.api.util.fast.Enum2ObjectMap;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import com.teamtea.eclipticseasons.config.CommonConfig;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class BiomeClimateManager {
    public static final Map<Biome, BiomeClimateSettings> BIOME_CLIMATE_MAP = new IdentityHashMap<Biome, BiomeClimateSettings>();
    public static final Map<Biome, BiomeClimateSettings> CLIENT_CLIMATE_MAP = new IdentityHashMap<Biome, BiomeClimateSettings>();
    public static final Map<Biome, TagKey<Biome>> BIOME_TAG_KEY_MAP = new IdentityHashMap<Biome, TagKey<Biome>>(128);
    public static final Map<Biome, TagKey<Biome>> CLIENT_BIOME_TAG_KEY_MAP = new IdentityHashMap<Biome, TagKey<Biome>>(128);
    public static final Map<Biome, TagKey<Biome>> BIOME_COLOR_TAG_KEY_MAP = new IdentityHashMap<Biome, TagKey<Biome>>(128);
    public static final Map<Biome, TagKey<Biome>> CLIENT_BIOME_COLOR_TAG_KEY_MAP = new IdentityHashMap<Biome, TagKey<Biome>>(128);
    public static final Map<Biome, Boolean> SMALL_BIOME_MAP = new IdentityHashMap<Biome, Boolean>(16);
    public static final Map<Biome, Map<SolarTerm, Holder<SeasonPhase>>> SEASON_PHASE_MAP = new IdentityHashMap<Biome, Map<SolarTerm, Holder<SeasonPhase>>>();
    public static final Map<Biome, Map<SolarTerm, Holder<SeasonPhase>>> CLIENT_SEASON_PHASE_MAP = new IdentityHashMap<Biome, Map<SolarTerm, Holder<SeasonPhase>>>();
    public static final Map<Biome, Map<SolarTerm, CustomRain>> CUSTOME_BIOME_RAIN_MAP = new IdentityHashMap<Biome, Map<SolarTerm, CustomRain>>();
    public static final Map<Biome, Map<SolarTerm, CustomRain>> CLIENT_CUSTOME_BIOME_RAIN_MAP = new IdentityHashMap<Biome, Map<SolarTerm, CustomRain>>();
    public static final Map<Biome, ISnowTerm> CUSTOM_SNOW_TERM_MAP = new IdentityHashMap<Biome, ISnowTerm>();
    public static final Map<Biome, ISnowTerm> CLIENT_CUSTOM_SNOW_TERM_MAP = new IdentityHashMap<Biome, ISnowTerm>();
    public static final Map<Biome, Holder<Biome>> WEATHER_REGION_MAP = new IdentityHashMap<Biome, Holder<Biome>>();
    public static final Map<Biome, Integer> SNOW_LINE_MAP = new IdentityHashMap<Biome, Integer>();
    public static final Map<Biome, Integer> CLIENT_SNOW_LINE_MAP = new IdentityHashMap<Biome, Integer>();
    public static final BiomeClimateSettings EMPTY = new BiomeClimateSettings();
    public static final float SNOW_LEVEL = 0.15f;
    public static final float FROZEN_OCEAN_MELT_LEVEL = 0.1f;

    public static void resetBiomeTags(RegistryAccess registryAccess, boolean isServer) {
        BiomeClimateManager.putTag(registryAccess, isServer);
        BiomeClimateManager.putColorTag(registryAccess, isServer);
        BiomeClimateManager.resetAgroTag(registryAccess, isServer);
    }

    public static void resetBiomeTemps(RegistryAccess registryAccess, boolean isServer) {
        if (isServer) {
            BiomeClimateManager.resetSomeMap(registryAccess, ESRegistries.WEATHER_REGION, WEATHER_REGION_MAP, customRainBuilder -> Pair.of(customRainBuilder.sub(), customRainBuilder.core()), (map, pair) -> map.put((Biome)((Holder)pair.getFirst()).value(), (Holder)pair.getSecond()), () -> null, (biome, map) -> map);
        }
        BiomeClimateManager.resetSomeMap(registryAccess, ESRegistries.BIOME_CLIMATE_SETTING, isServer ? BIOME_CLIMATE_MAP : CLIENT_CLIMATE_MAP, customRainBuilder -> Pair.of(customRainBuilder.biomes(), (Object)customRainBuilder), (map, pair) -> {
            List biomesClimateSettingsList = map.computeIfAbsent((Biome)((Holder)pair.getFirst()).value(), k -> new ArrayList());
            biomesClimateSettingsList.add((BiomesClimateSettings)pair.getSecond());
        }, List::of, BiomeClimateSettings::new);
        BiomeClimateManager.resetSomeMap(registryAccess, ESRegistries.SEASON_CYCLE, isServer ? SEASON_PHASE_MAP : CLIENT_SEASON_PHASE_MAP, customRainBuilder -> Pair.of(customRainBuilder.biomes(), customRainBuilder.localMapping().combine()), (map, pair) -> map.put((Biome)((Holder)pair.getFirst()).value(), (Enum2ObjectMap)pair.getSecond()), () -> new Enum2ObjectMap(SolarTerm.class), (biome, map) -> map);
        BiomeClimateManager.resetSomeMap(registryAccess, ESRegistries.BIOME_RAIN, isServer ? CUSTOME_BIOME_RAIN_MAP : CLIENT_CUSTOME_BIOME_RAIN_MAP, customRainBuilder -> Pair.of(customRainBuilder.biomes(), customRainBuilder.build()), (map, pair) -> map.put((Biome)((Holder)pair.getFirst()).value(), (Map)pair.getSecond()), Map::of, (biome, map) -> map);
        BiomeClimateManager.resetSomeMap(registryAccess, ESRegistries.SNOW_TERM, isServer ? CUSTOM_SNOW_TERM_MAP : CLIENT_CUSTOM_SNOW_TERM_MAP, customRainBuilder -> Pair.of(customRainBuilder.biomes(), (Object)customRainBuilder), (map, pair) -> map.put((Biome)((Holder)pair.getFirst()).value(), (CustomSnowTerm)pair.getSecond()), () -> null, (biome, map) -> map);
        BiomeClimateManager.setSnowLine(registryAccess, isServer ? SNOW_LINE_MAP : CLIENT_SNOW_LINE_MAP);
    }

    public static void setSnowLine(RegistryAccess registryAccess, Map<Biome, Integer> biomeIntegerMap) {
        Optional biomeRegistry = registryAccess.registry(Registries.BIOME);
        if (biomeRegistry.isPresent()) {
            biomeIntegerMap.clear();
            for (List serializable : (List)CommonConfig.Snow.biomeSnowLines.get()) {
                String biomeOrTag = String.valueOf(serializable.get(0));
                int snowLineHeight = Integer.parseInt(String.valueOf(serializable.get(1)));
                if (biomeOrTag.startsWith("#")) {
                    TagKey biomeTagKey = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.parse((String)biomeOrTag.substring(1, biomeOrTag.length() - 1)));
                    Optional tag = ((Registry)biomeRegistry.get()).getTag(biomeTagKey);
                    if (!tag.isPresent()) continue;
                    for (Holder biomeHolder : (HolderSet.Named)tag.get()) {
                        biomeIntegerMap.putIfAbsent((Biome)biomeHolder.value(), snowLineHeight);
                    }
                    continue;
                }
                Optional holder = ((Registry)biomeRegistry.get()).getHolder(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.parse((String)biomeOrTag)));
                if (!holder.isPresent()) continue;
                biomeIntegerMap.putIfAbsent((Biome)((Holder.Reference)holder.get()).value(), snowLineHeight);
            }
        }
    }

    public static <T, U, R, S> void resetSomeMap(RegistryAccess registryAccess, ResourceKey<Registry<T>> resourceKey, Map<Biome, S> useMap, Function<T, Pair<HolderSet<Biome>, U>> biomeTransfer, BiConsumer<Map<Biome, R>, Pair<Holder<Biome>, U>> singleDeal, Supplier<R> emptyInstance, BiFunction<Biome, R, S> mapSaver) {
        useMap.clear();
        IdentityHashMap biomeUIdentityHashMap = new IdentityHashMap();
        Optional registry = registryAccess.registry(resourceKey);
        if (registry.isEmpty()) {
            SimpleUtil.warningForModWrongCalling(resourceKey);
        } else {
            Registry biomesClimateSettings = (Registry)registry.get();
            Set entries = biomesClimateSettings.entrySet();
            Optional holder = biomesClimateSettings.getHolder(0);
            if (holder.isPresent() && ((Holder.Reference)holder.get()).value() instanceof Comparable) {
                List<Map.Entry> sortedEntries = entries.stream().sorted(Comparator.comparing(e -> (Comparable)e.getValue())).toList();
                entries = new LinkedHashSet<Map.Entry>(sortedEntries);
            }
            entries = ESSortInfo.sorted(entries);
            for (Map.Entry entry : entries) {
                Pair<HolderSet<Biome>, U> pair = biomeTransfer.apply(entry.getValue());
                for (Holder next : (HolderSet)pair.getFirst()) {
                    singleDeal.accept(biomeUIdentityHashMap, Pair.of((Object)next, (Object)pair.getSecond()));
                }
            }
        }
        Optional biomes = registryAccess.registry(Registries.BIOME);
        Object objects = emptyInstance.get();
        biomes.ifPresent(biomeRegistry -> biomeRegistry.forEach(biome -> useMap.put((Biome)biome, (Object)mapSaver.apply((Biome)biome, (Object)biomeUIdentityHashMap.getOrDefault(biome, objects)))));
    }

    public static BiomeClimateSettings getBiomeClimateSettings(Biome biome, boolean isServer) {
        BiomeClimateSettings biomeClimateSettings = isServer ? BIOME_CLIMATE_MAP.get(biome) : CLIENT_CLIMATE_MAP.get(biome);
        return biomeClimateSettings == null ? EMPTY : biomeClimateSettings;
    }

    public static Map<SolarTerm, CustomRain> getCustomRain(Biome biome, boolean isServer) {
        Map<SolarTerm, CustomRain> solarTermCustomRainMap = isServer ? CUSTOME_BIOME_RAIN_MAP.get(biome) : CLIENT_CUSTOME_BIOME_RAIN_MAP.get(biome);
        return solarTermCustomRainMap == null ? Map.of() : solarTermCustomRainMap;
    }

    @Nullable
    public static ISnowTerm getCustomSnowTerm(Biome biome, boolean isServer) {
        return isServer ? CUSTOM_SNOW_TERM_MAP.get(biome) : CLIENT_CUSTOM_SNOW_TERM_MAP.get(biome);
    }

    public static int getSnowLine(Biome biome, boolean isServer) {
        Integer i = isServer ? SNOW_LINE_MAP.get(biome) : CLIENT_SNOW_LINE_MAP.get(biome);
        return i == null ? Integer.MAX_VALUE : i;
    }

    @Deprecated(forRemoval=true)
    public static void updateTemperature(Level level, SolarTerm solarTermIndex) {
    }

    @Deprecated(forRemoval=true)
    public static float agent$GetBaseTemperature(Biome biome) {
        return biome.getBaseTemperature();
    }

    @Deprecated
    public static boolean agent$hasPrecipitation(Biome biome) {
        return ((IBiomeTagHolder)biome).eclipticseasons$getBindTag() != ClimateTypeBiomeTags.RAINLESS;
    }

    @Deprecated(forRemoval=true)
    public static float fixTemp(Level level, Biome biome, float temp) {
        return temp;
    }

    @Nullable
    public static Holder<Biome> getHolder(RegistryAccess registryAccess, Biome biome) {
        return registryAccess.registryOrThrow(Registries.BIOME).holders().filter(biomeReference -> biomeReference.value() == biome).findFirst().orElse(null);
    }

    @Nullable
    public static Holder<Biome> getHolder(Registry<Biome> registryAccess, Biome biome) {
        return registryAccess.holders().filter(biomeReference -> biomeReference.value() == biome).findFirst().orElse(null);
    }

    public static TagKey<Biome> getTag(Biome biome) {
        TagKey biomeTagKey = CLIENT_BIOME_TAG_KEY_MAP.getOrDefault(biome, null);
        if (biomeTagKey != null) {
            return biomeTagKey;
        }
        return BIOME_TAG_KEY_MAP.getOrDefault(biome, ClimateTypeBiomeTags.RAINLESS);
    }

    public static TagKey<Biome> getColorTag(Biome biome) {
        TagKey biomeTagKey = CLIENT_BIOME_COLOR_TAG_KEY_MAP.getOrDefault(biome, null);
        if (biomeTagKey != null) {
            return biomeTagKey;
        }
        return BIOME_COLOR_TAG_KEY_MAP.getOrDefault(biome, ClimateTypeBiomeTags.NONE_COLOR_CHANGE);
    }

    public static Holder<Biome> getWeatherRegionOnwer(Biome biome) {
        return WEATHER_REGION_MAP.getOrDefault(biome, null);
    }

    public static void resetAgroTag(RegistryAccess registryAccess, boolean isServer) {
        BiomeClimateManager.applyBiomeTags(registryAccess, new HashSet<TagKey<Biome>>(ClimateTypeBiomeTags.OVERWORLD_AGRO_BIOME_TYPES), ClimateTypeFilters.OVERWORLD_AGRO_BIOME_PRESENT);
    }

    public static void putColorTag(RegistryAccess registryAccess, boolean isServer) {
        BiomeClimateManager.applyBiomeTags(registryAccess, isServer ? BIOME_COLOR_TAG_KEY_MAP : CLIENT_BIOME_COLOR_TAG_KEY_MAP, new HashSet<TagKey<Biome>>(ClimateTypeBiomeTags.BIOME_COLOR_TYPES), ClimateTypeFilters.COLOR_BIOME_PRESENT, holder -> ClimateTypeBiomeTags.NONE_COLOR_CHANGE, (biome, tag) -> ((IBiomeTagHolder)biome).eclipticseasons$setColorTag((TagKey<Biome>)tag));
    }

    public static void putTag(RegistryAccess registryAccess, boolean isServer) {
        for (Biome biome2 : SMALL_BIOME_MAP.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == isServer).map(Map.Entry::getKey).toList()) {
            SMALL_BIOME_MAP.remove(biome2);
        }
        Optional biomeRegistry = registryAccess.registry(Registries.BIOME);
        if (biomeRegistry.isPresent()) {
            Optional biomeNamed = ((Registry)biomeRegistry.get()).getTag(ClimateTypeBiomeTags.IS_SMALL);
            if (biomeNamed.isPresent()) {
                for (Holder holder2 : (HolderSet.Named)biomeNamed.get()) {
                    SMALL_BIOME_MAP.put((Biome)holder2.value(), isServer);
                    ((IBiomeTagHolder)holder2.value()).eclipticseasons$setSmall(true);
                }
            }
            for (TagKey tagKey : ClimateTypeBiomeTags.BIOME_TYPES) {
                TagKey<Biome> oldTag = ClimateTypeBiomeTags.create(tagKey.location().getPath().replace("rain/", ""));
                Optional oldTagApplied = ((Registry)biomeRegistry.get()).getTag(oldTag);
                if (!oldTagApplied.isPresent() || ((HolderSet.Named)oldTagApplied.get()).size() <= 0) continue;
                Object message = "[%s] was deprecated now, please use [%s] instead.".formatted(oldTag.location(), tagKey.location());
                message = (String)message + "\nBiome list: " + String.join((CharSequence)",", ((HolderSet.Named)oldTagApplied.get()).stream().map(h -> h.unwrapKey().map(ResourceKey::location).map(ResourceLocation::toString).orElse(null)).filter(Objects::nonNull).toList());
                EclipticSeasons.LOGGER.error((String)message);
            }
        }
        BiomeClimateManager.applyBiomeTags(registryAccess, isServer ? BIOME_TAG_KEY_MAP : CLIENT_BIOME_TAG_KEY_MAP, new HashSet<TagKey<Biome>>(ClimateTypeBiomeTags.BIOME_TYPES), ClimateTypeFilters.BIOME_PRESENT, holder -> {
            int size = ClimateTypeBiomeTags.COMMON_BIOME_TYPES.size();
            int index = Mth.clamp((int)Mth.floor((float)(((Biome)holder.value()).getModifiedClimateSettings().downfall() * (float)size)), (int)0, (int)(size - 1));
            if (!((Biome)holder.value()).getModifiedClimateSettings().hasPrecipitation()) {
                index = 0;
            }
            return ClimateTypeBiomeTags.COMMON_BIOME_TYPES.get(index);
        }, (biome, tag) -> ((IBiomeTagHolder)biome).eclipticseasons$setTag((TagKey<Biome>)tag));
    }

    public static void applyBiomeTags(RegistryAccess registryAccess, Set<TagKey<Biome>> knownTags, Map<TagKey<Biome>, RegistryFilter<Biome>> filters) {
        BiomeClimateManager.applyBiomeTags(registryAccess, new IdentityHashMap<Biome, TagKey<Biome>>(), knownTags, filters, holder -> null, (biome, tag) -> {});
    }

    public static void applyBiomeTags(RegistryAccess registryAccess, Map<Biome, TagKey<Biome>> useMap, Set<TagKey<Biome>> knownTags, Map<TagKey<Biome>, RegistryFilter<Biome>> filters, Function<Holder<Biome>, TagKey<Biome>> defaultTag, BiConsumer<Biome, TagKey<Biome>> callback) {
        useMap.clear();
        Optional biomeRegistry = registryAccess.registry(Registries.BIOME);
        if (biomeRegistry.isEmpty()) {
            return;
        }
        Registry registry = (Registry)biomeRegistry.get();
        HashSet<Holder.Reference> biomeNotSet = new HashSet<Holder.Reference>();
        for (Holder.Reference reference : registry.holders().toList()) {
            Optional<TagKey> tag = knownTags.stream().filter(arg_0 -> ((Holder.Reference)reference).is(arg_0)).findFirst();
            if (tag.isPresent()) {
                useMap.put((Biome)reference.value(), (TagKey<Biome>)((TagKey)tag.get()));
                continue;
            }
            biomeNotSet.add(reference);
        }
        for (Map.Entry entry : filters.entrySet()) {
            for (Holder holder : ((RegistryFilter)entry.getValue()).toHolders(registry)) {
                useMap.putIfAbsent((Biome)holder.value(), (TagKey<Biome>)((TagKey)entry.getKey()));
                biomeNotSet.remove(holder);
            }
        }
        for (Holder holder : biomeNotSet) {
            TagKey<Biome> apply = defaultTag.apply((Holder<Biome>)holder);
            if (apply == null) continue;
            useMap.put((Biome)holder.value(), apply);
        }
        useMap.forEach(callback);
        BiomeClimateManager.updateTagInVanilla(knownTags, useMap, (Registry<Biome>)registry);
    }

    public static void updateTagInVanilla(Set<TagKey<Biome>> biomeTypes, Map<Biome, TagKey<Biome>> useMap, Registry<Biome> biomeRegistry) {
        if (((Boolean)CommonConfig.Debug.disableUniqueRebindingBiomeTags.get()).booleanValue()) {
            return;
        }
        Map<TagKey, List> biomeMap = biomeRegistry.getTags().filter(p -> !biomeTypes.contains(p.getFirst())).collect(Collectors.toMap(Pair::getFirst, p -> ((HolderSet.Named)p.getSecond()).stream().toList()));
        useMap.forEach((biome, biomeTagKey) -> {
            Holder<Biome> holder = BiomeClimateManager.getHolder(biomeRegistry, biome);
            if (holder != null) {
                List holders = biomeMap.computeIfAbsent((TagKey)biomeTagKey, b -> new ArrayList());
                holders.add(holder);
            }
        });
        biomeRegistry.bindTags(biomeMap);
    }

    public static void clearOnClientExitOrServerClose() {
        WEATHER_REGION_MAP.clear();
        BIOME_CLIMATE_MAP.clear();
        SMALL_BIOME_MAP.clear();
        BIOME_TAG_KEY_MAP.clear();
        CLIENT_CLIMATE_MAP.clear();
        CLIENT_BIOME_TAG_KEY_MAP.clear();
        SEASON_PHASE_MAP.clear();
        CLIENT_SEASON_PHASE_MAP.clear();
        CUSTOME_BIOME_RAIN_MAP.clear();
        CLIENT_CUSTOME_BIOME_RAIN_MAP.clear();
        CUSTOM_SNOW_TERM_MAP.clear();
        CLIENT_CUSTOM_SNOW_TERM_MAP.clear();
        BIOME_COLOR_TAG_KEY_MAP.clear();
        CLIENT_BIOME_COLOR_TAG_KEY_MAP.clear();
    }

    public static boolean isServerInstance(Biome value) {
        return BIOME_CLIMATE_MAP.containsKey(value);
    }
}

