/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.core.crop;

import com.teamtea.eclipticseasons.api.constant.crop.CropHumidityInfo;
import com.teamtea.eclipticseasons.api.constant.crop.CropHumidityType;
import com.teamtea.eclipticseasons.api.constant.crop.CropSeasonInfo;
import com.teamtea.eclipticseasons.api.constant.crop.CropSeasonType;
import com.teamtea.eclipticseasons.api.constant.tag.ESItemTags;
import com.teamtea.eclipticseasons.api.constant.tag.EclipticBlockTags;
import com.teamtea.eclipticseasons.api.event.RegisterAndModifyCropInfoEvent;
import com.teamtea.eclipticseasons.common.core.crop.internal.CompatCropHookInternal;
import com.teamtea.eclipticseasons.compat.CompatModule;
import com.teamtea.eclipticseasons.config.CommonConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.TagsUpdatedEvent;

public final class CropInfoManager {
    static final Map<Block, CropHumidityInfo> CROP_HUMIDITY_INFO = new HashMap<Block, CropHumidityInfo>();
    static final Map<Block, CropSeasonInfo> CROP_SEASON_INFO = new HashMap<Block, CropSeasonInfo>();
    static final Map<Item, CropHumidityInfo> ITEM_CROP_HUMIDITY_INFO = new HashMap<Item, CropHumidityInfo>();
    static final Map<Item, CropSeasonInfo> ITEM_CROP_SEASON_INFO = new HashMap<Item, CropSeasonInfo>();

    public static TagKey<Item> createItemTag(String modId, String path) {
        return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modId, (String)path));
    }

    public static TagKey<Block> createBlockTag(String modId, String path) {
        return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modId, (String)path));
    }

    public static CropSeasonType getCropSeasonTypeFrom(CropSeasonInfo cropSeasonInfo) {
        for (CropSeasonType value : CropSeasonType.collectValues()) {
            if (!value.getInfo().equals(cropSeasonInfo)) continue;
            return value;
        }
        return null;
    }

    public static CropHumidityType getCropHumidityTypeFrom(CropHumidityInfo cropSeasonInfo) {
        for (CropHumidityType value : CropHumidityType.collectValues()) {
            if (!value.getInfo().equals(cropSeasonInfo)) continue;
            return value;
        }
        return null;
    }

    public static void init(TagsUpdatedEvent event) {
        CROP_HUMIDITY_INFO.clear();
        CROP_SEASON_INFO.clear();
        Optional items = event.getRegistryAccess().registry(Registries.ITEM);
        Optional blocks = event.getRegistryAccess().registry(Registries.BLOCK);
        if (blocks.isPresent()) {
            Optional tagBlocks;
            for (CropHumidityType cropHumidityType : CropHumidityType.collectValues()) {
                tagBlocks = ((Registry)blocks.get()).getTag(cropHumidityType.getBlockTag());
                tagBlocks.ifPresent(holders -> holders.stream().forEach(action -> CropInfoManager.registerCropHumidityInfo((Block)action.value(), cropHumidityType, true)));
            }
            for (Enum enum_ : CropSeasonType.collectValues()) {
                tagBlocks = ((Registry)blocks.get()).getTag(((CropSeasonType)enum_).getBlockTag());
                tagBlocks.ifPresent(arg_0 -> CropInfoManager.lambda$init$3((CropSeasonType)enum_, arg_0));
            }
        }
        if (items.isPresent()) {
            Optional tagItems;
            for (Enum enum_ : CropHumidityType.collectValues()) {
                tagItems = ((Registry)items.get()).getTag(((CropHumidityType)enum_).getTag());
                tagItems.ifPresent(arg_0 -> CropInfoManager.lambda$init$5((CropHumidityType)enum_, arg_0));
            }
            for (Enum enum_ : CropSeasonType.collectValues()) {
                tagItems = ((Registry)items.get()).getTag(((CropSeasonType)enum_).getTag());
                tagItems.ifPresent(arg_0 -> CropInfoManager.lambda$init$7((CropSeasonType)enum_, arg_0));
            }
        }
        if (CompatModule.CommonConfig.sereneSeasons.getAsBoolean()) {
            CompatCropHookInternal.registerForSS(items, Registries.ITEM);
            CompatCropHookInternal.registerForSS(blocks, Registries.BLOCK);
            CompatCropHookInternal.registerForSSALL(items, blocks);
        }
        if (CommonConfig.Crop.registerCropDefaultValue.getAsBoolean()) {
            BuiltInRegistries.BLOCK.forEach(block -> {
                if (block instanceof CropBlock) {
                    CropInfoManager.registerCropHumidityInfo(block, CropHumidityType.AVERAGE_MOIST, true);
                    CropInfoManager.registerCropSeasonInfo(block, CropSeasonType.SP_SU_AU, true);
                }
            });
        }
        NeoForge.EVENT_BUS.post((Event)new RegisterAndModifyCropInfoEvent(CROP_HUMIDITY_INFO, CROP_SEASON_INFO));
        CropInfoManager.removeBlockAndItemShouldBeIgnored(blocks, items);
    }

    private static void removeBlockAndItemShouldBeIgnored(Optional<Registry<Block>> blocks, Optional<Registry<Item>> items) {
        if (blocks.isPresent() && items.isPresent()) {
            blocks.get().getTag(EclipticBlockTags.UNAFFECTED_BY_SEASONS).ifPresent(tag -> tag.forEach(holder -> CropInfoManager.clearCropInfo((Block)holder.value(), ((Block)holder.value()).asItem())));
            blocks.get().getTag(EclipticBlockTags.UNAFFECTED_BY_HUMIDITY).ifPresent(tag -> tag.forEach(holder -> CropInfoManager.clearCropInfo((Block)holder.value(), ((Block)holder.value()).asItem())));
            items.get().getTag(ESItemTags.UNAFFECTED_BY_SEASONS).ifPresent(tag -> tag.forEach(holder -> CropInfoManager.clearCropInfo(Block.byItem((Item)((Item)holder.value())), (Item)holder.value())));
            items.get().getTag(ESItemTags.UNAFFECTED_BY_HUMIDITY).ifPresent(tag -> tag.forEach(holder -> CropInfoManager.clearCropInfo(Block.byItem((Item)((Item)holder.value())), (Item)holder.value())));
        }
    }

    private static void clearCropInfo(Block block, Item item) {
        if (block != Blocks.AIR) {
            CROP_SEASON_INFO.remove(block);
            CROP_HUMIDITY_INFO.remove(block);
        }
        if (item != Items.AIR) {
            ITEM_CROP_SEASON_INFO.remove(item);
            ITEM_CROP_HUMIDITY_INFO.remove(item);
        }
    }

    public static void registerCropHumidityInfo(Item item, CropHumidityType info) {
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            CropInfoManager.registerCropHumidityInfo(blockItem.getBlock(), info, false);
        }
        if (!ITEM_CROP_HUMIDITY_INFO.containsKey(item)) {
            ITEM_CROP_HUMIDITY_INFO.put(item, info.getInfo());
        }
    }

    public static void registerCropHumidityInfo(Block block, CropHumidityType info, boolean force) {
        if (!CROP_HUMIDITY_INFO.containsKey(block)) {
            CROP_HUMIDITY_INFO.put(block, info.getInfo());
        }
    }

    public static void registerCropSeasonInfo(Item item, CropSeasonType info) {
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            CropInfoManager.registerCropSeasonInfo(blockItem.getBlock(), info, false);
        }
        if (!ITEM_CROP_SEASON_INFO.containsKey(item)) {
            ITEM_CROP_SEASON_INFO.put(item, info.getInfo());
        }
    }

    public static void registerCropSeasonInfo(Block block, CropSeasonType info, boolean force) {
        if (!CROP_SEASON_INFO.containsKey(block)) {
            CROP_SEASON_INFO.put(block, info.getInfo());
        }
    }

    public static Collection<Block> getHumidityCrops() {
        return CROP_HUMIDITY_INFO.keySet();
    }

    public static Collection<Block> getSeasonCrops() {
        return CROP_SEASON_INFO.keySet();
    }

    @Nullable
    public static CropHumidityInfo getHumidityInfo(Block crop) {
        return CROP_HUMIDITY_INFO.get(crop);
    }

    @Nullable
    public static CropSeasonInfo getSeasonInfo(Block crop) {
        return CROP_SEASON_INFO.get(crop);
    }

    @Nullable
    public static CropHumidityInfo getHumidityInfo(Item crop) {
        return ITEM_CROP_HUMIDITY_INFO.get(crop);
    }

    @Nullable
    public static CropSeasonInfo getSeasonInfo(Item crop) {
        return ITEM_CROP_SEASON_INFO.get(crop);
    }

    public static List<Component> appendInfo(Block block) {
        Object info;
        ArrayList<Component> toolTip = new ArrayList<Component>();
        if (((Boolean)CommonConfig.Crop.enableCropHumidityControl.get()).booleanValue() && CropInfoManager.getHumidityCrops().contains(block) && (info = CropInfoManager.getHumidityInfo(block)) != null) {
            toolTip.addAll(((CropHumidityInfo)info).getTooltip());
        }
        if (((Boolean)CommonConfig.Crop.enableCrop.get()).booleanValue() && CropInfoManager.getSeasonCrops().contains(block) && (info = CropInfoManager.getSeasonInfo(block)) != null) {
            toolTip.addAll(((CropSeasonInfo)info).getTooltip());
        }
        return toolTip;
    }

    public static List<Component> appendInfo(Item item) {
        Object info;
        ArrayList<Component> toolTip = new ArrayList<Component>();
        if (((Boolean)CommonConfig.Crop.enableCropHumidityControl.get()).booleanValue() && ITEM_CROP_HUMIDITY_INFO.containsKey(item) && (info = CropInfoManager.getHumidityInfo(item)) != null) {
            toolTip.addAll(((CropHumidityInfo)info).getTooltip());
        }
        if (((Boolean)CommonConfig.Crop.enableCrop.get()).booleanValue() && ITEM_CROP_SEASON_INFO.containsKey(item) && (info = CropInfoManager.getSeasonInfo(item)) != null) {
            toolTip.addAll(((CropSeasonInfo)info).getTooltip());
        }
        return toolTip;
    }

    private static /* synthetic */ void lambda$init$7(CropSeasonType cropSeasonType, HolderSet.Named holders) {
        holders.stream().forEach(action -> CropInfoManager.registerCropSeasonInfo((Item)action.value(), cropSeasonType));
    }

    private static /* synthetic */ void lambda$init$5(CropHumidityType cropHumidityType, HolderSet.Named holders) {
        holders.stream().forEach(action -> CropInfoManager.registerCropHumidityInfo((Item)action.value(), cropHumidityType));
    }

    private static /* synthetic */ void lambda$init$3(CropSeasonType cropSeasonType, HolderSet.Named holders) {
        holders.stream().forEach(action -> CropInfoManager.registerCropSeasonInfo((Block)action.value(), cropSeasonType, true));
    }
}

