/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.core.crop;

import com.mojang.datafixers.util.Pair;
import com.teamtea.eclipticseasons.api.misc.IUnpackablePalettedContainer;
import com.teamtea.eclipticseasons.config.CommonConfig;
import com.teamtea.eclipticseasons.mixin.common.chunk.MixinAccessorLevelChunkSection;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;

public class GreenHouseAir {
    public static final int MAX_DISTANCE = 31;
    public static final LevelChunkSectionWarp EMPTY_SECTION = new LevelChunkSectionWarp(new BlockState[0], new BitSet(), null);
    public final BlockPos blockPos;
    public final BlockState blockState;
    public final int distance;
    public final GreenHouseAir parent;
    public final BlockPos origin;
    public final BlockEntity originCenter;

    public GreenHouseAir(BlockPos blockPos, BlockState blockState, int distance, GreenHouseAir parent, BlockPos origin, BlockEntity originCenter) {
        this.blockPos = blockPos;
        this.blockState = blockState;
        this.distance = distance;
        this.parent = parent;
        this.origin = origin;
        this.originCenter = originCenter;
    }

    public static GreenHouseScanResult startBFS(LevelChunkSectionProvider levelChunkSectionProvider, BlockPos corePos, BlockState coreState, BlockEntity coreEntity) {
        boolean isClosed;
        int MAX_XZ = (Integer)CommonConfig.Crop.greenHouseMaxDiameter.get() * 2;
        int MAX_Y = (Integer)CommonConfig.Crop.greenHouseMaxHeight.get() * 2;
        int MAX_DISTANCE = MAX_XZ * 2 + MAX_Y;
        Long2ObjectOpenHashMap greenhouseMap = new Long2ObjectOpenHashMap(9600);
        ArrayDeque<GreenHouseAir> queue = new ArrayDeque<GreenHouseAir>();
        SectionQueryContext context = new SectionQueryContext();
        int leakCount = 0;
        int MAX_LEAKS = 3;
        LongOpenHashSet outerBoundaryPositions = new LongOpenHashSet();
        GreenHouseAir root = new GreenHouseAir(corePos, coreState, 0, null, corePos, coreEntity);
        queue.add(root);
        Direction[] values = Direction.values();
        while (!queue.isEmpty()) {
            GreenHouseAir current = (GreenHouseAir)queue.poll();
            BlockPos pos = current.blockPos;
            if (!context.addVisited(levelChunkSectionProvider, pos)) continue;
            long longPos = pos.asLong();
            greenhouseMap.put(longPos, (Object)current);
            for (int i = 0; i < values.length; ++i) {
                BlockState nextState;
                Direction dir = values[i];
                BlockPos nextPos = pos.relative(dir);
                if (context.containsVisited(levelChunkSectionProvider, nextPos) || !GreenHouseAir.canGreenHouseAirThrough(nextState = context.getBlockState(levelChunkSectionProvider, nextPos))) continue;
                int nextDistance = current.distance + 1;
                if (Mth.abs((int)(nextPos.getX() - corePos.getX())) > MAX_XZ || Mth.abs((int)(nextPos.getY() - corePos.getY())) > MAX_XZ || Mth.abs((int)(nextPos.getZ() - corePos.getZ())) > MAX_Y) {
                    leakCount = 4;
                    break;
                }
                if (nextDistance > MAX_DISTANCE) {
                    if (++leakCount <= 3) continue;
                    break;
                }
                GreenHouseAir next = new GreenHouseAir(nextPos, nextState, nextDistance, current, corePos, coreEntity);
                queue.add(next);
            }
            if (leakCount <= 3) continue;
            break;
        }
        context.release();
        levelChunkSectionProvider.close();
        boolean bl = isClosed = leakCount <= 3;
        if (!isClosed) {
            return new GreenHouseScanResult(isClosed, (Long2ObjectOpenHashMap<GreenHouseAir>)new Long2ObjectOpenHashMap(), new LongOpenHashSet());
        }
        return new GreenHouseScanResult(isClosed, (Long2ObjectOpenHashMap<GreenHouseAir>)greenhouseMap, outerBoundaryPositions);
    }

    private static boolean canGreenHouseAirThrough(BlockState state) {
        if (state.isSolid()) {
            return state.getBlock() instanceof LeavesBlock || state.getBlock() instanceof StainedGlassBlock;
        }
        if (state.isAir()) {
            return true;
        }
        return true;
    }

    public static BlockState[] getLevelChunkSection(LevelChunkSection section) {
        return IUnpackablePalettedContainer.of(((MixinAccessorLevelChunkSection)section).es$getStates()).eclipticseasons$unpack(BlockState.class);
    }

    public static void scanAsync(Level level, BlockPos origin, BlockEntity coreEntity, Consumer<GreenHouseScanResult> callback) {
        int maxR = (Integer)CommonConfig.Crop.greenHouseMaxDiameter.get();
        int maxH = (Integer)CommonConfig.Crop.greenHouseMaxHeight.get();
        Long2ObjectOpenHashMap secMap = new Long2ObjectOpenHashMap();
        SectionPos center = SectionPos.of((BlockPos)origin);
        int xzOff = (maxR + 16) / 16;
        int yOff = (maxH + 16) / 16;
        for (int i = -xzOff; i < xzOff + 1; ++i) {
            int cx = center.x() + i;
            for (int j = -xzOff; j < xzOff + 1; ++j) {
                int cz = center.z() + j;
                LevelChunk levelChunk = level.getChunk(cx, cz);
                for (int k = -yOff; k < yOff + 1; ++k) {
                    int cy = center.y() + k;
                    int sectionIndex = levelChunk.getSectionIndexFromSectionY(cy);
                    LevelChunkSection[] sections = levelChunk.getSections();
                    if (sectionIndex < 0 || sectionIndex >= sections.length) continue;
                    LevelChunkSection section = sections[sectionIndex];
                    secMap.put(SectionPos.asLong((int)cx, (int)cy, (int)cz), (Object)((MixinAccessorLevelChunkSection)section).es$getStates().copy());
                }
            }
        }
        PalettedGetter palettedGetter = new PalettedGetter((Long2ObjectOpenHashMap<PalettedContainer<BlockState>>)secMap);
        CompletableFuture.supplyAsync(() -> GreenHouseAir.startBFS(palettedGetter, origin, coreEntity.getBlockState(), coreEntity)).thenAcceptAsync((Consumer)callback, (Executor)level.getServer());
    }

    public static class SectionQueryContext {
        public final List<Pair<SectionPos, LevelChunkSectionWarp>> chunkAccessList = new ArrayList<Pair<SectionPos, LevelChunkSectionWarp>>(1);
        private SectionPos lastPos;
        private LevelChunkSectionWarp lastWarp;

        public LevelChunkSectionWarp getSectionCache(@Nullable LevelChunkSectionProvider levelAccessor, BlockPos pos) {
            int x = SectionPos.blockToSectionCoord((int)pos.getX());
            int z = SectionPos.blockToSectionCoord((int)pos.getZ());
            int y = SectionPos.blockToSectionCoord((int)pos.getY());
            if (this.lastPos != null && this.lastPos.x() == x && this.lastPos.z() == z && this.lastPos.y() == y && this.lastWarp != null) {
                return this.lastWarp;
            }
            LevelChunkSectionWarp section = this.getSection(levelAccessor, x, y, z);
            if (section != EMPTY_SECTION) {
                this.lastPos = SectionPos.of((int)x, (int)y, (int)z);
                this.lastWarp = section;
            } else {
                this.lastPos = null;
                this.lastWarp = null;
            }
            return section;
        }

        @Nullable
        public LevelChunkSectionWarp getSection(int x, int y, int z) {
            int size = this.chunkAccessList.size();
            for (int i = 0; i < size; ++i) {
                Pair<SectionPos, LevelChunkSectionWarp> chunkAccess = this.chunkAccessList.get(i);
                SectionPos first = (SectionPos)chunkAccess.getFirst();
                if (first.x() != x || first.z() != z || first.y() != y) continue;
                return (LevelChunkSectionWarp)chunkAccess.getSecond();
            }
            return null;
        }

        public LevelChunkSectionWarp getSection(@Nullable LevelChunkSectionProvider levelAccessor, int x, int y, int z) {
            LevelChunkSectionWarp section = this.getSection(x, y, z);
            if (section != null) {
                return section;
            }
            if (levelAccessor == null) {
                return EMPTY_SECTION;
            }
            LevelChunkSectionWarp levelChunkSectionWarp = levelAccessor.get(x, y, z);
            this.chunkAccessList.add((Pair<SectionPos, LevelChunkSectionWarp>)Pair.of((Object)SectionPos.of((int)x, (int)y, (int)z), (Object)levelChunkSectionWarp));
            return levelChunkSectionWarp;
        }

        public BlockState getBlockState(LevelChunkSectionProvider levelAccessor, BlockPos pos) {
            return this.getSectionCache(levelAccessor, pos).getBlockState(pos.getX() & 0xF, pos.getY() & 0xF, pos.getZ() & 0xF);
        }

        public void release() {
            this.chunkAccessList.clear();
            this.lastPos = null;
            this.lastWarp = null;
        }

        public boolean addVisited(LevelChunkSectionProvider levelAccessor, BlockPos pos) {
            return this.getSectionCache(levelAccessor, pos).addAndCheckAccess(pos.getX() & 0xF, pos.getY() & 0xF, pos.getZ() & 0xF);
        }

        public boolean containsVisited(LevelChunkSectionProvider levelAccessor, BlockPos pos) {
            return this.getSectionCache(levelAccessor, pos).contains(pos.getX() & 0xF, pos.getY() & 0xF, pos.getZ() & 0xF);
        }
    }

    public static interface LevelChunkSectionProvider
    extends AutoCloseable {
        public LevelChunkSectionWarp get(int var1, int var2, int var3);

        @Override
        default public void close() {
        }
    }

    public record GreenHouseScanResult(boolean isClosed, Long2ObjectOpenHashMap<GreenHouseAir> airMap, LongOpenHashSet outerBoundaryPositions) {
    }

    public record PalettedGetter(Long2ObjectOpenHashMap<PalettedContainer<BlockState>> levelReader) implements LevelChunkSectionProvider
    {
        @Override
        public LevelChunkSectionWarp get(int x, int y, int z) {
            PalettedContainer orDefault = (PalettedContainer)this.levelReader.getOrDefault(SectionPos.asLong((int)x, (int)y, (int)z), null);
            return orDefault == null ? EMPTY_SECTION : LevelChunkSectionWarp.of((PalettedContainer<BlockState>)orDefault);
        }

        @Override
        public void close() {
            this.levelReader.clear();
        }
    }

    public record LevelChunkSectionWarp(BlockState[] states, BitSet bitSet, @Nullable LevelChunkSection section) {
        static LevelChunkSectionWarp of(LevelChunkSection section) {
            BlockState[] bsA = GreenHouseAir.getLevelChunkSection(section);
            BitSet bitSet1 = new BitSet(bsA.length);
            return new LevelChunkSectionWarp(bsA, bitSet1, section);
        }

        static LevelChunkSectionWarp of(PalettedContainer<BlockState> section) {
            BlockState[] bsA = IUnpackablePalettedContainer.of(section).eclipticseasons$unpack(BlockState.class);
            BitSet bitSet1 = new BitSet(bsA.length);
            return new LevelChunkSectionWarp(bsA, bitSet1, null);
        }

        static int getLocalIndex(int x, int y, int z) {
            return y << 4 << 4 | z << 4 | x;
        }

        public BlockState getBlockState(int x, int y, int z) {
            if (this.states.length == 0) {
                return Blocks.AIR.defaultBlockState();
            }
            return this.states[LevelChunkSectionWarp.getLocalIndex(x, y, z)];
        }

        public boolean addAndCheckAccess(int x, int y, int z) {
            if (this.states.length == 0) {
                return false;
            }
            int index = LevelChunkSectionWarp.getLocalIndex(x, y, z);
            if (this.bitSet.get(index)) {
                return false;
            }
            this.bitSet.set(index);
            return true;
        }

        public boolean contains(int x, int y, int z) {
            if (this.states.length == 0) {
                return false;
            }
            int index = LevelChunkSectionWarp.getLocalIndex(x, y, z);
            return this.bitSet.get(index);
        }
    }

    public record LevelReaderGetter(LevelReader levelReader) implements LevelChunkSectionProvider
    {
        @Override
        public LevelChunkSectionWarp get(int x, int y, int z) {
            ChunkAccess chunk1 = this.levelReader.getChunk(x, z);
            int sectionIndex = chunk1.getSectionIndexFromSectionY(y);
            LevelChunkSection[] sections = chunk1.getSections();
            if (sectionIndex < 0 || sectionIndex >= sections.length) {
                return EMPTY_SECTION;
            }
            LevelChunkSection chunk = sections[sectionIndex];
            return LevelChunkSectionWarp.of(chunk);
        }
    }
}

