/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.core.map;

import com.teamtea.eclipticseasons.EclipticSeasons;
import net.minecraft.core.BlockPos;

public class ChunkInfoMap {
    public static final int TYPE_BIOME = 1;
    public static final int TYPE_HEIGHT = 0;
    private final short[][] matrix = new short[512][512];
    private final short[][] biomes = new short[512][512];
    final int x;
    final int z;
    final short minY;
    final boolean isClient;

    public ChunkInfoMap(int x, int z, int minY, boolean isClient) {
        this.minY = (short)minY;
        this.isClient = isClient;
        this.x = x;
        this.z = z;
        EclipticSeasons.extraLogger(true, String.format("Create new Height Map with [%s, %s]", x, z));
        for (int i = 0; i < 512; ++i) {
            for (int j = 0; j < 512; ++j) {
                this.biomes[i][j] = -1;
                this.matrix[i][j] = this.minY;
            }
        }
        EclipticSeasons.extraLogger(true, String.format("End create [%s, %s]", x, z));
    }

    public static int getChunkValue(int i) {
        return i & 0x1FF;
    }

    public int getHeight(int x, int z) {
        x = ChunkInfoMap.getChunkValue(x);
        z = ChunkInfoMap.getChunkValue(z);
        return this.matrix[x][z];
    }

    public int getBiome(int x, int z) {
        x = ChunkInfoMap.getChunkValue(x);
        z = ChunkInfoMap.getChunkValue(z);
        return this.biomes[x][z];
    }

    public int getHeight(BlockPos pos) {
        return this.getHeight(pos.getX(), pos.getZ());
    }

    public int getBiome(BlockPos pos) {
        return this.getBiome(pos.getX(), pos.getZ());
    }

    public int updateHeight(int x, int z, int y) {
        x = ChunkInfoMap.getChunkValue(x);
        z = ChunkInfoMap.getChunkValue(z);
        short old = this.matrix[x][z];
        this.matrix[x][z] = (short)y;
        return old;
    }

    public int updateBiome(int x, int z, int id) {
        x = ChunkInfoMap.getChunkValue(x);
        z = ChunkInfoMap.getChunkValue(z);
        short old = this.biomes[x][z];
        this.biomes[x][z] = (short)id;
        return old;
    }

    public int updateBiome(BlockPos pos, int id) {
        return this.updateBiome(pos.getX(), pos.getZ(), id);
    }

    public int updateHeight(BlockPos pos, int y) {
        return this.updateHeight(pos.getX(), pos.getZ(), y);
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public short getMinY() {
        return this.minY;
    }
}

