/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.core.snow;

import com.mojang.datafixers.util.Pair;
import com.teamtea.eclipticseasons.api.misc.IChunkBiomeHolder;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.common.core.map.BiomeHolder;
import com.teamtea.eclipticseasons.common.core.map.ChunkInfoMap;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import com.teamtea.eclipticseasons.common.core.snow.SnowyStatusKeeper;
import com.teamtea.eclipticseasons.common.core.snow.WeatherStatusKeeper;
import com.teamtea.eclipticseasons.common.registry.AttachmentRegistry;
import com.teamtea.eclipticseasons.config.CommonConfig;
import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.NotNull;

public class SnowyMapChecker {
    @NotNull
    public static WeatherStatusKeeper getWeatherStatusKeeper(ChunkAccess chunk) {
        return (WeatherStatusKeeper)chunk.getData(AttachmentRegistry.WEATHER_STATUS_KEEPER);
    }

    @NotNull
    public static SnowyStatusKeeper getSnowyStatusKeeper(ChunkAccess chunk) {
        return (SnowyStatusKeeper)chunk.getData(AttachmentRegistry.SNOWY_STATUS_KEEPER);
    }

    @NotNull
    public static SnowyStatusKeeper getSnowyStatusKeeperCopy(LevelChunk chunk) {
        if (!EclipticUtil.canSnowyBlockInteract()) {
            return SnowyStatusKeeper.EMPTY;
        }
        return SnowyMapChecker.getSnowyStatusKeeper((ChunkAccess)chunk);
    }

    public static void updatePos(Level level, LevelChunk chunk, BlockPos pos, BlockState state, BlockState oldState, Block block) {
        if (EclipticUtil.canSnowyBlockInteract()) {
            boolean blockDestroyOrReplace = false;
            if (state.isEmpty()) {
                blockDestroyOrReplace = true;
            } else if (MapChecker.solidTest(state)) {
                SnowyMapChecker.removeSnowyStatus(level, chunk, pos);
                SnowyMapChecker.removeSnowyStatus(level, chunk, pos.below());
            } else if (((Boolean)CommonConfig.Snow.snowyUnderSnowLike.get()).booleanValue() && state.is(BlockTags.SNOW)) {
                SnowyMapChecker.setSnowyStatus(level, chunk, pos.below());
            } else if (!oldState.is(block)) {
                blockDestroyOrReplace = true;
            }
            if (blockDestroyOrReplace) {
                SnowyMapChecker.removeSnowyStatus(level, chunk, pos);
                if (((Boolean)CommonConfig.Snow.snowyUnderSnowLike.get()).booleanValue() && oldState.is(BlockTags.SNOW)) {
                    SnowyMapChecker.removeSnowyStatus(level, chunk, pos.below());
                }
            }
        }
    }

    public static void updateAllChunks(ServerLevel level) {
        if (!EclipticUtil.canSnowyBlockInteract()) {
            return;
        }
        int biomeDataVersion = EclipticUtil.getBiomeDataVersion((Level)level);
        for (ChunkHolder chunk : level.getChunkSource().chunkMap.getChunks()) {
            ChunkAccess latestChunk = chunk.getLatestChunk();
            if (!(latestChunk instanceof IChunkBiomeHolder)) continue;
            IChunkBiomeHolder chunkBiomeHolder = (IChunkBiomeHolder)latestChunk;
            BiomeHolder biomeHolder = chunkBiomeHolder.eclipticseasons$getBiomeHolder();
            if (biomeHolder != null && biomeHolder.version() != biomeDataVersion) {
                biomeHolder = null;
            }
            SnowyMapChecker.forceChunkUpdateHeight(level, latestChunk, MapChecker.getChunkInfoMapOrCreate((Level)level, latestChunk.getPos()), biomeHolder, false);
        }
    }

    public static void removeSnowyStatus(ServerLevel level, BlockPos pos) {
        if (MapChecker.isLoaded((Level)level, pos)) {
            SnowyMapChecker.removeSnowyStatus((Level)level, level.getChunkAt(pos), pos);
        }
    }

    public static void removeSnowyStatus(Level level, LevelChunk chunk, BlockPos pos) {
        if (EclipticUtil.canSnowyBlockInteract()) {
            SnowyStatusKeeper keeper = SnowyMapChecker.getSnowyStatusKeeper((ChunkAccess)chunk);
            if (level.isClientSide) {
                keeper.set(pos.asLong(), 0);
            } else {
                keeper.set(pos, 0);
            }
        }
    }

    public static void setSnowyStatus(Level level, LevelChunk chunk, BlockPos pos) {
        if (EclipticUtil.canSnowyBlockInteract()) {
            SnowyStatusKeeper keeper = SnowyMapChecker.getSnowyStatusKeeper((ChunkAccess)chunk);
            if (level.isClientSide) {
                keeper.set(pos.asLong(), 1);
            } else {
                keeper.set(pos, 1);
            }
        }
    }

    public static void forceChunkUpdateHeight(ServerLevel level, ChunkAccess chunk, ChunkInfoMap chunkMap, @Nullable BiomeHolder biomeHolder, boolean loadingChunk) {
        if (!EclipticUtil.canSnowyBlockInteract() || !((Boolean)CommonConfig.Snow.forceChunkUpdate.get()).booleanValue()) {
            return;
        }
        ChunkPos chunkPos = chunk.getPos();
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos(chunkPos.getMinBlockX(), 0, chunkPos.getMinBlockZ());
        SnowyStatusKeeper keeper = SnowyMapChecker.getSnowyStatusKeeper(chunk);
        WeatherStatusKeeper weatherStatusKeeper = SnowyMapChecker.getWeatherStatusKeeper(chunk);
        boolean checkIfBiomeCacheAnyMore = false;
        Pair<Map<Holder<Biome>, IntIntImmutablePair>, Map<Holder<Biome>, Long>> biomeSnowyUpdate = weatherStatusKeeper.collectSnowyUpdate(level, biomeHolder);
        if (chunkMap != null) {
            for (int i = chunkPos.getMinBlockX(); i <= chunkPos.getMaxBlockX(); ++i) {
                for (int j = chunkPos.getMinBlockZ(); j <= chunkPos.getMaxBlockZ(); ++j) {
                    checkPos.setX(i);
                    checkPos.setZ(j);
                    int k = chunkMap.getHeight(i, j);
                    checkPos.setY(k);
                    checkIfBiomeCacheAnyMore = SnowyMapChecker.isCheckIfBiomeCacheAnyMore(level, chunk, biomeHolder, biomeSnowyUpdate, checkPos, keeper, weatherStatusKeeper, k);
                }
            }
        }
        SnowyMapChecker.postAfterChunkUpdate(level, chunk, keeper, weatherStatusKeeper, checkIfBiomeCacheAnyMore, loadingChunk);
    }

    private static boolean isCheckIfBiomeCacheAnyMore(ServerLevel level, ChunkAccess chunk, BiomeHolder biomeHolder, Pair<Map<Holder<Biome>, IntIntImmutablePair>, Map<Holder<Biome>, Long>> pair, BlockPos.MutableBlockPos checkPos, SnowyStatusKeeper keeper, WeatherStatusKeeper weatherStatusKeeper, int solidHeight) {
        Map biomeSnowyUpdate = (Map)pair.getFirst();
        Map rainUpdateMap = (Map)pair.getSecond();
        if (!biomeSnowyUpdate.isEmpty()) {
            boolean rainInMissingTime;
            Holder<Biome> biome = MapChecker.getSurfaceBiome((Level)level, (BlockPos)checkPos, biomeHolder);
            weatherStatusKeeper.getBiomeUse().add(biome);
            boolean bl = rainInMissingTime = rainUpdateMap == null || rainUpdateMap.containsKey(biome);
            if (rainInMissingTime) {
                IntIntImmutablePair snowDepthUse = biomeSnowyUpdate.getOrDefault(biome, null);
                int heightSurface = chunk.getHeight(Heightmap.Types.WORLD_SURFACE, checkPos.getX(), checkPos.getZ());
                for (int posH = solidHeight; posH <= heightSurface; ++posH) {
                    checkPos.setY(posH);
                    BlockState state = chunk.getBlockState((BlockPos)checkPos);
                    int flag = MapChecker.getDefaultBlockTypeFlag(state);
                    if (flag == 0) continue;
                    if (SnowyMapChecker.isTooLight((BlockAndTintGetter)level, (BlockPos)checkPos, state, flag)) {
                        keeper.set((BlockPos)checkPos, 0);
                        continue;
                    }
                    if (snowDepthUse == null) {
                        if (!MapChecker.isAboveSnowLine((Level)level, (Biome)biome.value(), (BlockPos)checkPos)) continue;
                        keeper.set((BlockPos)checkPos, 1);
                        continue;
                    }
                    if (snowDepthUse.rightInt() == 0) {
                        if ((long)snowDepthUse.leftInt() > Math.abs(state.getSeed((BlockPos)checkPos) % 100L) || MapChecker.isAboveSnowLine((Level)level, (Biome)biome.value(), (BlockPos)checkPos)) {
                            keeper.set((BlockPos)checkPos, 1);
                            continue;
                        }
                        keeper.set((BlockPos)checkPos, 0);
                        continue;
                    }
                    int cut = snowDepthUse.rightInt() + (snowDepthUse.leftInt() - snowDepthUse.rightInt()) / 4;
                    if (cut > 0) {
                        if ((long)cut <= Math.abs(state.getSeed((BlockPos)checkPos) % 100L) && !MapChecker.isAboveSnowLine((Level)level, (Biome)biome.value(), (BlockPos)checkPos)) continue;
                        keeper.set((BlockPos)checkPos, 1);
                        continue;
                    }
                    if ((long)(-cut) > Math.abs(state.getSeed((BlockPos)checkPos) % 100L)) continue;
                    keeper.set((BlockPos)checkPos, 0);
                }
            }
            return true;
        }
        return false;
    }

    private static void postAfterChunkUpdate(ServerLevel level, ChunkAccess chunk, SnowyStatusKeeper keeper, WeatherStatusKeeper weatherStatusKeeper, boolean checkIfBiomeCacheAnyMore, boolean loadingChunk) {
        boolean shouldClear;
        weatherStatusKeeper.updateSnowDepthRecord(level);
        keeper.checkPosValid(chunk);
        if (checkIfBiomeCacheAnyMore && (shouldClear = weatherStatusKeeper.getSnowDepthRecord().keySet().removeIf(holder -> !weatherStatusKeeper.getBiomeUse().contains(holder)))) {
            keeper.setChange();
        }
        if (!loadingChunk && chunk instanceof LevelChunk) {
            LevelChunk levelChunk = (LevelChunk)chunk;
            weatherStatusKeeper.updateAndSend(level, levelChunk);
            keeper.updateAndSend(level, levelChunk);
            keeper.getStepCount().clear();
        }
    }

    public static boolean isTooLight(BlockAndTintGetter level, BlockPos pos, BlockState state, int blockType) {
        return SnowyMapChecker.isTooLight(level, pos, null, state, blockType);
    }

    public static boolean isTooLight(BlockAndTintGetter level, BlockPos pos, @Nullable BlockPos.MutableBlockPos mutableBlockPos, BlockState state, int blockType) {
        if (((Boolean)CommonConfig.Snow.notSnowyNearGlowingBlock.get()).booleanValue()) {
            int aboveOffset = 1 - MapChecker.getSnowOffset(state, blockType);
            if (mutableBlockPos != null) {
                mutableBlockPos.setY(pos.getY() + aboveOffset);
                pos = mutableBlockPos;
            } else {
                pos = pos.above(aboveOffset);
            }
            return level.getBrightness(LightLayer.BLOCK, pos) >= (Integer)CommonConfig.Snow.notSnowyNearGlowingBlockLevel.get();
        }
        return false;
    }

    public static boolean shouldCheckSnowyStatus(Level level, BlockPos pos) {
        return EclipticUtil.canSnowyBlockInteract() && MapChecker.isLoaded(level, pos);
    }

    public static boolean isSnowyBlock(Level level, BlockPos pos) {
        return SnowyMapChecker.getSnowyStatusKeeper((ChunkAccess)level.getChunkAt(pos)).isSnowyBlock(pos);
    }

    public static boolean isSnowyBlock(SnowyStatusKeeper keeper, BlockPos pos) {
        return keeper.isSnowyBlock(pos);
    }

    public static void onEntityStepOn(Entity entity, Level level, BlockPos pos, BlockState blockstate) {
        if (!EclipticUtil.canSnowyBlockInteract()) {
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        if (!((Boolean)CommonConfig.Snow.stepMelt.get()).booleanValue()) {
            return;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (MapChecker.getDefaultBlockTypeFlag(blockstate) != 0 && level.getGameTime() % 8L == 0L && SnowyMapChecker.shouldCheckSnowyStatus((Level)serverLevel, pos)) {
                LevelChunk chunkAt = level.getChunkAt(pos);
                SnowyStatusKeeper keeper = SnowyMapChecker.getSnowyStatusKeeper((ChunkAccess)chunkAt);
                keeper.stepAndCheck(pos);
                BlockPos.MutableBlockPos above = pos.mutable();
                for (int count = 1; count < 4; ++count) {
                    int flagAbove;
                    above.setY(pos.getY() + count);
                    BlockState stateAbove = chunkAt.getBlockState((BlockPos)above);
                    if (stateAbove.isEmpty() || (flagAbove = MapChecker.getDefaultBlockTypeFlag(stateAbove)) == 0) break;
                    keeper.stepAndCheck((BlockPos)above);
                }
            }
        }
    }
}

