/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.core.snow;

import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.client.util.ClientCon;
import com.teamtea.eclipticseasons.common.core.snow.SnowyMapChecker;
import com.teamtea.eclipticseasons.common.core.snow.SnowyStatusKeeper;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.attachment.AttachmentSyncHandler;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SnowyStatusHandler
implements AttachmentSyncHandler<SnowyStatusKeeper> {
    public static final SnowyStatusHandler INSTANCE = new SnowyStatusHandler();

    public boolean sendToPlayer(IAttachmentHolder holder, ServerPlayer to) {
        return super.sendToPlayer(holder, to);
    }

    public void write(@NotNull RegistryFriendlyByteBuf buf, @NotNull SnowyStatusKeeper attachment, boolean initialSync) {
        if (!EclipticUtil.canSnowyBlockInteract()) {
            return;
        }
        buf.writeBoolean(initialSync);
        if (initialSync) {
            int size = attachment.getPosMap().size();
            buf.writeVarInt(size);
            attachment.getPosMap().forEach((k, v) -> {
                buf.writeLong(k.longValue());
                buf.writeVarInt(v.intValue());
            });
        } else {
            LongArrayList blockPosList = attachment.getPosListUpdate();
            IntArrayList integerList = attachment.getStatusListUpdate();
            int size = blockPosList.size();
            buf.writeVarInt(size);
            for (int i = 0; i < size; ++i) {
                buf.writeLong(blockPosList.getLong(i));
                buf.writeVarInt(integerList.getInt(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public SnowyStatusKeeper read(@NotNull IAttachmentHolder holder, @NotNull RegistryFriendlyByteBuf buf, @Nullable SnowyStatusKeeper previousValue) {
        if (!EclipticUtil.canSnowyBlockInteract()) {
            return previousValue;
        }
        boolean initialSync = buf.readBoolean();
        int size = buf.readVarInt();
        if (previousValue != null) {
            HashSet<SectionPos> set = new HashSet<SectionPos>();
            Long2IntLinkedOpenHashMap long2IntLinkedOpenHashMap = previousValue.getPosMap();
            synchronized (long2IntLinkedOpenHashMap) {
                for (int i = 0; i < size; ++i) {
                    long pos = buf.readLong();
                    int status = buf.readVarInt();
                    previousValue.set(pos, status);
                    set.add(SectionPos.of((BlockPos)BlockPos.of((long)pos)));
                }
            }
            for (SectionPos sectionPos : set) {
                ClientCon.agent.setChunkDirty(sectionPos);
            }
        } else if (holder instanceof LevelChunk) {
            LevelChunk chunk = (LevelChunk)holder;
            previousValue = SnowyMapChecker.getSnowyStatusKeeper((ChunkAccess)chunk);
            Long2IntLinkedOpenHashMap long2IntLinkedOpenHashMap = previousValue.getPosMap();
            synchronized (long2IntLinkedOpenHashMap) {
                for (int i = 0; i < size; ++i) {
                    long pos = buf.readLong();
                    int status = buf.readVarInt();
                    previousValue.set(pos, status);
                }
            }
        }
        return previousValue;
    }
}

