/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.core.solar;

import com.teamtea.eclipticseasons.common.core.SolarHolders;
import com.teamtea.eclipticseasons.common.core.solar.SolarDataManager;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelTimeAccess;

public class SolarAngelHelper {
    public static float getSeasonCelestialAngle(LevelTimeAccess world, long worldTime) {
        return SolarAngelHelper.getCelestialAngle(SolarAngelHelper.getSolarAngelTime(world, worldTime));
    }

    public static int getSolarAngelTime(LevelTimeAccess world, long worldTime) {
        Level level;
        SolarDataManager solarDataManager;
        if (world instanceof Level && (solarDataManager = SolarHolders.getSaveData(level = (Level)world)) instanceof SolarDataManager) {
            SolarDataManager data = solarDataManager;
            int dayLevelTime = Math.toIntExact((worldTime + 18000L) % 24000L);
            int dayTime = dayLevelTime > 12000 && dayLevelTime <= 18000 && data.isTodayLastDay() ? data.getNextSolarTerm().getDayTime() : data.getSolarTerm().getDayTime();
            int sunrise = 24000 - dayTime / 2;
            int sunset = dayTime / 2;
            int solarAngelTime = 0 <= dayLevelTime && dayLevelTime <= sunset ? 6000 + dayLevelTime * 6000 / sunset : (dayLevelTime > sunset && dayLevelTime <= sunrise ? 12000 + (dayLevelTime - sunset) * 12000 / (24000 - dayTime) : (dayLevelTime - sunrise) * 6000 / (24000 - sunrise));
            return solarAngelTime;
        }
        return Math.toIntExact(worldTime % 24000L);
    }

    public static float getCelestialAngle(long worldTime) {
        double d0 = Mth.frac((double)((double)worldTime / 24000.0 - 0.25));
        double d1 = 0.5 - Math.cos(d0 * Math.PI) / 2.0;
        return (float)(d0 * 2.0 + d1) / 3.0f;
    }
}

