/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.handler;

import com.teamtea.eclipticseasons.api.misc.CustomRandomTick2;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.common.core.biome.WeatherManager;
import com.teamtea.eclipticseasons.config.CommonConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public final class CustomRandomTickHandler {
    public static final CustomRandomTick2 SNOW_MELT_2 = (level, biomeHolder, pos) -> {
        if (WeatherManager.getSnowStatus(level, (Holder<Biome>)biomeHolder, pos, EclipticUtil.isRainingOrSnowingWithSurfaceBiome((Level)level, (Holder<Biome>)biomeHolder, pos)) == WeatherManager.SnowRenderStatus.SNOW_MELT) {
            BlockState belowState;
            BlockState topState = level.getBlockState(pos);
            if (topState.is(Blocks.SNOW)) {
                int layer = (Integer)topState.getValue((Property)SnowLayerBlock.LAYERS);
                level.setBlockAndUpdate(pos, layer <= 2 ? Blocks.AIR.defaultBlockState() : (BlockState)topState.setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(layer - 2)));
            }
            if ((belowState = level.getBlockState(pos.below())).is(Blocks.ICE)) {
                if (level.dimensionType().ultraWarm()) {
                    level.removeBlock(pos, false);
                } else {
                    level.setBlockAndUpdate(pos.below(), Blocks.WATER.defaultBlockState());
                }
            }
        }
    };
    @Deprecated
    public static final CustomRandomTick2 SNOW_MELT = (level, biomeHolder, pos) -> {
        if (WeatherManager.getSnowStatus(level, (Holder<Biome>)biomeHolder, pos, EclipticUtil.isRainingOrSnowingWithSurfaceBiome((Level)level, (Holder<Biome>)biomeHolder, pos)) == WeatherManager.SnowRenderStatus.SNOW) {
            BlockPos below;
            BlockState blockstate;
            int layers;
            if (pos.getY() >= level.getMinBuildHeight() && pos.getY() < level.getMaxBuildHeight() && level.getBrightness(LightLayer.BLOCK, pos) < 10 && (layers = level.getGameRules().getInt(GameRules.RULE_SNOW_ACCUMULATION_HEIGHT)) > 0) {
                blockstate = level.getBlockState(pos);
                if (blockstate.is(Blocks.SNOW)) {
                    int k = (Integer)blockstate.getValue((Property)SnowLayerBlock.LAYERS);
                    if (k < Math.min(layers, 8)) {
                        BlockState snowState = (BlockState)blockstate.setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(k + 1));
                        Block.pushEntitiesUp((BlockState)blockstate, (BlockState)snowState, (LevelAccessor)level, (BlockPos)pos);
                        level.setBlockAndUpdate(pos, snowState);
                    }
                } else {
                    level.setBlockAndUpdate(pos, Blocks.SNOW.defaultBlockState());
                }
            }
            if ((below = pos.below()).getY() >= level.getMinBuildHeight() && below.getY() < level.getMaxBuildHeight() && level.getBrightness(LightLayer.BLOCK, below) < 10) {
                blockstate = level.getBlockState(below);
                FluidState fluidstate = level.getFluidState(below);
                if (fluidstate.getType() == Fluids.WATER && blockstate.getBlock() instanceof LiquidBlock) {
                    boolean flag;
                    boolean bl = flag = level.isWaterAt(below.west()) && level.isWaterAt(below.east()) && level.isWaterAt(below.north()) && level.isWaterAt(below.south());
                    if (!flag) {
                        level.setBlockAndUpdate(below, Blocks.ICE.defaultBlockState());
                    }
                }
            }
        }
    };

    public static boolean checkExtraSnowCondition(ServerLevel level, Holder<Biome> biomeHolder, BlockPos pos) {
        if (((Boolean)CommonConfig.Temperature.snowDown.get()).booleanValue() && WeatherManager.getSnowStatus(level, biomeHolder, pos, EclipticUtil.isRainingOrSnowingWithSurfaceBiome((Level)level, biomeHolder, pos)) == WeatherManager.SnowRenderStatus.SNOW) {
            BlockState blockstate;
            return pos.getY() >= level.getMinBuildHeight() && pos.getY() < level.getMaxBuildHeight() && level.getBrightness(LightLayer.BLOCK, pos) < 10 && ((blockstate = level.getBlockState(pos)).isAir() || blockstate.is(Blocks.SNOW)) && Blocks.SNOW.defaultBlockState().canSurvive((LevelReader)level, pos);
        }
        return false;
    }

    public static boolean checkExtraFreezeCondition(ServerLevel level, Holder<Biome> biomeHolder, BlockPos water) {
        if (((Boolean)CommonConfig.Temperature.snowDown.get()).booleanValue() && WeatherManager.getSnowStatus(level, biomeHolder, water, EclipticUtil.isRainingOrSnowingWithSurfaceBiome((Level)level, biomeHolder, water)) == WeatherManager.SnowRenderStatus.SNOW) {
            if (water.getY() >= level.getMinBuildHeight() && water.getY() < level.getMaxBuildHeight() && level.getBrightness(LightLayer.BLOCK, water) < 10) {
                BlockState blockstate = level.getBlockState(water);
                FluidState fluidstate = level.getFluidState(water);
                if (fluidstate.getType() == Fluids.WATER && blockstate.getBlock() instanceof LiquidBlock) {
                    boolean flag;
                    boolean bl = flag = level.isWaterAt(water.west()) && level.isWaterAt(water.east()) && level.isWaterAt(water.north()) && level.isWaterAt(water.south());
                    if (!flag) {
                        return true;
                    }
                }
            }
            return false;
        }
        return false;
    }
}

