/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.item;

import com.teamtea.eclipticseasons.api.EclipticSeasonsApi;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.client.util.ClientCon;
import com.teamtea.eclipticseasons.common.core.snow.SnowyMapChecker;
import com.teamtea.eclipticseasons.config.ClientConfig;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.util.FakePlayer;

public class BroomItem
extends Item {
    public static final int ANIMATION_DURATION = 10;
    private static final int USE_DURATION = 200;

    public BroomItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult useOn(UseOnContext pContext) {
        Player player = pContext.getPlayer();
        if (player != null && this.calculateHitResult((LivingEntity)player).getType() == HitResult.Type.BLOCK) {
            if (!(player instanceof FakePlayer)) {
                player.startUsingItem(pContext.getHand());
            } else {
                FakePlayer fakePlayer = (FakePlayer)player;
                this.onUseTick(pContext.getLevel(), (LivingEntity)fakePlayer, pContext.getItemInHand(), this.getUseDuration(pContext.getItemInHand(), (LivingEntity)player) + 1 - 5);
            }
        }
        return InteractionResult.CONSUME;
    }

    public UseAnim getUseAnimation(ItemStack pStack) {
        return UseAnim.BRUSH;
    }

    public int getUseDuration(ItemStack pStack, LivingEntity pEntity) {
        return 200;
    }

    public void onUseTick(Level level, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration) {
        if (pRemainingUseDuration >= 0) {
            HitResult hitresult = this.calculateHitResult(pLivingEntity);
            double attributeValue = pLivingEntity.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE);
            if (hitresult instanceof BlockHitResult) {
                BlockHitResult blockhitresult = (BlockHitResult)hitresult;
                if (hitresult.getType() == HitResult.Type.BLOCK) {
                    int remainTicks = this.getUseDuration(pStack, pLivingEntity) - pRemainingUseDuration + 1;
                    if (remainTicks % 10 == 5) {
                        SoundEvent soundevent;
                        Block block;
                        BlockPos blockpos = blockhitresult.getBlockPos();
                        BlockState blockstate = level.getBlockState(blockpos);
                        BlockPos pickPos = blockpos.above();
                        BlockState pickState = level.getBlockState(pickPos);
                        HumanoidArm humanoidarm = pLivingEntity.getUsedItemHand() == InteractionHand.MAIN_HAND ? pLivingEntity.getMainArm() : pLivingEntity.getMainArm().getOpposite();
                        boolean shouldSet = EclipticSeasonsApi.getInstance().isSnowyBlock(level, blockstate, blockpos);
                        if (blockstate.shouldSpawnTerrainParticles() && blockstate.getRenderShape() != RenderShape.INVISIBLE) {
                            this.spawnDustParticles(level, blockhitresult, shouldSet ? Blocks.SNOW_BLOCK.defaultBlockState() : blockstate, pLivingEntity.getViewVector(0.0f), humanoidarm);
                        }
                        if ((block = blockstate.getBlock()) instanceof BrushableBlock) {
                            BrushableBlock brushableblock = (BrushableBlock)block;
                            soundevent = brushableblock.getBrushSound();
                        } else {
                            soundevent = SoundEvents.BRUSH_GENERIC;
                        }
                        if (!level.isClientSide() && pickState.is(Blocks.SNOW)) {
                            Player player;
                            level.destroyBlock(pickPos, true, (Entity)pLivingEntity);
                            pStack.hurtAndBreak(pLivingEntity instanceof Player && (player = (Player)pLivingEntity).isCreative() ? 0 : 1, pLivingEntity, LivingEntity.getSlotForHand((InteractionHand)pLivingEntity.getUsedItemHand()));
                        }
                        level.playSound((Entity)pLivingEntity, blockpos, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
                        if (shouldSet && EclipticUtil.canSnowyBlockInteract()) {
                            if (level instanceof ServerLevel) {
                                ServerLevel serverLevel = (ServerLevel)level;
                                SnowyMapChecker.removeSnowyStatus(serverLevel, blockpos);
                            } else {
                                ClientCon.agent.setChunkDirty(SectionPos.of((BlockPos)blockpos));
                            }
                        }
                    }
                    return;
                }
            }
            pLivingEntity.releaseUsingItem();
        } else {
            pLivingEntity.releaseUsingItem();
        }
    }

    private HitResult calculateHitResult(LivingEntity livingEntity) {
        double d;
        Predicate<Entity> predicate = entity -> !entity.isSpectator() && entity.isPickable();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            d = player.blockInteractionRange();
        } else {
            d = 4.5;
        }
        return this.calculateHitResult2((Entity)livingEntity, predicate, d);
    }

    private HitResult calculateHitResult2(Entity projectile, Predicate<Entity> filter, double scale) {
        Vec3 vec3 = projectile.getViewVector(0.0f).scale(scale);
        Level level = projectile.level();
        Vec3 vec31 = projectile.getEyePosition();
        return ProjectileUtil.getHitResult((Vec3)vec31, (Entity)projectile, filter, (Vec3)vec3, (Level)level, (float)0.0f, (ClipContext.Block)ClipContext.Block.OUTLINE);
    }

    private void spawnDustParticles(Level pLevel, BlockHitResult pHitResult, BlockState pState, Vec3 pPos, HumanoidArm pArm) {
        double speed = 3.0;
        int right = pArm == HumanoidArm.RIGHT ? 1 : -1;
        int count = pLevel.getRandom().nextInt(7, 12);
        BlockParticleOption blockparticleoption = new BlockParticleOption(ParticleTypes.BLOCK, pState);
        Direction direction = pHitResult.getDirection();
        DustParticlesDelta brushitem$dustparticlesdelta = DustParticlesDelta.fromDirection(pPos, direction);
        Vec3 vec3 = pHitResult.getLocation();
        for (int k = 0; k < count; ++k) {
            pLevel.addParticle((ParticleOptions)blockparticleoption, vec3.x - (double)(direction == Direction.WEST ? 1.0E-6f : 0.0f), vec3.y, vec3.z - (double)(direction == Direction.NORTH ? 1.0E-6f : 0.0f), brushitem$dustparticlesdelta.xd() * (double)right * speed * pLevel.getRandom().nextDouble(), 0.0, brushitem$dustparticlesdelta.zd() * (double)right * speed * pLevel.getRandom().nextDouble());
        }
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return ItemAbilities.DEFAULT_BRUSH_ACTIONS.contains(itemAbility);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (FMLLoader.getDist() != Dist.CLIENT || !((Boolean)ClientConfig.GUI.itemInformation.get()).booleanValue()) {
            return;
        }
        if (!EclipticUtil.canSnowyBlockInteract()) {
            tooltipComponents.add((Component)Component.translatable((String)"info.eclipticseasons.config.inactive"));
        }
    }

    record DustParticlesDelta(double xd, double yd, double zd) {
        private static final double ALONG_SIDE_DELTA = 1.0;
        private static final double OUT_FROM_SIDE_DELTA = 0.1;

        public static DustParticlesDelta fromDirection(Vec3 pPos, Direction pDirection) {
            double yd = 0.0;
            return switch (pDirection) {
                default -> throw new MatchException(null, null);
                case Direction.DOWN, Direction.UP -> new DustParticlesDelta(pPos.z(), yd, -pPos.x());
                case Direction.NORTH -> new DustParticlesDelta(1.0, yd, -0.1);
                case Direction.SOUTH -> new DustParticlesDelta(-1.0, yd, 0.1);
                case Direction.WEST -> new DustParticlesDelta(-0.1, yd, -1.0);
                case Direction.EAST -> new DustParticlesDelta(0.1, yd, 1.0);
            };
        }
    }
}

